/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;

public abstract class AbstractTransportSetResetModeAction
extends AcknowledgedTransportMasterNodeAction<SetResetModeActionRequest> {
    private static final Logger logger = LogManager.getLogger(AbstractTransportSetResetModeAction.class);

    @Inject
    public AbstractTransportSetResetModeAction(String actionName, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, SetResetModeActionRequest::new, indexNameExpressionResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected abstract boolean isResetMode(ClusterState var1);

    protected abstract String featureName();

    protected abstract ClusterState setState(ClusterState var1, SetResetModeActionRequest var2);

    protected void masterOperation(Task task, final SetResetModeActionRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        boolean isResetModeEnabled = this.isResetMode(state);
        if (request.isEnabled() == isResetModeEnabled) {
            logger.debug(() -> "Reset mode noop for [" + this.featureName() + "]");
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
            return;
        }
        logger.debug(() -> Strings.format((String)"Starting to set [reset_mode] for [%s] to [%s] from [%s]", (Object[])new Object[]{this.featureName(), request.isEnabled(), isResetModeEnabled}));
        ActionListener wrappedListener = ActionListener.wrap(r -> {
            logger.debug(() -> "Completed reset mode request for [" + this.featureName() + "]");
            listener.onResponse(r);
        }, e -> {
            logger.debug(() -> "Completed reset mode for [" + this.featureName() + "] request but with failure", (Throwable)e);
            listener.onFailure(e);
        });
        ActionListener clusterStateUpdateListener = wrappedListener.delegateFailureAndWrap((delegate, acknowledgedResponse) -> {
            if (!acknowledgedResponse.isAcknowledged()) {
                delegate.onFailure((Exception)new ElasticsearchTimeoutException("Unknown error occurred while updating cluster state", new Object[0]));
                return;
            }
            delegate.onResponse(acknowledgedResponse);
        });
        this.submitUnbatchedTask(this.featureName() + "-set-reset-mode", (ClusterStateUpdateTask)new AckedClusterStateUpdateTask(request, clusterStateUpdateListener){

            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                logger.trace(() -> Strings.format((String)"Cluster update response built for [%s]: %s", (Object[])new Object[]{AbstractTransportSetResetModeAction.this.featureName(), acknowledged}));
                return AcknowledgedResponse.of((boolean)acknowledged);
            }

            public ClusterState execute(ClusterState currentState) {
                logger.trace(() -> "Executing cluster state update for [" + AbstractTransportSetResetModeAction.this.featureName() + "]");
                return AbstractTransportSetResetModeAction.this.setState(currentState, request);
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(SetResetModeActionRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

