/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;

public final class ClientHelper {
    private static final Pattern authorizationHeaderPattern = Pattern.compile("\\s*" + Pattern.quote("Authorization") + "\\s*", 2);
    public static final Set<String> SECURITY_HEADER_FILTERS = Set.of("es-security-runas-user", "_xpack_security_authentication", "_xpack_security_secondary_authc");
    @Deprecated
    public static final String ACTION_ORIGIN_TRANSIENT_NAME = "action.origin";
    public static final String SECURITY_ORIGIN = "security";
    public static final String SECURITY_PROFILE_ORIGIN = "security_profile";
    public static final String WATCHER_ORIGIN = "watcher";
    public static final String ML_ORIGIN = "ml";
    public static final String INDEX_LIFECYCLE_ORIGIN = "index_lifecycle";
    public static final String MONITORING_ORIGIN = "monitoring";
    public static final String DEPRECATION_ORIGIN = "deprecation";
    public static final String ROLLUP_ORIGIN = "rollup";
    public static final String ENRICH_ORIGIN = "enrich";
    public static final String TRANSFORM_ORIGIN = "transform";
    public static final String ASYNC_SEARCH_ORIGIN = "async_search";
    public static final String IDP_ORIGIN = "idp";
    public static final String PROFILING_ORIGIN = "profiling";
    public static final String STACK_ORIGIN = "stack";
    public static final String SEARCHABLE_SNAPSHOTS_ORIGIN = "searchable_snapshots";
    public static final String LOGSTASH_MANAGEMENT_ORIGIN = "logstash_management";
    public static final String FLEET_ORIGIN = "fleet";
    public static final String ENT_SEARCH_ORIGIN = "enterprise_search";
    public static final String CONNECTORS_ORIGIN = "connectors";
    public static final String INFERENCE_ORIGIN = "inference";
    public static final String APM_ORIGIN = "apm";
    public static final String OTEL_ORIGIN = "otel";

    public static void assertNoAuthorizationHeader(Map<String, String> headers) {
        if (Assertions.ENABLED) {
            for (String header : headers.keySet()) {
                if (authorizationHeaderPattern.matcher(header).find()) assert (false) : "headers contain \"Authorization\"";
            }
        }
    }

    public static Map<String, String> filterSecurityHeaders(Map<String, String> headers) {
        if (SECURITY_HEADER_FILTERS.containsAll(headers.keySet())) {
            return headers;
        }
        return Objects.requireNonNull(headers).entrySet().stream().filter(e -> SECURITY_HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> getPersistableSafeSecurityHeaders(ThreadContext threadContext, ClusterState clusterState) {
        return ClientHelper.maybeRewriteAuthenticationHeadersForVersion(ClientHelper.filterSecurityHeaders(threadContext.getHeaders()), (CheckedFunction<String, Authentication, IOException>)((CheckedFunction)key -> new AuthenticationContextSerializer((String)key).readFromContext(threadContext)), clusterState.getMinTransportVersion());
    }

    public static Map<String, String> getPersistableSafeSecurityHeaders(Map<String, String> headers, ClusterState clusterState) {
        CheckedFunction authenticationReader = key -> {
            String authHeader = (String)headers.get(key);
            return authHeader == null ? null : AuthenticationContextSerializer.decode(authHeader);
        };
        return ClientHelper.maybeRewriteAuthenticationHeadersForVersion(ClientHelper.filterSecurityHeaders(headers), (CheckedFunction<String, Authentication, IOException>)authenticationReader, clusterState.getMinTransportVersion());
    }

    private static Map<String, String> maybeRewriteAuthenticationHeadersForVersion(Map<String, String> filteredHeaders, CheckedFunction<String, Authentication, IOException> authenticationReader, TransportVersion minNodeVersion) {
        String secondaryHeader;
        HashMap<String, String> newHeaders = null;
        String authHeader = ClientHelper.maybeRewriteSingleAuthenticationHeaderForVersion(authenticationReader, "_xpack_security_authentication", minNodeVersion);
        if (authHeader != null) {
            newHeaders = new HashMap<String, String>();
            newHeaders.put("_xpack_security_authentication", authHeader);
        }
        if ((secondaryHeader = ClientHelper.maybeRewriteSingleAuthenticationHeaderForVersion(authenticationReader, "_xpack_security_secondary_authc", minNodeVersion)) != null) {
            if (newHeaders == null) {
                newHeaders = new HashMap();
            }
            newHeaders.put("_xpack_security_secondary_authc", secondaryHeader);
        }
        if (newHeaders != null) {
            HashMap<String, String> mutableHeaders = new HashMap<String, String>(filteredHeaders);
            mutableHeaders.putAll(newHeaders);
            return Map.copyOf(mutableHeaders);
        }
        return filteredHeaders;
    }

    private static String maybeRewriteSingleAuthenticationHeaderForVersion(CheckedFunction<String, Authentication, IOException> authenticationReader, String authenticationHeaderKey, TransportVersion minNodeVersion) {
        try {
            Authentication authentication = (Authentication)authenticationReader.apply((Object)authenticationHeaderKey);
            if (authentication != null && authentication.getEffectiveSubject().getTransportVersion().after((VersionId)minNodeVersion)) {
                return authentication.maybeRewriteForOlderVersion(minNodeVersion).encode();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to read authentication with key [" + authenticationHeaderKey + "]", e);
        }
        return null;
    }

    private ClientHelper() {
    }

    @Deprecated
    public static Client clientWithOrigin(Client client, String origin) {
        return new OriginSettingClient(client, origin);
    }

    public static <Request, Response> void executeAsyncWithOrigin(ThreadContext threadContext, String origin, Request request, ActionListener<Response> listener, BiConsumer<Request, ActionListener<Response>> consumer) {
        Supplier supplier = threadContext.newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = threadContext.stashWithOrigin(origin);){
            consumer.accept(request, (ActionListener<Response>)new ContextPreservingActionListener(supplier, listener));
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeAsyncWithOrigin(Client client, String origin, ActionType<Response> action, Request request, ActionListener<Response> listener) {
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), origin, request, listener, (Request r, ActionListener<Response> l) -> client.execute(action, r, l));
    }

    public static <T extends ActionResponse> T executeWithHeaders(Map<String, String> headers, String origin, Client client, Supplier<T> supplier) {
        Map<String, String> filteredHeaders = ClientHelper.filterSecurityHeaders(headers);
        if (filteredHeaders.isEmpty()) {
            try (ThreadContext.StoredContext ignore = client.threadPool().getThreadContext().stashWithOrigin(origin);){
                ActionResponse actionResponse = (ActionResponse)supplier.get();
                return (T)actionResponse;
            }
        }
        try (ThreadContext.StoredContext ignore = client.threadPool().getThreadContext().stashContext();){
            client.threadPool().getThreadContext().copyHeaders(filteredHeaders.entrySet());
            ActionResponse actionResponse = (ActionResponse)supplier.get();
            return (T)actionResponse;
        }
    }

    public static <Request extends ActionRequest, Response extends ActionResponse> void executeWithHeadersAsync(Map<String, String> headers, String origin, Client client, ActionType<Response> action, Request request, ActionListener<Response> listener) {
        ClientHelper.executeWithHeadersAsync(client.threadPool().getThreadContext(), headers, origin, request, listener, (Request r, ActionListener<Response> l) -> client.execute(action, r, l));
    }

    public static <Request, Response> void executeWithHeadersAsync(ThreadContext threadContext, Map<String, String> headers, String origin, Request request, ActionListener<Response> listener, BiConsumer<Request, ActionListener<Response>> consumer) {
        Map<String, String> filteredHeaders = ClientHelper.filterSecurityHeaders(headers);
        if (filteredHeaders.isEmpty()) {
            ClientHelper.executeAsyncWithOrigin(threadContext, origin, request, listener, consumer);
        } else {
            Supplier supplier = threadContext.newRestorableContext(false);
            try (ThreadContext.StoredContext ignore = ClientHelper.stashWithHeaders(threadContext, filteredHeaders);){
                consumer.accept(request, (ActionListener<Response>)new ContextPreservingActionListener(supplier, listener));
            }
        }
    }

    private static ThreadContext.StoredContext stashWithHeaders(ThreadContext threadContext, Map<String, String> headers) {
        ThreadContext.StoredContext storedContext = threadContext.stashContext();
        ClientHelper.assertNoAuthorizationHeader(headers);
        threadContext.copyHeaders(headers.entrySet());
        return storedContext;
    }
}

