/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum SortMode implements Writeable
{
    MIN,
    MAX,
    SUM,
    AVG,
    MEDIAN;


    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static SortMode readFromStream(StreamInput in) throws IOException {
        return in.readEnum(SortMode.class);
    }

    public static SortMode fromString(String str) {
        Objects.requireNonNull(str, "input string is null");
        return switch (str.toLowerCase(Locale.ROOT)) {
            case "min" -> MIN;
            case "max" -> MAX;
            case "sum" -> SUM;
            case "avg" -> AVG;
            case "median" -> MEDIAN;
            default -> throw new IllegalArgumentException("Unknown SortMode [" + str + "]");
        };
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

