/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank.rerank;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rank.context.QueryPhaseRankCoordinatorContext;
import org.elasticsearch.search.rank.feature.RankFeatureDoc;
import org.elasticsearch.search.rank.feature.RankFeatureShardResult;

public class RerankingQueryPhaseRankCoordinatorContext
extends QueryPhaseRankCoordinatorContext {
    public RerankingQueryPhaseRankCoordinatorContext(int windowSize) {
        super(windowSize);
    }

    @Override
    public ScoreDoc[] rankQueryPhaseResults(List<QuerySearchResult> querySearchResults, SearchPhaseController.TopDocsStats topDocStats) {
        ArrayList<RankFeatureDoc> rankDocs = new ArrayList<RankFeatureDoc>();
        for (int i = 0; i < querySearchResults.size(); ++i) {
            QuerySearchResult querySearchResult = querySearchResults.get(i);
            RankFeatureShardResult shardResult = (RankFeatureShardResult)querySearchResult.getRankShardResult();
            if (shardResult == null) continue;
            for (RankFeatureDoc frd : shardResult.rankFeatureDocs) {
                frd.shardIndex = i;
                rankDocs.add(frd);
            }
        }
        rankDocs.sort(Comparator.comparing(doc -> Float.valueOf(doc.score)).reversed());
        ScoreDoc[] topResults = (RankFeatureDoc[])rankDocs.stream().limit(this.rankWindowSize).toArray(RankFeatureDoc[]::new);
        assert (topDocStats.fetchHits == 0L);
        topDocStats.fetchHits = topResults.length;
        return topResults;
    }
}

