/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.fetch.subphase.highlight.FieldHighlightContext;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.fetch.subphase.highlight.Highlighter;
import org.elasticsearch.search.fetch.subphase.highlight.SearchHighlightContext;

public class HighlightPhase
implements FetchSubPhase {
    private final Map<String, Highlighter> highlighters;

    public HighlightPhase(Map<String, Highlighter> highlighters) {
        this.highlighters = highlighters;
    }

    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) {
        if (context.highlight() == null) {
            return null;
        }
        return this.getProcessor(context, context.highlight(), context.parsedQuery().query());
    }

    public FetchSubPhaseProcessor getProcessor(FetchContext context, SearchHighlightContext highlightContext, Query query) {
        HashMap<String, Object> sharedCache = new HashMap<String, Object>();
        final FieldContext fieldContext = this.contextBuilders(context, highlightContext, query, sharedCache);
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return fieldContext.storedFieldsSpec;
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                HashMap<String, HighlightField> highlightFields = new HashMap<String, HighlightField>();
                Map<String, Function<FetchSubPhase.HitContext, FieldHighlightContext>> contextBuilders = fieldContext.builders;
                for (String field : contextBuilders.keySet()) {
                    FieldHighlightContext fieldContext2 = contextBuilders.get(field).apply(hitContext);
                    Highlighter highlighter = HighlightPhase.this.getHighlighter(fieldContext2.field);
                    HighlightField highlightField = highlighter.highlight(fieldContext2);
                    if (highlightField == null) continue;
                    highlightFields.put(field, new HighlightField(field, highlightField.fragments()));
                }
                hitContext.hit().highlightFields(highlightFields);
            }
        };
    }

    private Highlighter getHighlighter(SearchHighlightContext.Field field) {
        Highlighter highlighter;
        String highlighterType = field.fieldOptions().highlighterType();
        if (highlighterType == null) {
            highlighterType = "unified";
        }
        if ((highlighter = this.highlighters.get(highlighterType)) == null) {
            throw new IllegalArgumentException("unknown highlighter type [" + highlighterType + "] for the field [" + field.field() + "]");
        }
        return highlighter;
    }

    private FieldContext contextBuilders(FetchContext context, SearchHighlightContext highlightContext, Query query, Map<String, Object> sharedCache) {
        LinkedHashMap<String, Function<FetchSubPhase.HitContext, FieldHighlightContext>> builders = new LinkedHashMap<String, Function<FetchSubPhase.HitContext, FieldHighlightContext>>();
        StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.NO_REQUIREMENTS;
        for (SearchHighlightContext.Field field : highlightContext.fields()) {
            Highlighter highlighter = this.getHighlighter(field);
            Set<String> fieldNamesToHighlight = context.getSearchExecutionContext().getMatchingFieldNames(field.field());
            boolean fieldNameContainsWildcards = field.field().contains("*");
            HashSet<String> storedFields = new HashSet<String>();
            boolean sourceRequired = false;
            for (String fieldName : fieldNamesToHighlight) {
                MappedFieldType fieldType = context.getSearchExecutionContext().getFieldType(fieldName);
                if (fieldNameContainsWildcards && (!fieldType.typeName().equals("text") && !fieldType.typeName().equals("keyword") && !fieldType.typeName().equals("match_only_text") || !highlighter.canHighlight(fieldType))) continue;
                if (fieldType.isStored()) {
                    storedFields.add(fieldType.name());
                } else {
                    sourceRequired = true;
                }
                Query highlightQuery = field.fieldOptions().highlightQuery();
                builders.put(fieldName, hc -> new FieldHighlightContext(fieldType.name(), field, fieldType, context, (FetchSubPhase.HitContext)hc, highlightQuery == null ? query : highlightQuery, sharedCache));
            }
            storedFieldsSpec = storedFieldsSpec.merge(new StoredFieldsSpec(sourceRequired, false, storedFields));
        }
        return new FieldContext(storedFieldsSpec, builders);
    }

    private record FieldContext(StoredFieldsSpec storedFieldsSpec, Map<String, Function<FetchSubPhase.HitContext, FieldHighlightContext>> builders) {
    }
}

