/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

class AvgAggregator
extends NumericMetricsAggregator.SingleDoubleValue {
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DocValueFormat format;

    AvgAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, valuesSourceConfig, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.format = valuesSourceConfig.format();
        BigArrays bigArrays = context.bigArrays();
        this.counts = bigArrays.newLongArray(1L, true);
        this.sums = bigArrays.newDoubleArray(1L, true);
        this.compensations = bigArrays.newDoubleArray(1L, true);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final SortedNumericDoubleValues values, LeafBucketCollector sub) {
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    AvgAggregator.this.maybeGrow(bucket);
                    int valueCount = values.docValueCount();
                    AvgAggregator.this.counts.increment(bucket, valueCount);
                    kahanSummation.reset(AvgAggregator.this.sums.get(bucket), AvgAggregator.this.compensations.get(bucket));
                    for (int i = 0; i < valueCount; ++i) {
                        kahanSummation.add(values.nextValue());
                    }
                    AvgAggregator.this.sums.set(bucket, kahanSummation.value());
                    AvgAggregator.this.compensations.set(bucket, kahanSummation.delta());
                }
            }
        };
    }

    @Override
    protected LeafBucketCollector getLeafCollector(final NumericDoubleValues values, LeafBucketCollector sub) {
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, (Object)values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    AvgAggregator.this.maybeGrow(bucket);
                    AvgAggregator.this.counts.increment(bucket, 1L);
                    kahanSummation.reset(AvgAggregator.this.sums.get(bucket), AvgAggregator.this.compensations.get(bucket));
                    kahanSummation.add(values.doubleValue());
                    AvgAggregator.this.sums.set(bucket, kahanSummation.value());
                    AvgAggregator.this.compensations.set(bucket, kahanSummation.delta());
                }
            }
        };
    }

    private void maybeGrow(long bucket) {
        if (bucket >= this.counts.size()) {
            this.counts = this.bigArrays().grow(this.counts, bucket + 1L);
            this.sums = this.bigArrays().grow(this.sums, bucket + 1L);
            this.compensations = this.bigArrays().grow(this.compensations, bucket + 1L);
        }
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return InternalAvg.empty(this.name, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.sums, this.compensations});
    }
}

