/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Iterator;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.MultiDenseVectorScriptDocValues;
import org.elasticsearch.script.field.vectors.FloatMultiDenseVector;
import org.elasticsearch.script.field.vectors.MultiDenseVector;
import org.elasticsearch.script.field.vectors.MultiDenseVectorDocValuesField;

public class FloatMultiDenseVectorDocValuesField
extends MultiDenseVectorDocValuesField {
    private final BinaryDocValues input;
    private final BinaryDocValues magnitudes;
    private boolean decoded;
    private final int dims;
    private BytesRef value;
    private BytesRef magnitudesValue;
    private FloatVectorIterator vectorValues;
    private int numVectors;
    private float[] buffer;

    public FloatMultiDenseVectorDocValuesField(BinaryDocValues input, BinaryDocValues magnitudes, String name, DenseVectorFieldMapper.ElementType elementType, int dims) {
        super(name, elementType);
        this.input = input;
        this.magnitudes = magnitudes;
        this.dims = dims;
        this.buffer = new float[dims];
    }

    @Override
    public void setNextDocId(int docId) throws IOException {
        this.decoded = false;
        if (this.input.advanceExact(docId)) {
            boolean magnitudesFound = this.magnitudes.advanceExact(docId);
            assert (magnitudesFound);
            this.value = this.input.binaryValue();
            assert (this.value.length % (4 * this.dims) == 0);
            this.numVectors = this.value.length / (4 * this.dims);
            this.magnitudesValue = this.magnitudes.binaryValue();
            assert (this.magnitudesValue.length == 4 * this.numVectors);
        } else {
            this.value = null;
            this.magnitudesValue = null;
            this.numVectors = 0;
        }
    }

    @Override
    public MultiDenseVectorScriptDocValues toScriptDocValues() {
        return new MultiDenseVectorScriptDocValues(this, this.dims);
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public MultiDenseVector get() {
        if (this.isEmpty()) {
            return MultiDenseVector.EMPTY;
        }
        this.decodeVectorIfNecessary();
        return new FloatMultiDenseVector(this.vectorValues, this.magnitudesValue, this.numVectors, this.dims);
    }

    @Override
    public MultiDenseVector get(MultiDenseVector defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        this.decodeVectorIfNecessary();
        return new FloatMultiDenseVector(this.vectorValues, this.magnitudesValue, this.numVectors, this.dims);
    }

    @Override
    public MultiDenseVector getInternal() {
        return this.get(null);
    }

    @Override
    public int size() {
        return this.value == null ? 0 : this.value.length / (4 * this.dims);
    }

    private void decodeVectorIfNecessary() {
        if (!this.decoded && this.value != null) {
            this.vectorValues = new FloatVectorIterator(this.value, this.buffer, this.numVectors);
            this.decoded = true;
        }
    }

    static class FloatVectorIterator
    implements Iterator<float[]> {
        private final float[] buffer;
        private final FloatBuffer vectorValues;
        private final int size;
        private int idx = 0;

        FloatVectorIterator(BytesRef vectorValues, float[] buffer, int size) {
            assert (vectorValues.length == buffer.length * 4 * size);
            this.vectorValues = ByteBuffer.wrap(vectorValues.bytes, vectorValues.offset, vectorValues.length).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.size;
        }

        @Override
        public float[] next() {
            if (!this.hasNext()) {
                throw new IllegalArgumentException("No more elements in the iterator");
            }
            this.vectorValues.get(this.buffer);
            ++this.idx;
            return this.buffer;
        }
    }
}

