/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.ExceptionsHelper;

public class TragicExceptionHolder {
    private final AtomicReference<Exception> tragedy = new AtomicReference();

    public void setTragicException(Exception ex) {
        assert (ex != null);
        if (this.tragedy.compareAndSet(null, ex)) {
            return;
        }
        Exception tragedy = this.tragedy.get();
        if (ExceptionsHelper.unwrapCausesAndSuppressed(ex, e -> e == tragedy).isEmpty()) {
            tragedy.addSuppressed(ex);
        } else assert (ex == tragedy || ex instanceof AlreadyClosedException) : new AssertionError("must be ACE or tragic exception", ex);
    }

    public Exception get() {
        return this.tragedy.get();
    }
}

