/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldBlockLoader;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.XContentType;

public class SourceFieldMapper
extends MetadataFieldMapper {
    public static final NodeFeature SYNTHETIC_SOURCE_FALLBACK = new NodeFeature("mapper.source.synthetic_source_fallback");
    public static final NodeFeature SYNTHETIC_SOURCE_STORED_FIELDS_ADVANCE_FIX = new NodeFeature("mapper.source.synthetic_source_stored_fields_advance_fix");
    public static final NodeFeature SYNTHETIC_SOURCE_WITH_COPY_TO_AND_DOC_VALUES_FALSE_SUPPORT = new NodeFeature("mapper.source.synthetic_source_with_copy_to_and_doc_values_false");
    public static final NodeFeature SYNTHETIC_SOURCE_COPY_TO_FIX = new NodeFeature("mapper.source.synthetic_source_copy_to_fix");
    public static final NodeFeature SYNTHETIC_SOURCE_COPY_TO_INSIDE_OBJECTS_FIX = new NodeFeature("mapper.source.synthetic_source_copy_to_inside_objects_fix");
    public static final NodeFeature REMOVE_SYNTHETIC_SOURCE_ONLY_VALIDATION = new NodeFeature("mapper.source.remove_synthetic_source_only_validation");
    public static final NodeFeature SOURCE_MODE_FROM_INDEX_SETTING = new NodeFeature("mapper.source.mode_from_index_setting");
    public static final String NAME = "_source";
    public static final String RECOVERY_SOURCE_NAME = "_recovery_source";
    public static final String CONTENT_TYPE = "_source";
    public static final String LOSSY_PARAMETERS_ALLOWED_SETTING_NAME = "index.lossy.source-mapping-parameters";
    public static final Setting<Mode> INDEX_MAPPER_SOURCE_MODE_SETTING = Setting.enumSetting(Mode.class, settings -> {
        IndexMode indexMode = IndexSettings.MODE.get((Settings)settings);
        return indexMode.defaultSourceMode().name();
    }, "index.mapping.source.mode", value -> {}, Setting.Property.Final, Setting.Property.IndexScope);
    public static final String DEPRECATION_WARNING = "Configuring source mode in mappings is deprecated and will be removed in future versions. Use [index.mapping.source.mode] index setting instead.";
    private static final SourceFieldMapper DEFAULT = new SourceFieldMapper(null, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false);
    private static final SourceFieldMapper STORED = new SourceFieldMapper(Mode.STORED, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false);
    private static final SourceFieldMapper SYNTHETIC = new SourceFieldMapper(Mode.SYNTHETIC, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false);
    private static final SourceFieldMapper DISABLED = new SourceFieldMapper(Mode.DISABLED, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, false);
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.ConfigurableTypeParser(c -> {
        IndexMode indexMode = c.getIndexSettings().getMode();
        if (indexMode == IndexMode.TIME_SERIES && c.getIndexSettings().getIndexVersionCreated().before(IndexVersions.V_8_7_0)) {
            return DEFAULT;
        }
        Mode settingSourceMode = INDEX_MAPPER_SOURCE_MODE_SETTING.get(c.getSettings());
        if (indexMode == IndexMode.STANDARD && settingSourceMode == Mode.STORED) {
            return DEFAULT;
        }
        if (c.indexVersionCreated().onOrAfter(IndexVersions.DEPRECATE_SOURCE_MODE_MAPPER)) {
            return SourceFieldMapper.resolveStaticInstance(settingSourceMode);
        }
        return new SourceFieldMapper(settingSourceMode, Explicit.IMPLICIT_TRUE, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY, true);
    }, c -> new Builder(c.getIndexSettings().getMode(), c.getSettings(), c.indexVersionCreated().onOrAfter(IndexVersions.SOURCE_MAPPER_LOSSY_PARAMS_CHECK), c.indexVersionCreated().before(IndexVersions.DEPRECATE_SOURCE_MODE_MAPPER)));
    @Nullable
    private final Mode mode;
    private final boolean serializeMode;
    private final Explicit<Boolean> enabled;
    private final boolean complete;
    private final String[] includes;
    private final String[] excludes;
    private final SourceFilter sourceFilter;

    private static SourceFieldMapper toType(FieldMapper in) {
        return (SourceFieldMapper)in;
    }

    private static SourceFieldMapper resolveStaticInstance(Mode sourceMode) {
        return switch (sourceMode) {
            default -> throw new IncompatibleClassChangeError();
            case Mode.SYNTHETIC -> SYNTHETIC;
            case Mode.STORED -> STORED;
            case Mode.DISABLED -> DISABLED;
        };
    }

    private SourceFieldMapper(Mode mode, Explicit<Boolean> enabled, String[] includes, String[] excludes, boolean serializeMode) {
        super(new SourceFieldType(enabled.explicit() && enabled.value() != false || !enabled.explicit() && mode != Mode.DISABLED));
        this.mode = mode;
        this.enabled = enabled;
        this.sourceFilter = SourceFieldMapper.buildSourceFilter(includes, excludes);
        this.includes = includes;
        this.excludes = excludes;
        this.complete = this.stored() && this.sourceFilter == null;
        this.serializeMode = serializeMode;
    }

    private static SourceFilter buildSourceFilter(String[] includes, String[] excludes) {
        if (CollectionUtils.isEmpty(includes) && CollectionUtils.isEmpty(excludes)) {
            return null;
        }
        return new SourceFilter(includes, excludes);
    }

    private boolean stored() {
        if (this.enabled.explicit() || this.mode == null) {
            return this.enabled.value();
        }
        return this.mode == Mode.STORED;
    }

    public boolean enabled() {
        if (this.enabled.explicit()) {
            return this.enabled.value();
        }
        if (this.mode != null) {
            return this.mode != Mode.DISABLED;
        }
        return this.enabled.value();
    }

    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void preParse(DocumentParserContext context) throws IOException {
        boolean enableRecoverySource;
        XContentType contentType;
        BytesReference originalSource = context.sourceToParse().source();
        BytesReference adaptedSource = this.applyFilters(originalSource, contentType = context.sourceToParse().getXContentType());
        if (adaptedSource != null) {
            BytesRef ref = adaptedSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), ref.bytes, ref.offset, ref.length));
        }
        if ((enableRecoverySource = context.indexSettings().isRecoverySourceEnabled()) && originalSource != null && adaptedSource != originalSource) {
            BytesRef ref = originalSource.toBytesRef();
            context.doc().add((IndexableField)new StoredField(RECOVERY_SOURCE_NAME, ref.bytes, ref.offset, ref.length));
            context.doc().add((IndexableField)new NumericDocValuesField(RECOVERY_SOURCE_NAME, 1L));
        }
    }

    @Nullable
    public BytesReference applyFilters(@Nullable BytesReference originalSource, @Nullable XContentType contentType) throws IOException {
        if (!this.stored()) {
            return null;
        }
        if (originalSource != null && this.sourceFilter != null) {
            return Source.fromBytes(originalSource, contentType).filter(this.sourceFilter).internalSourceRef();
        }
        return originalSource;
    }

    @Override
    protected String contentType() {
        return "_source";
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(null, Settings.EMPTY, false, this.serializeMode).init(this);
    }

    public SourceLoader newSourceLoader(Mapping mapping, SourceFieldMetrics metrics) {
        if (this.mode == Mode.SYNTHETIC) {
            return new SourceLoader.Synthetic(mapping::syntheticFieldLoader, metrics);
        }
        return SourceLoader.FROM_STORED_SOURCE;
    }

    public boolean isSynthetic() {
        return this.mode == Mode.SYNTHETIC;
    }

    public static boolean isSynthetic(IndexSettings indexSettings) {
        return INDEX_MAPPER_SOURCE_MODE_SETTING.get(indexSettings.getSettings()) == Mode.SYNTHETIC;
    }

    public static boolean isStored(IndexSettings indexSettings) {
        return INDEX_MAPPER_SOURCE_MODE_SETTING.get(indexSettings.getSettings()) == Mode.STORED;
    }

    public boolean isDisabled() {
        return this.mode == Mode.DISABLED;
    }

    public boolean isStored() {
        return this.mode == null || this.mode == Mode.STORED;
    }

    public static enum Mode {
        DISABLED,
        STORED,
        SYNTHETIC;

    }

    static final class SourceFieldType
    extends MappedFieldType {
        private final boolean enabled;

        private SourceFieldType(boolean enabled) {
            super("_source", false, enabled, false, TextSearchInfo.NONE, Collections.emptyMap());
            this.enabled = enabled;
        }

        @Override
        public String typeName() {
            return "_source";
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "The _source field is not searchable", new Object[0]);
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.enabled) {
                return new SourceFieldBlockLoader();
            }
            return BlockLoader.CONSTANT_NULLS;
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder {
        private final FieldMapper.Parameter<Explicit<Boolean>> enabled = FieldMapper.Parameter.explicitBoolParam("enabled", false, m -> SourceFieldMapper.toType((FieldMapper)m).enabled, true).setSerializerCheck((includeDefaults, isConfigured, value) -> value.explicit()).setMergeValidator((previous, current, conflicts) -> previous.value() == current.value() || (Boolean)previous.value() != false && (Boolean)current.value() == false);
        private final FieldMapper.Parameter<Mode> mode;
        private final FieldMapper.Parameter<List<String>> includes = FieldMapper.Parameter.stringArrayParam("includes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).includes));
        private final FieldMapper.Parameter<List<String>> excludes = FieldMapper.Parameter.stringArrayParam("excludes", false, m -> Arrays.asList(SourceFieldMapper.toType((FieldMapper)m).excludes));
        private final Settings settings;
        private final IndexMode indexMode;
        private boolean serializeMode;
        private final boolean supportsNonDefaultParameterValues;

        public Builder(IndexMode indexMode, Settings settings, boolean supportsCheckForNonDefaultParams, boolean serializeMode) {
            super("_source");
            this.settings = settings;
            this.indexMode = indexMode;
            this.supportsNonDefaultParameterValues = !supportsCheckForNonDefaultParams || settings.getAsBoolean(SourceFieldMapper.LOSSY_PARAMETERS_ALLOWED_SETTING_NAME, true) != false;
            this.serializeMode = serializeMode;
            this.mode = new FieldMapper.Parameter<Mode>("mode", true, () -> null, (n, c, o) -> Mode.valueOf(o.toString().toUpperCase(Locale.ROOT)), m -> SourceFieldMapper.toType((FieldMapper)m).enabled.explicit() ? null : SourceFieldMapper.toType((FieldMapper)m).mode, (b, n, v) -> b.field(n, v.toString().toLowerCase(Locale.ROOT)), v -> v.toString().toLowerCase(Locale.ROOT)).setMergeValidator((previous, current, conflicts) -> previous == current || current != Mode.STORED).setSerializerCheck((includeDefaults, isConfigured, value) -> serializeMode && value != null);
        }

        public Builder setSynthetic() {
            this.mode.setValue(Mode.SYNTHETIC);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.enabled, this.mode, this.includes, this.excludes};
        }

        private boolean isDefault() {
            return this.enabled.get().value() != false && this.includes.getValue().isEmpty() && this.excludes.getValue().isEmpty();
        }

        @Override
        public SourceFieldMapper build() {
            if (this.enabled.getValue().explicit() && this.mode.get() != null) {
                throw new MapperParsingException("Cannot set both [mode] and [enabled] parameters");
            }
            Mode sourceMode = this.resolveSourceMode();
            if (!this.supportsNonDefaultParameterValues) {
                ArrayList<String> disallowed = new ArrayList<String>();
                if (!this.enabled.get().value().booleanValue()) {
                    disallowed.add("enabled");
                }
                if (!this.includes.get().isEmpty()) {
                    disallowed.add("includes");
                }
                if (!this.excludes.get().isEmpty()) {
                    disallowed.add("excludes");
                }
                if (this.mode.get() == Mode.DISABLED) {
                    disallowed.add("mode=disabled");
                }
                if (!disallowed.isEmpty()) {
                    throw new MapperParsingException(disallowed.size() == 1 ? "Parameter [" + (String)disallowed.get(0) + "] is not allowed in source" : "Parameters [" + String.join((CharSequence)",", disallowed) + "] are not allowed in source");
                }
            }
            if (!(sourceMode != Mode.SYNTHETIC || this.includes.getValue().isEmpty() && this.excludes.getValue().isEmpty())) {
                throw new IllegalArgumentException("filtering the stored _source is incompatible with synthetic source");
            }
            if (this.mode.isConfigured()) {
                this.serializeMode = true;
            }
            SourceFieldMapper sourceFieldMapper = this.isDefault() && sourceMode == null ? DEFAULT : (this.isDefault() && !this.serializeMode && sourceMode != null ? SourceFieldMapper.resolveStaticInstance(sourceMode) : new SourceFieldMapper(sourceMode, this.enabled.get(), this.includes.getValue().toArray(Strings.EMPTY_ARRAY), this.excludes.getValue().toArray(Strings.EMPTY_ARRAY), this.serializeMode));
            if (this.indexMode != null) {
                this.indexMode.validateSourceFieldMapper(sourceFieldMapper);
            }
            return sourceFieldMapper;
        }

        private Mode resolveSourceMode() {
            if (INDEX_MAPPER_SOURCE_MODE_SETTING.exists(this.settings)) {
                return INDEX_MAPPER_SOURCE_MODE_SETTING.get(this.settings);
            }
            if (this.mode.get() == null) {
                if (this.indexMode == null || this.indexMode == IndexMode.STANDARD) {
                    return null;
                }
                return this.indexMode.defaultSourceMode();
            }
            return this.mode.get();
        }
    }

    public static class Defaults {
        public static final String NAME = "_source";
        public static final FieldType FIELD_TYPE;

        static {
            FieldType ft = new FieldType();
            ft.setIndexOptions(IndexOptions.NONE);
            ft.setStored(true);
            ft.setOmitNorms(true);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType(ft);
        }
    }
}

