/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.elasticsearch.index.analysis.AnalysisMode;
import org.elasticsearch.index.analysis.AnalyzerComponentsProvider;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.mapper.MapperException;

public class NamedAnalyzer
extends DelegatingAnalyzerWrapper {
    private final String name;
    private final AnalyzerScope scope;
    private final Analyzer analyzer;
    private final int positionIncrementGap;
    private final AnalysisMode analysisMode;
    static final Analyzer.ReuseStrategy ERROR_STRATEGY = new Analyzer.ReuseStrategy(){

        public Analyzer.TokenStreamComponents getReusableComponents(Analyzer a, String f) {
            throw new IllegalStateException("NamedAnalyzer cannot be wrapped with a wrapper, only a delegator");
        }

        public void setReusableComponents(Analyzer a, String f, Analyzer.TokenStreamComponents c) {
            throw new IllegalStateException("NamedAnalyzer cannot be wrapped with a wrapper, only a delegator");
        }
    };

    public NamedAnalyzer(NamedAnalyzer analyzer, int positionIncrementGap) {
        this(analyzer.name(), analyzer.scope(), analyzer.analyzer(), positionIncrementGap);
    }

    public NamedAnalyzer(String name, AnalyzerScope scope, Analyzer analyzer) {
        this(name, scope, analyzer, Integer.MIN_VALUE);
    }

    public NamedAnalyzer(String name, AnalyzerScope scope, Analyzer analyzer, int positionIncrementGap) {
        super(ERROR_STRATEGY);
        this.name = name;
        this.scope = scope;
        this.analyzer = analyzer;
        this.positionIncrementGap = positionIncrementGap;
        this.analysisMode = analyzer instanceof AnalyzerComponentsProvider ? ((AnalyzerComponentsProvider)analyzer).getComponents().analysisMode() : AnalysisMode.ALL;
    }

    public String name() {
        return this.name;
    }

    public AnalyzerScope scope() {
        return this.scope;
    }

    public AnalysisMode getAnalysisMode() {
        return this.analysisMode;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.analyzer;
    }

    public int getPositionIncrementGap(String fieldName) {
        if (this.positionIncrementGap != Integer.MIN_VALUE) {
            return this.positionIncrementGap;
        }
        return super.getPositionIncrementGap(fieldName);
    }

    public void checkAllowedInMode(AnalysisMode mode) {
        Objects.requireNonNull(mode);
        if (this.getAnalysisMode() == AnalysisMode.ALL) {
            return;
        }
        if (this.getAnalysisMode() != mode) {
            if (this.analyzer instanceof AnalyzerComponentsProvider) {
                TokenFilterFactory[] tokenFilters = ((AnalyzerComponentsProvider)this.analyzer).getComponents().getTokenFilters();
                ArrayList<String> offendingFilters = new ArrayList<String>();
                for (TokenFilterFactory tokenFilter : tokenFilters) {
                    AnalysisMode filterMode = tokenFilter.getAnalysisMode();
                    if (filterMode == AnalysisMode.ALL || filterMode == mode) continue;
                    offendingFilters.add(tokenFilter.name());
                }
                throw new MapperException("analyzer [" + this.name + "] contains filters " + String.valueOf(offendingFilters) + " that are not allowed to run in " + mode.getReadableName() + " mode.");
            }
            throw new MapperException("analyzer [" + this.name + "] contains components that are not allowed to run in " + mode.getReadableName() + " mode.");
        }
    }

    public boolean containsBrokenAnalysis() {
        if (this.analyzer instanceof AnalyzerComponentsProvider) {
            TokenFilterFactory[] tokenFilters;
            for (TokenFilterFactory tokenFilterFactory : tokenFilters = ((AnalyzerComponentsProvider)this.analyzer).getComponents().getTokenFilters()) {
                if (!tokenFilterFactory.breaksFastVectorHighlighter()) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "analyzer name[" + this.name + "], analyzer [" + String.valueOf(this.analyzer) + "], analysisMode [" + String.valueOf((Object)this.analysisMode) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedAnalyzer)) {
            return false;
        }
        NamedAnalyzer that = (NamedAnalyzer)((Object)o);
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public void close() {
        super.close();
        if (this.scope == AnalyzerScope.INDEX) {
            this.analyzer.close();
        }
    }
}

