/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.CountedCollector;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.builder.SubSearchSourceBuilder;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsKnnResults;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.vectors.KnnScoreDocQueryBuilder;
import org.elasticsearch.transport.Transport;

final class DfsQueryPhase
extends SearchPhase {
    private final SearchPhaseResults<SearchPhaseResult> queryResult;
    private final List<DfsSearchResult> searchResults;
    private final AggregatedDfs dfs;
    private final List<DfsKnnResults> knnResults;
    private final Function<SearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory;
    private final SearchPhaseContext context;
    private final SearchTransportService searchTransportService;
    private final SearchProgressListener progressListener;

    DfsQueryPhase(List<DfsSearchResult> searchResults, AggregatedDfs dfs, List<DfsKnnResults> knnResults, SearchPhaseResults<SearchPhaseResult> queryResult, Function<SearchPhaseResults<SearchPhaseResult>, SearchPhase> nextPhaseFactory, SearchPhaseContext context) {
        super("dfs_query");
        this.progressListener = context.getTask().getProgressListener();
        this.queryResult = queryResult;
        this.searchResults = searchResults;
        this.dfs = dfs;
        this.knnResults = knnResults;
        this.nextPhaseFactory = nextPhaseFactory;
        this.context = context;
        this.searchTransportService = context.getSearchTransport();
        context.addReleasable(queryResult);
    }

    public void run() {
        final CountedCollector<SearchPhaseResult> counter = new CountedCollector<SearchPhaseResult>(this.queryResult, this.searchResults.size(), () -> this.context.executeNextPhase(this, this.nextPhaseFactory.apply(this.queryResult)), this.context);
        for (final DfsSearchResult dfsResult : this.searchResults) {
            final SearchShardTarget shardTarget = dfsResult.getSearchShardTarget();
            final Transport.Connection connection = this.context.getConnection(shardTarget.getClusterAlias(), shardTarget.getNodeId());
            ShardSearchRequest shardRequest = this.rewriteShardSearchRequest(dfsResult.getShardSearchRequest());
            final QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.context.getOriginalIndices(dfsResult.getShardIndex()), dfsResult.getContextId(), shardRequest, this.dfs);
            final int shardIndex = dfsResult.getShardIndex();
            this.searchTransportService.sendExecuteQuery(connection, querySearchRequest, this.context.getTask(), (ActionListener<QuerySearchResult>)new SearchActionListener<QuerySearchResult>(shardTarget, shardIndex){

                @Override
                protected void innerOnResponse(QuerySearchResult response) {
                    try {
                        response.setSearchProfileDfsPhaseResult(dfsResult.searchProfileDfsPhaseResult());
                        counter.onResult(response);
                    }
                    catch (Exception e) {
                        DfsQueryPhase.this.context.onPhaseFailure(DfsQueryPhase.this, "", e);
                    }
                }

                @Override
                public void onFailure(Exception exception) {
                    try {
                        DfsQueryPhase.this.context.getLogger().debug(() -> "[" + String.valueOf(querySearchRequest.contextId()) + "] Failed to execute query phase", (Throwable)exception);
                        DfsQueryPhase.this.progressListener.notifyQueryFailure(shardIndex, shardTarget, exception);
                        counter.onFailure(shardIndex, shardTarget, exception);
                    }
                    finally {
                        if (!DfsQueryPhase.this.context.isPartOfPointInTime(querySearchRequest.contextId())) {
                            DfsQueryPhase.this.context.sendReleaseSearchContext(querySearchRequest.contextId(), connection, DfsQueryPhase.this.context.getOriginalIndices(shardIndex));
                        }
                    }
                }
            });
        }
    }

    ShardSearchRequest rewriteShardSearchRequest(ShardSearchRequest request) {
        SearchSourceBuilder source = request.source();
        if (source == null || source.knnSearch().isEmpty()) {
            return request;
        }
        ArrayList<SubSearchSourceBuilder> subSearchSourceBuilders = new ArrayList<SubSearchSourceBuilder>(source.subSearches());
        int i = 0;
        for (DfsKnnResults dfsKnnResults : this.knnResults) {
            ArrayList<ScoreDoc> scoreDocs = new ArrayList<ScoreDoc>();
            for (ScoreDoc scoreDoc2 : dfsKnnResults.scoreDocs()) {
                if (scoreDoc2.shardIndex != request.shardRequestIndex()) continue;
                scoreDocs.add(scoreDoc2);
            }
            scoreDocs.sort(Comparator.comparingInt(scoreDoc -> scoreDoc.doc));
            String nestedPath = dfsKnnResults.getNestedPath();
            QueryBuilder query = ((KnnScoreDocQueryBuilder)new KnnScoreDocQueryBuilder(scoreDocs.toArray(Lucene.EMPTY_SCORE_DOCS), source.knnSearch().get(i).getField(), source.knnSearch().get(i).getQueryVector(), source.knnSearch().get(i).getSimilarity()).boost(source.knnSearch().get(i).boost())).queryName(source.knnSearch().get(i).queryName());
            if (nestedPath != null) {
                query = new NestedQueryBuilder(nestedPath, query, ScoreMode.Max).innerHit(source.knnSearch().get(i).innerHit());
            }
            subSearchSourceBuilders.add(new SubSearchSourceBuilder(query));
            ++i;
        }
        source = source.shallowCopy().subSearches(subSearchSourceBuilders).knnSearch(List.of());
        request.source(source);
        return request;
    }
}

