/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.segments;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.engine.Segment;

public class ShardSegments
implements Writeable,
Iterable<Segment> {
    private final ShardRouting shardRouting;
    private final List<Segment> segments;

    ShardSegments(ShardRouting shardRouting, List<Segment> segments) {
        this.shardRouting = shardRouting;
        this.segments = segments;
    }

    ShardSegments(StreamInput in) throws IOException {
        this.shardRouting = new ShardRouting(in);
        this.segments = in.readCollectionAsList(Segment::new);
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.segments.iterator();
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public int getNumberOfCommitted() {
        int count = 0;
        for (Segment segment : this.segments) {
            if (!segment.isCommitted()) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfSearch() {
        int count = 0;
        for (Segment segment : this.segments) {
            if (!segment.isSearch()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardRouting.writeTo(out);
        out.writeCollection(this.segments);
    }
}

