/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.SingleResultDeduplicator;
import org.elasticsearch.action.admin.cluster.allocation.AllocationStatsFeatures;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.allocation.AllocationStatsService;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStats;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAllocationStatsAction
extends TransportMasterNodeReadAction<Request, Response> {
    public static final ActionType<Response> TYPE = new ActionType("cluster:monitor/allocation/stats");
    private final SingleResultDeduplicator<Map<String, NodeAllocationStats>> allocationStatsSupplier;
    private final DiskThresholdSettings diskThresholdSettings;
    private final FeatureService featureService;

    @Inject
    public TransportGetAllocationStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AllocationStatsService allocationStatsService, FeatureService featureService) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, Request::new, indexNameExpressionResolver, Response::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        ExecutorService managementExecutor = threadPool.executor("management");
        this.allocationStatsSupplier = new SingleResultDeduplicator(threadPool.getThreadContext(), l -> managementExecutor.execute(ActionRunnable.supply(l, allocationStatsService::stats)));
        this.diskThresholdSettings = new DiskThresholdSettings(clusterService.getSettings(), clusterService.getClusterSettings());
        this.featureService = featureService;
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        if (this.clusterService.state().getMinTransportVersion().before(TransportVersions.V_8_14_0)) {
            listener.onResponse(new Response(Map.of(), null));
            return;
        }
        super.doExecute(task, request, listener);
    }

    @Override
    protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        SubscribableListener allocationStatsStep = request.metrics().contains((Object)NodesStatsRequestParameters.Metric.ALLOCATIONS) ? SubscribableListener.newForked(this.allocationStatsSupplier::execute) : SubscribableListener.newSucceeded(Map.of());
        allocationStatsStep.andThenApply(allocationStats -> new Response((Map<String, NodeAllocationStats>)allocationStats, request.metrics().contains((Object)NodesStatsRequestParameters.Metric.FS) && this.featureService.clusterHasFeature(this.clusterService.state(), AllocationStatsFeatures.INCLUDE_DISK_THRESHOLD_SETTINGS) ? this.diskThresholdSettings : null)).addListener(listener);
    }

    @Override
    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    public static class Response
    extends ActionResponse {
        private final Map<String, NodeAllocationStats> nodeAllocationStats;
        @Nullable
        private final DiskThresholdSettings diskThresholdSettings;

        public Response(Map<String, NodeAllocationStats> nodeAllocationStats, DiskThresholdSettings diskThresholdSettings) {
            this.nodeAllocationStats = nodeAllocationStats;
            this.diskThresholdSettings = diskThresholdSettings;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.nodeAllocationStats = in.readImmutableMap(StreamInput::readString, NodeAllocationStats::new);
            this.diskThresholdSettings = in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0) ? in.readOptionalWriteable(DiskThresholdSettings::readFrom) : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.nodeAllocationStats, StreamOutput::writeString, StreamOutput::writeWriteable);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
                out.writeOptionalWriteable(this.diskThresholdSettings);
            } else assert (this.diskThresholdSettings == null);
        }

        public Map<String, NodeAllocationStats> getNodeAllocationStats() {
            return this.nodeAllocationStats;
        }

        @Nullable
        public DiskThresholdSettings getDiskThresholdSettings() {
            return this.diskThresholdSettings;
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private final EnumSet<NodesStatsRequestParameters.Metric> metrics;

        public Request(TimeValue masterNodeTimeout, TaskId parentTaskId, EnumSet<NodesStatsRequestParameters.Metric> metrics) {
            super(masterNodeTimeout);
            this.setParentTask(parentTaskId);
            this.metrics = metrics;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.metrics = in.getTransportVersion().onOrAfter(TransportVersions.MASTER_NODE_METRICS) ? in.readEnumSet(NodesStatsRequestParameters.Metric.class) : EnumSet.of(NodesStatsRequestParameters.Metric.ALLOCATIONS, NodesStatsRequestParameters.Metric.FS);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getTransportVersion().onOrAfter(TransportVersions.V_8_14_0));
            super.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.MASTER_NODE_METRICS)) {
                out.writeEnumSet(this.metrics);
            }
        }

        public EnumSet<NodesStatsRequestParameters.Metric> metrics() {
            return this.metrics;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

