/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.querydsl.query.NotQuery;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;

public class BoolQuery
extends Query {
    private final boolean isAnd;
    private final List<Query> queries;

    public BoolQuery(Source source, boolean isAnd, Query left, Query right) {
        this(source, isAnd, Arrays.asList(left, right));
    }

    public BoolQuery(Source source, boolean isAnd, List<Query> queries) {
        super(source);
        if (CollectionUtils.isEmpty(queries) || queries.size() < 2) {
            throw new QlIllegalArgumentException("At least two queries required by bool query");
        }
        this.isAnd = isAnd;
        this.queries = queries;
    }

    @Override
    public QueryBuilder asBuilder() {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (Query query : this.queries) {
            if (this.isAnd) {
                boolQuery.must(query.asBuilder());
                continue;
            }
            boolQuery.should(query.asBuilder());
        }
        return boolQuery;
    }

    public boolean isAnd() {
        return this.isAnd;
    }

    public List<Query> queries() {
        return this.queries;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isAnd, this.queries);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BoolQuery other = (BoolQuery)obj;
        return this.isAnd == other.isAnd && this.queries.equals(other.queries);
    }

    @Override
    protected String innerToString() {
        StringJoiner sb = new StringJoiner(this.isAnd ? " AND " : " OR ");
        for (Query query : this.queries) {
            sb.add(query.toString());
        }
        return sb.toString();
    }

    @Override
    public Query negate(Source source) {
        List<Query> negated = this.queries.stream().map(q -> q.negate(q.source())).toList();
        if (negated.stream().allMatch(q -> q instanceof NotQuery)) {
            return new NotQuery(source, this);
        }
        return new BoolQuery(source, !this.isAnd, negated);
    }
}

