/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.monitoring.MonitoringFeatureSetUsage;
import org.elasticsearch.xpack.monitoring.MonitoringService;
import org.elasticsearch.xpack.monitoring.MonitoringUsageServices;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.Exporters;

public class MonitoringUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final MonitoringService monitoringService;
    private final Exporters exporters;

    @Inject
    public MonitoringUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MonitoringUsageServices monitoringServices) {
        super(XPackUsageFeatureAction.MONITORING.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.monitoringService = monitoringServices.monitoringService;
        this.exporters = monitoringServices.exporters;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        boolean collectionEnabled = this.monitoringService != null && this.monitoringService.isMonitoringActive();
        MonitoringFeatureSetUsage usage = new MonitoringFeatureSetUsage(collectionEnabled, MonitoringUsageTransportAction.exportersUsage(this.exporters));
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)usage));
    }

    static Map<String, Object> exportersUsage(Exporters exporters) {
        if (exporters == null) {
            return null;
        }
        HashMap<String, Object> usage = new HashMap<String, Object>();
        for (Exporter exporter : exporters.getEnabledExporters()) {
            if (!exporter.config().enabled()) continue;
            String type = exporter.config().type();
            int count = (Integer)usage.getOrDefault(type, 0);
            usage.put(type, count + 1);
        }
        return usage;
    }
}

