/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.arrow;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;

public abstract class BlockConverter {
    private final FieldType fieldType;
    private final String esqlType;

    protected BlockConverter(String esqlType, Types.MinorType minorType) {
        Map<String, String> meta = Map.of("elastic:type", esqlType);
        this.fieldType = new FieldType(true, minorType.getType(), null, meta);
        this.esqlType = esqlType;
    }

    public final String esqlType() {
        return this.esqlType;
    }

    public final FieldType arrowFieldType() {
        return this.fieldType;
    }

    protected int nullValuesCount(Block block) {
        if (!block.mayHaveNulls()) {
            return 0;
        }
        if (block.areAllValuesNull()) {
            return block.getPositionCount();
        }
        int count = 0;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (!block.isNull(i)) continue;
            ++count;
        }
        return count;
    }

    public abstract void convert(Block var1, boolean var2, List<ArrowBuf> var3, List<BufWriter> var4);

    private static ArrowBuf dummyArrowBuf(long size) {
        return new ArrowBuf(null, null, 0L, 0L).writerIndex(size);
    }

    private static int bitSetLength(int totalValues) {
        return (totalValues + 7) / 8;
    }

    static int valueCount(Block block) {
        int result = block.getFirstValueIndex(block.getPositionCount());
        if (result == 0 && block.areAllValuesNull()) {
            result = block.getPositionCount();
        }
        return result;
    }

    private static void accumulateVectorValidity(List<ArrowBuf> bufs, List<BufWriter> bufWriters, Block b, boolean multivalued) {
        if (multivalued || !b.mayHaveNulls()) {
            bufs.add(BlockConverter.dummyArrowBuf(0L));
            bufWriters.add(w -> 0L);
            return;
        }
        int valueCount = b.getPositionCount();
        bufs.add(BlockConverter.dummyArrowBuf(BlockConverter.bitSetLength(valueCount)));
        bufWriters.add(out -> {
            if (b.areAllValuesNull()) {
                return BlockConverter.writeAllFalseValidity(out, valueCount);
            }
            return BlockConverter.writeValidities(out, b, valueCount);
        });
    }

    private static long writeAllTrueValidity(RecyclerBytesStreamOutput out, int valueCount) {
        int allOnesCount = valueCount / 8;
        for (int i = 0; i < allOnesCount; ++i) {
            out.writeByte((byte)-1);
        }
        int remaining = valueCount % 8;
        if (remaining == 0) {
            return allOnesCount;
        }
        out.writeByte((byte)((1 << remaining) - 1));
        return allOnesCount + 1;
    }

    private static long writeAllFalseValidity(RecyclerBytesStreamOutput out, int valueCount) {
        int count = BlockConverter.bitSetLength(valueCount);
        for (int i = 0; i < count; ++i) {
            out.writeByte((byte)0);
        }
        return count;
    }

    private static long writeValidities(RecyclerBytesStreamOutput out, Block block, int valueCount) {
        BitSet bits = new BitSet(valueCount);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            bits.set(i);
        }
        return BlockConverter.writeBitSet(out, bits, valueCount);
    }

    private static long writeBitSet(RecyclerBytesStreamOutput out, BitSet bits, int bitCount) {
        byte[] bytes = bits.toByteArray();
        out.writeBytes(bytes, 0, bytes.length);
        int expectedLength = BlockConverter.bitSetLength(bitCount);
        BlockConverter.writeZeroes(out, expectedLength - bytes.length);
        return expectedLength;
    }

    private static long writeZeroes(RecyclerBytesStreamOutput out, int byteCount) {
        for (int i = 0; i < byteCount; ++i) {
            out.writeByte((byte)0);
        }
        return byteCount;
    }

    private static void addListOffsets(List<ArrowBuf> bufs, List<BufWriter> bufWriters, Block block) {
        BlockConverter.accumulateVectorValidity(bufs, bufWriters, block, false);
        int bufferLen = 4 * (block.getPositionCount() + 1);
        bufs.add(BlockConverter.dummyArrowBuf(bufferLen));
        bufWriters.add(out -> {
            if (block.mayHaveMultivaluedFields()) {
                for (int i = 0; i <= block.getPositionCount(); ++i) {
                    out.writeIntLE(block.getFirstValueIndex(i));
                }
            } else {
                for (int i = 0; i <= block.getPositionCount(); ++i) {
                    out.writeIntLE(i);
                }
            }
            return bufferLen;
        });
    }

    public static interface BufWriter {
        public long write(RecyclerBytesStreamOutput var1) throws IOException;
    }

    public static class AsNull
    extends BlockConverter {
        public AsNull(String esqlType) {
            super(esqlType, Types.MinorType.NULL);
        }

        @Override
        public void convert(Block block, boolean multivalued, List<ArrowBuf> bufs, List<BufWriter> bufWriters) {
        }
    }

    public static class AsVarBinary
    extends BytesRefConverter {
        public AsVarBinary(String esqlType) {
            super(esqlType, Types.MinorType.VARBINARY);
        }
    }

    public static class AsVarChar
    extends BytesRefConverter {
        public AsVarChar(String esqlType) {
            super(esqlType, Types.MinorType.VARCHAR);
        }
    }

    public static class TransformedBytesRef
    extends BytesRefConverter {
        private final BiFunction<BytesRef, BytesRef, BytesRef> valueConverter;

        public TransformedBytesRef(String esqlType, Types.MinorType minorType, BiFunction<BytesRef, BytesRef, BytesRef> valueConverter) {
            super(esqlType, minorType);
            this.valueConverter = valueConverter;
        }

        @Override
        public void convert(Block b, boolean multivalued, List<ArrowBuf> bufs, List<BufWriter> bufWriters) {
            BytesRefBlock block = (BytesRefBlock)b;
            try (BytesRefBlock transformed = this.transformValues(block);){
                super.convert((Block)transformed, multivalued, bufs, bufWriters);
            }
        }

        private BytesRefBlock transformValues(BytesRefBlock block) {
            try (BytesRefBlock.Builder builder = block.blockFactory().newBytesRefBlockBuilder(block.getPositionCount());){
                BytesRef scratch = new BytesRef();
                if (!block.mayHaveMultivaluedFields()) {
                    for (pos = 0; pos < TransformedBytesRef.valueCount((Block)block); ++pos) {
                        if (block.isNull(pos)) {
                            builder.appendNull();
                            continue;
                        }
                        this.convertAndAppend(builder, block, pos, scratch);
                    }
                } else {
                    for (pos = 0; pos < block.getPositionCount(); ++pos) {
                        if (block.isNull(pos)) {
                            builder.appendNull();
                            continue;
                        }
                        builder.beginPositionEntry();
                        int startPos = block.getFirstValueIndex(pos);
                        int lastPos = block.getFirstValueIndex(pos + 1);
                        for (int valuePos = startPos; valuePos < lastPos; ++valuePos) {
                            this.convertAndAppend(builder, block, valuePos, scratch);
                        }
                        builder.endPositionEntry();
                    }
                }
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }

        private void convertAndAppend(BytesRefBlock.Builder builder, BytesRefBlock block, int position, BytesRef scratch) {
            BytesRef bytes = block.getBytesRef(position, scratch);
            if (bytes.length != 0) {
                bytes = this.valueConverter.apply(bytes, scratch);
            }
            builder.appendBytesRef(bytes);
        }
    }

    public static class BytesRefConverter
    extends BlockConverter {
        public BytesRefConverter(String esqlType, Types.MinorType minorType) {
            super(esqlType, minorType);
        }

        @Override
        public void convert(Block b, boolean multivalued, List<ArrowBuf> bufs, List<BufWriter> bufWriters) {
            BytesRefBlock block = (BytesRefBlock)b;
            if (multivalued) {
                BlockConverter.addListOffsets(bufs, bufWriters, (Block)block);
            }
            BlockConverter.accumulateVectorValidity(bufs, bufWriters, (Block)block, multivalued);
            bufs.add(BlockConverter.dummyArrowBuf(BytesRefConverter.offsetvectorByteSize(block)));
            bufWriters.add(out -> {
                if (block.areAllValuesNull()) {
                    int count = BytesRefConverter.valueCount((Block)block) + 1;
                    for (int i = 0; i < count; ++i) {
                        out.writeIntLE(0);
                    }
                    return BytesRefConverter.offsetvectorByteSize(block);
                }
                BytesRef scratch = new BytesRef();
                int offset = 0;
                for (int i = 0; i < BytesRefConverter.valueCount((Block)block); ++i) {
                    out.writeIntLE(offset);
                    BytesRef v = block.getBytesRef(i, scratch);
                    offset += v.length;
                }
                out.writeIntLE(offset);
                return BytesRefConverter.offsetvectorByteSize(block);
            });
            bufs.add(BlockConverter.dummyArrowBuf(this.dataVectorByteSize(block)));
            bufWriters.add(out -> {
                if (block.areAllValuesNull()) {
                    return 0L;
                }
                BytesRef scratch = new BytesRef();
                long length = 0L;
                for (int i = 0; i < BytesRefConverter.valueCount((Block)block); ++i) {
                    BytesRef v = block.getBytesRef(i, scratch);
                    out.write(v.bytes, v.offset, v.length);
                    length += (long)v.length;
                }
                return length;
            });
        }

        private static int offsetvectorByteSize(BytesRefBlock block) {
            return 4 * (BytesRefConverter.valueCount((Block)block) + 1);
        }

        private int dataVectorByteSize(BytesRefBlock block) {
            if (block.areAllValuesNull()) {
                return 0;
            }
            int length = 0;
            BytesRef scratch = new BytesRef();
            for (int i = 0; i < BytesRefConverter.valueCount((Block)block); ++i) {
                BytesRef v = block.getBytesRef(i, scratch);
                length += v.length;
            }
            return length;
        }
    }

    public static class AsBoolean
    extends BlockConverter {
        public AsBoolean(String esqlType) {
            super(esqlType, Types.MinorType.BIT);
        }

        @Override
        public void convert(Block b, boolean multivalued, List<ArrowBuf> bufs, List<BufWriter> bufWriters) {
            BooleanBlock block = (BooleanBlock)b;
            if (multivalued) {
                BlockConverter.addListOffsets(bufs, bufWriters, (Block)block);
            }
            BlockConverter.accumulateVectorValidity(bufs, bufWriters, (Block)block, multivalued);
            bufs.add(BlockConverter.dummyArrowBuf(AsBoolean.vectorByteSize(block)));
            bufWriters.add(out -> {
                int count = BlockConverter.valueCount((Block)block);
                BitSet bits = new BitSet();
                if (!block.areAllValuesNull()) {
                    for (int i = 0; i < count; ++i) {
                        if (!block.getBoolean(i)) continue;
                        bits.set(i);
                    }
                }
                return BlockConverter.writeBitSet(out, bits, count);
            });
        }

        private static int vectorByteSize(BooleanBlock b) {
            return BlockConverter.bitSetLength(BlockConverter.valueCount((Block)b));
        }
    }

    public static class AsInt64
    extends BlockConverter {
        public AsInt64(String esqlType) {
            this(esqlType, Types.MinorType.BIGINT);
        }

        protected AsInt64(String esqlType, Types.MinorType minorType) {
            super(esqlType, minorType);
        }

        @Override
        public void convert(Block b, boolean multivalued, List<ArrowBuf> bufs, List<BufWriter> bufWriters) {
            LongBlock block = (LongBlock)b;
            if (multivalued) {
                BlockConverter.addListOffsets(bufs, bufWriters, (Block)block);
            }
            BlockConverter.accumulateVectorValidity(bufs, bufWriters, (Block)block, multivalued);
            bufs.add(BlockConverter.dummyArrowBuf(AsInt64.vectorByteSize(block)));
            bufWriters.add(out -> {
                if (block.areAllValuesNull()) {
                    return BlockConverter.writeZeroes(out, AsInt64.vectorByteSize(block));
                }
                int count = BlockConverter.valueCount((Block)block);
                for (int i = 0; i < count; ++i) {
                    out.writeLongLE(block.getLong(i));
                }
                return (long)count * 8L;
            });
        }

        private static int vectorByteSize(LongBlock b) {
            return 8 * BlockConverter.valueCount((Block)b);
        }
    }

    public static class AsInt32
    extends BlockConverter {
        public AsInt32(String esqlType) {
            super(esqlType, Types.MinorType.INT);
        }

        @Override
        public void convert(Block b, boolean multivalued, List<ArrowBuf> bufs, List<BufWriter> bufWriters) {
            IntBlock block = (IntBlock)b;
            if (multivalued) {
                BlockConverter.addListOffsets(bufs, bufWriters, (Block)block);
            }
            BlockConverter.accumulateVectorValidity(bufs, bufWriters, (Block)block, multivalued);
            bufs.add(BlockConverter.dummyArrowBuf(AsInt32.vectorByteSize((Block)block)));
            bufWriters.add(out -> {
                if (block.areAllValuesNull()) {
                    return BlockConverter.writeZeroes(out, AsInt32.vectorByteSize((Block)block));
                }
                int count = BlockConverter.valueCount((Block)block);
                for (int i = 0; i < count; ++i) {
                    out.writeIntLE(block.getInt(i));
                }
                return (long)count * 4L;
            });
        }

        private static int vectorByteSize(Block b) {
            return 4 * BlockConverter.valueCount(b);
        }
    }

    public static class AsFloat64
    extends BlockConverter {
        public AsFloat64(String esqlType) {
            super(esqlType, Types.MinorType.FLOAT8);
        }

        @Override
        public void convert(Block b, boolean multivalued, List<ArrowBuf> bufs, List<BufWriter> bufWriters) {
            DoubleBlock block = (DoubleBlock)b;
            if (multivalued) {
                BlockConverter.addListOffsets(bufs, bufWriters, (Block)block);
            }
            BlockConverter.accumulateVectorValidity(bufs, bufWriters, (Block)block, multivalued);
            bufs.add(BlockConverter.dummyArrowBuf(AsFloat64.vectorByteSize(block)));
            bufWriters.add(out -> {
                if (block.areAllValuesNull()) {
                    return BlockConverter.writeZeroes(out, AsFloat64.vectorByteSize(block));
                }
                int count = BlockConverter.valueCount((Block)block);
                for (int i = 0; i < count; ++i) {
                    out.writeDoubleLE(block.getDouble(i));
                }
                return (long)count * 8L;
            });
        }

        private static int vectorByteSize(DoubleBlock b) {
            return 8 * BlockConverter.valueCount((Block)b);
        }
    }
}

