/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.action.ExecuteSnapshotRetentionAction;
import org.elasticsearch.xpack.slm.SnapshotRetentionService;

public class TransportExecuteSnapshotRetentionAction
extends AcknowledgedTransportMasterNodeAction<ExecuteSnapshotRetentionAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportExecuteSnapshotRetentionAction.class);
    private final SnapshotRetentionService retentionService;

    @Inject
    public TransportExecuteSnapshotRetentionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SnapshotRetentionService retentionService) {
        super("cluster:admin/slm/execute-retention", transportService, clusterService, threadPool, actionFilters, ExecuteSnapshotRetentionAction.Request::new, indexNameExpressionResolver, (Executor)threadPool.executor("generic"));
        this.retentionService = retentionService;
    }

    protected void masterOperation(Task task, ExecuteSnapshotRetentionAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        try {
            logger.info("manually triggering SLM snapshot retention");
            this.retentionService.triggerRetention();
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }
        catch (Exception e) {
            listener.onFailure((Exception)new ElasticsearchException("failed to execute snapshot lifecycle retention", (Throwable)e, new Object[0]));
        }
    }

    protected ClusterBlockException checkBlock(ExecuteSnapshotRetentionAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

