/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oidc;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public abstract class OpenIdConnectBaseRestHandler
extends SecurityBaseRestHandler {
    private static final Logger logger = LogManager.getLogger(OpenIdConnectBaseRestHandler.class);
    private static final String OIDC_REALM_TYPE = "oidc";

    protected OpenIdConnectBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    @Override
    protected Exception innerCheckFeatureAvailable(RestRequest request) {
        if (Realms.isRealmTypeAvailable(this.licenseState, OIDC_REALM_TYPE)) {
            return null;
        }
        logger.info("The '{}' realm is not available under the current license", (Object)OIDC_REALM_TYPE);
        return LicenseUtils.newComplianceException((String)OIDC_REALM_TYPE);
    }
}

