/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.Realms;

public interface Authenticator {
    public String name();

    @Nullable
    public AuthenticationToken extractCredentials(Context var1);

    public void authenticate(Context var1, ActionListener<AuthenticationResult<Authentication>> var2);

    public static SecureString extractCredentialFromAuthorizationHeader(ThreadContext threadContext, String prefix) {
        return Authenticator.extractCredentialFromHeaderValue(threadContext.getHeader("Authorization"), prefix);
    }

    public static SecureString extractCredentialFromHeaderValue(String header, String prefix) {
        String prefixWithSpace = prefix + " ";
        if (Strings.hasText((String)header) && header.regionMatches(true, 0, prefixWithSpace, 0, prefixWithSpace.length()) && header.length() > prefixWithSpace.length()) {
            char[] chars = new char[header.length() - prefixWithSpace.length()];
            header.getChars(prefixWithSpace.length(), header.length(), chars, 0);
            return new SecureString(chars);
        }
        return null;
    }

    public static SecureString extractBearerTokenFromHeader(ThreadContext threadContext) {
        return Authenticator.extractCredentialFromAuthorizationHeader(threadContext, "Bearer");
    }

    public static SecureString extractApiKeyFromHeader(ThreadContext threadContext) {
        return Authenticator.extractCredentialFromAuthorizationHeader(threadContext, "ApiKey");
    }

    public static class Context
    implements Closeable {
        private final ThreadContext threadContext;
        private final AuthenticationService.AuditableRequest request;
        private final User fallbackUser;
        private final boolean allowAnonymous;
        private final boolean extractCredentials;
        private final Realms realms;
        private final List<AuthenticationToken> authenticationTokens;
        private final List<String> unsuccessfulMessages = new ArrayList<String>();
        private boolean handleNullToken = true;
        private SecureString bearerString = null;
        private SecureString apiKeyString = null;
        private List<Realm> defaultOrderedRealmList = null;
        private List<Realm> unlicensedRealms = null;

        Context(ThreadContext threadContext, AuthenticationService.AuditableRequest request, Realms realms, @Nullable AuthenticationToken token) {
            this.threadContext = threadContext;
            this.request = request;
            this.realms = realms;
            this.authenticationTokens = token != null ? List.of(token) : List.of();
            this.extractCredentials = false;
            this.handleNullToken = false;
            this.fallbackUser = null;
            this.allowAnonymous = false;
        }

        public Context(ThreadContext threadContext, AuthenticationService.AuditableRequest request, User fallbackUser, boolean allowAnonymous, Realms realms) {
            this.threadContext = threadContext;
            this.request = request;
            this.extractCredentials = true;
            this.authenticationTokens = new ArrayList<AuthenticationToken>();
            this.fallbackUser = fallbackUser;
            this.allowAnonymous = allowAnonymous;
            this.realms = realms;
        }

        public ThreadContext getThreadContext() {
            return this.threadContext;
        }

        public AuthenticationService.AuditableRequest getRequest() {
            return this.request;
        }

        public User getFallbackUser() {
            return this.fallbackUser;
        }

        public boolean isAllowAnonymous() {
            return this.allowAnonymous;
        }

        public void setHandleNullToken(boolean value) {
            this.handleNullToken = value;
        }

        public boolean shouldHandleNullToken() {
            return this.handleNullToken;
        }

        public boolean shouldExtractCredentials() {
            return this.extractCredentials;
        }

        public List<String> getUnsuccessfulMessages() {
            return this.unsuccessfulMessages;
        }

        public void addAuthenticationToken(AuthenticationToken authenticationToken) {
            this.authenticationTokens.add(authenticationToken);
        }

        @Nullable
        public AuthenticationToken getMostRecentAuthenticationToken() {
            return this.authenticationTokens.isEmpty() ? null : this.authenticationTokens.get(this.authenticationTokens.size() - 1);
        }

        public SecureString getBearerString() {
            if (this.bearerString == null) {
                this.bearerString = Authenticator.extractBearerTokenFromHeader(this.threadContext);
            }
            return this.bearerString;
        }

        public SecureString getApiKeyString() {
            if (this.apiKeyString == null) {
                this.apiKeyString = Authenticator.extractApiKeyFromHeader(this.threadContext);
            }
            return this.apiKeyString;
        }

        public List<Realm> getDefaultOrderedRealmList() {
            if (this.defaultOrderedRealmList == null) {
                this.defaultOrderedRealmList = this.realms.getActiveRealms();
            }
            return this.defaultOrderedRealmList;
        }

        public List<Realm> getUnlicensedRealms() {
            if (this.unlicensedRealms == null) {
                this.unlicensedRealms = this.realms.getUnlicensedRealms();
            }
            return this.unlicensedRealms;
        }

        public void addUnsuccessfulMessage(String message) {
            this.unsuccessfulMessages.add(message);
        }

        @Override
        public void close() throws IOException {
            this.authenticationTokens.forEach(AuthenticationToken::clearCredentials);
        }

        public void addUnsuccessfulMessageToMetadata(ElasticsearchSecurityException ese) {
            if (!this.getUnsuccessfulMessages().isEmpty()) {
                ese.addMetadata("es.additional_unsuccessful_credentials", this.getUnsuccessfulMessages());
            }
        }
    }
}

