/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs;

import org.elasticsearch.common.Numbers;

public final class DoubleArray {
    private DoubleArray() {
    }

    public static double[] cumulativeSum(double[] xs) {
        double[] sum = new double[xs.length];
        sum[0] = xs[0];
        for (int i = 1; i < xs.length; ++i) {
            sum[i] = sum[i - 1] + xs[i];
        }
        return sum;
    }

    public static void divMut(double[] xs, double v) {
        if (v == 0.0 || !Numbers.isValidDouble((double)v)) {
            throw new IllegalArgumentException("unable to divide by [" + v + "] as it results in undefined behavior");
        }
        int i = 0;
        while (i < xs.length) {
            int n = i++;
            xs[n] = xs[n] / v;
        }
    }
}

