/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.RemoteClusterLicenseChecker;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedRunningStateAction;
import org.elasticsearch.xpack.core.ml.action.NodeAcknowledgedResponse;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedJobValidator;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.datafeed.DatafeedNodeSelector;
import org.elasticsearch.xpack.ml.datafeed.DatafeedRunner;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorFactory;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;

public class TransportStartDatafeedAction
extends TransportMasterNodeAction<StartDatafeedAction.Request, NodeAcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportStartDatafeedAction.class);
    private final Client client;
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final JobConfigProvider jobConfigProvider;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final AnomalyDetectionAuditor auditor;
    private final NamedXContentRegistry xContentRegistry;
    private final boolean remoteClusterClient;

    @Inject
    public TransportStartDatafeedAction(Settings settings, TransportService transportService, ThreadPool threadPool, ClusterService clusterService, XPackLicenseState licenseState, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, AnomalyDetectionAuditor auditor, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/xpack/ml/datafeed/start", transportService, clusterService, threadPool, actionFilters, StartDatafeedAction.Request::new, indexNameExpressionResolver, NodeAcknowledgedResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.auditor = auditor;
        this.xContentRegistry = xContentRegistry;
        this.remoteClusterClient = DiscoveryNode.isRemoteClusterClient((Settings)settings);
    }

    static void validate(Job job, DatafeedConfig datafeedConfig, PersistentTasksCustomMetadata tasks, NamedXContentRegistry xContentRegistry) {
        DatafeedJobValidator.validate((DatafeedConfig)datafeedConfig, (Job)job, (NamedXContentRegistry)xContentRegistry);
        DatafeedConfig.validateAggregations((AggregatorFactories.Builder)datafeedConfig.getParsedAggregations(xContentRegistry));
        JobState jobState = MlTasks.getJobState((String)datafeedConfig.getJobId(), (PersistentTasksCustomMetadata)tasks);
        if (!jobState.isAnyOf(new JobState[]{JobState.OPENING, JobState.OPENED})) {
            throw ExceptionsHelper.conflictStatusException((String)("cannot start datafeed [" + datafeedConfig.getId() + "] because job [" + job.getId() + "] is " + String.valueOf(jobState)), (Object[])new Object[0]);
        }
    }

    static void auditDeprecations(DatafeedConfig datafeed, Job job, AnomalyDetectionAuditor auditor, NamedXContentRegistry xContentRegistry) {
        ArrayList deprecationWarnings = new ArrayList();
        deprecationWarnings.addAll(datafeed.getAggDeprecations(xContentRegistry));
        deprecationWarnings.addAll(datafeed.getQueryDeprecations(xContentRegistry));
        if (!deprecationWarnings.isEmpty()) {
            String msg = "datafeed [" + datafeed.getId() + "] configuration has deprecations. [" + Strings.collectionToDelimitedString(deprecationWarnings, (String)", ") + "]";
            auditor.warning(job.getId(), msg);
        }
    }

    protected void masterOperation(Task task, StartDatafeedAction.Request request, ClusterState state, ActionListener<NodeAcknowledgedResponse> listener) {
        final StartDatafeedAction.DatafeedParams params = request.getParams();
        if (!MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
            return;
        }
        final ContextPreservingActionListener responseHeaderPreservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, (ThreadContext)this.threadPool.getThreadContext());
        AtomicReference datafeedConfigHolder = new AtomicReference();
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks");
        ActionListener<PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams>> waitForTaskListener = new ActionListener<PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask) {
                TransportStartDatafeedAction.this.waitForDatafeedStarted(persistentTask.getId(), params, (ActionListener<NodeAcknowledgedResponse>)responseHeaderPreservingListener);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceAlreadyExistsException) {
                    logger.debug("datafeed already started", e);
                    e = new ElasticsearchStatusException("cannot start datafeed [" + params.getDatafeedId() + "] because it has already been started", RestStatus.CONFLICT, new Object[0]);
                }
                responseHeaderPreservingListener.onFailure((Exception)e);
            }
        };
        Consumer<Job> createDataExtractor = arg_0 -> this.lambda$masterOperation$3(params, responseHeaderPreservingListener, datafeedConfigHolder, task, (ActionListener)waitForTaskListener, arg_0);
        ActionListener jobListener = ActionListener.wrap(jobBuilder -> {
            Job job = jobBuilder.build();
            TransportStartDatafeedAction.validate(job, (DatafeedConfig)datafeedConfigHolder.get(), tasks, this.xContentRegistry);
            TransportStartDatafeedAction.auditDeprecations((DatafeedConfig)datafeedConfigHolder.get(), job, this.auditor, this.xContentRegistry);
            createDataExtractor.accept(job);
        }, arg_0 -> ((ContextPreservingActionListener)responseHeaderPreservingListener).onFailure(arg_0));
        ActionListener datafeedListener = ActionListener.wrap(datafeedBuilder -> {
            DatafeedConfig datafeedConfig = datafeedBuilder.build();
            params.setDatafeedIndices(datafeedConfig.getIndices());
            params.setJobId(datafeedConfig.getJobId());
            params.setIndicesOptions(datafeedConfig.getIndicesOptions());
            datafeedConfigHolder.set(datafeedConfig);
            this.jobConfigProvider.getJob(datafeedConfig.getJobId(), null, (ActionListener<Job.Builder>)jobListener);
        }, arg_0 -> ((ContextPreservingActionListener)responseHeaderPreservingListener).onFailure(arg_0));
        this.datafeedConfigProvider.getDatafeedConfig(params.getDatafeedId(), null, (ActionListener<DatafeedConfig.Builder>)datafeedListener);
    }

    static void checkRemoteConfigVersions(DatafeedConfig config, List<String> remoteClusters, Function<String, TransportVersion> transportVersionSupplier) {
        Optional minVersionAndReason = config.minRequiredTransportVersion();
        if (!minVersionAndReason.isPresent()) {
            return;
        }
        String reason = (String)((Tuple)minVersionAndReason.get()).v2();
        TransportVersion minVersion = (TransportVersion)((Tuple)minVersionAndReason.get()).v1();
        List clustersTooOld = remoteClusters.stream().filter(cn -> ((TransportVersion)transportVersionSupplier.apply((String)cn)).before((VersionId)minVersion)).collect(Collectors.toList());
        if (clustersTooOld.isEmpty()) {
            return;
        }
        throw ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"remote clusters are expected to run at least version [{0}] (reason: [{1}]), but the following clusters were too old: [{2}]", (Object[])new Object[]{minVersion.toReleaseVersion(), reason, Strings.collectionToCommaDelimitedString(clustersTooOld)}), (Object[])new Object[0]);
    }

    private void createDataExtractor(Task task, Job job, DatafeedConfig datafeed, StartDatafeedAction.DatafeedParams params, ActionListener<PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams>> listener) {
        DataExtractorFactory.create((Client)new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), task), datafeed, job, this.xContentRegistry, new DatafeedTimingStatsReporter(new DatafeedTimingStats(job.getId()), (ts, refreshPolicy, listener1) -> {}), (ActionListener<DataExtractorFactory>)ActionListener.wrap(unused -> this.persistentTasksService.sendStartRequest(MlTasks.datafeedTaskId((String)params.getDatafeedId()), "xpack/ml/datafeed", (PersistentTaskParams)params, MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(StartDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void waitForDatafeedStarted(String taskId, final StartDatafeedAction.DatafeedParams params, final ActionListener<NodeAcknowledgedResponse> listener) {
        final DatafeedPredicate predicate = new DatafeedPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, params.getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<StartDatafeedAction.DatafeedParams>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartDatafeedAction.this.cancelDatafeedStart(persistentTask, predicate.exception, (ActionListener<NodeAcknowledgedResponse>)listener);
                } else {
                    listener.onResponse((Object)new NodeAcknowledgedResponse(true, predicate.node));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)((Object)new ElasticsearchStatusException("Starting datafeed [{}] timed out after [{}]", RestStatus.REQUEST_TIMEOUT, new Object[]{params.getDatafeedId(), timeout})));
            }
        });
    }

    private void cancelDatafeedStart(final PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask, final Exception exception, final ActionListener<NodeAcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                logger.error("[" + ((StartDatafeedAction.DatafeedParams)persistentTask.getParams()).getDatafeedId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    private static ElasticsearchStatusException createUnlicensedError(String datafeedId, RemoteClusterLicenseChecker.LicenseCheck licenseCheck) {
        String message = String.format(Locale.ROOT, "cannot start datafeed [%s] as it is configured to use indices on remote cluster [%s] that is not licensed for ml; %s", datafeedId, licenseCheck.remoteClusterLicenseInfo().clusterAlias(), RemoteClusterLicenseChecker.buildErrorMessage((LicensedFeature)MachineLearningField.ML_API_FEATURE, (RemoteClusterLicenseChecker.RemoteClusterLicenseInfo)licenseCheck.remoteClusterLicenseInfo()));
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, new Object[0]);
    }

    private ElasticsearchStatusException createUnknownLicenseError(String datafeedId, List<String> remoteIndices, Exception cause) {
        int numberOfRemoteClusters = RemoteClusterLicenseChecker.remoteClusterAliases((Set)this.transportService.getRemoteClusterService().getRegisteredRemoteClusterNames(), remoteIndices).size();
        assert (numberOfRemoteClusters > 0);
        String remoteClusterQualifier = numberOfRemoteClusters == 1 ? "a remote cluster" : "remote clusters";
        String licenseTypeQualifier = numberOfRemoteClusters == 1 ? "" : "s";
        String message = String.format(Locale.ROOT, "cannot start datafeed [%s] as it uses indices on %s %s but the license type%s could not be verified", datafeedId, remoteClusterQualifier, remoteIndices, licenseTypeQualifier);
        return new ElasticsearchStatusException(message, RestStatus.BAD_REQUEST, (Throwable)cause, new Object[0]);
    }

    private /* synthetic */ void lambda$masterOperation$3(StartDatafeedAction.DatafeedParams params, ContextPreservingActionListener responseHeaderPreservingListener, AtomicReference datafeedConfigHolder, Task task, ActionListener waitForTaskListener, Job job) {
        List remoteIndices = RemoteClusterLicenseChecker.remoteIndices((Collection)params.getDatafeedIndices());
        if (!remoteIndices.isEmpty()) {
            RemoteClusterLicenseChecker remoteClusterLicenseChecker = new RemoteClusterLicenseChecker(this.client, (LicensedFeature)MachineLearningField.ML_API_FEATURE);
            remoteClusterLicenseChecker.checkRemoteClusterLicenses(RemoteClusterLicenseChecker.remoteClusterAliases((Set)this.transportService.getRemoteClusterService().getRegisteredRemoteClusterNames(), (List)params.getDatafeedIndices()), ActionListener.wrap(response -> {
                if (!response.isSuccess()) {
                    responseHeaderPreservingListener.onFailure((Exception)((Object)TransportStartDatafeedAction.createUnlicensedError(params.getDatafeedId(), response)));
                } else if (!this.remoteClusterClient) {
                    responseHeaderPreservingListener.onFailure((Exception)((Object)ExceptionsHelper.badRequestException((String)Messages.getMessage((String)"Datafeed [{0}] is configured with a remote index pattern(s) {1} but the current node [{2}] is not allowed to connect to remote clusters. Please enable node.remote_cluster_client for all machine learning nodes and master-eligible nodes.", (Object[])new Object[]{((DatafeedConfig)datafeedConfigHolder.get()).getId(), RemoteClusterLicenseChecker.remoteIndices((Collection)((DatafeedConfig)datafeedConfigHolder.get()).getIndices()), this.clusterService.getNodeName()}), (Object[])new Object[0])));
                } else {
                    RemoteClusterService remoteClusterService = this.transportService.getRemoteClusterService();
                    List remoteAliases = RemoteClusterLicenseChecker.remoteClusterAliases((Set)remoteClusterService.getRegisteredRemoteClusterNames(), (List)remoteIndices);
                    TransportStartDatafeedAction.checkRemoteConfigVersions((DatafeedConfig)datafeedConfigHolder.get(), remoteAliases, cn -> remoteClusterService.getConnection(cn).getTransportVersion());
                    this.createDataExtractor(task, job, (DatafeedConfig)datafeedConfigHolder.get(), params, (ActionListener<PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams>>)waitForTaskListener);
                }
            }, e -> responseHeaderPreservingListener.onFailure((Exception)((Object)this.createUnknownLicenseError(params.getDatafeedId(), RemoteClusterLicenseChecker.remoteIndices((Collection)params.getDatafeedIndices()), (Exception)e)))));
        } else {
            this.createDataExtractor(task, job, (DatafeedConfig)datafeedConfigHolder.get(), params, (ActionListener<PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams>>)waitForTaskListener);
        }
    }

    private static class DatafeedPredicate
    implements Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> {
        private volatile Exception exception;
        private volatile String node = "";

        private DatafeedPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
            DatafeedState datafeedState;
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetadata.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null) {
                if (assignment.equals((Object)DatafeedNodeSelector.AWAITING_JOB_ASSIGNMENT)) {
                    return true;
                }
                if (assignment.equals((Object)DatafeedNodeSelector.AWAITING_JOB_RELOCATION)) {
                    return true;
                }
                if (!assignment.equals((Object)PersistentTasksCustomMetadata.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                    this.exception = new ElasticsearchStatusException("Could not start datafeed, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                    return true;
                }
            }
            if ((datafeedState = (DatafeedState)persistentTask.getState()) == DatafeedState.STARTED) {
                this.node = persistentTask.getExecutorNode();
                return true;
            }
            return false;
        }
    }

    public static class DatafeedTask
    extends AllocatedPersistentTask
    implements StartDatafeedAction.DatafeedTaskMatcher {
        private final String datafeedId;
        private final long startTime;
        private final Long endTime;
        private DatafeedRunner datafeedRunner;
        private StoppedOrIsolated stoppedOrIsolated = StoppedOrIsolated.NEITHER;

        DatafeedTask(long id, String type, String action, TaskId parentTaskId, StartDatafeedAction.DatafeedParams params, Map<String, String> headers) {
            super(id, type, action, "datafeed-" + params.getDatafeedId(), parentTaskId, headers);
            this.datafeedId = params.getDatafeedId();
            this.startTime = params.getStartTime();
            this.endTime = params.getEndTime();
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public long getDatafeedStartTime() {
            return this.startTime;
        }

        @Nullable
        public Long getEndTime() {
            return this.endTime;
        }

        public boolean isLookbackOnly() {
            return this.endTime != null;
        }

        StoppedOrIsolated setDatafeedRunner(DatafeedRunner datafeedRunner) {
            return this.executeIfNotStoppedOrIsolated(() -> {
                this.datafeedRunner = Objects.requireNonNull(datafeedRunner);
            });
        }

        public synchronized StoppedOrIsolated executeIfNotStoppedOrIsolated(Runnable runnable) {
            if (this.stoppedOrIsolated == StoppedOrIsolated.NEITHER) {
                runnable.run();
            }
            return this.stoppedOrIsolated;
        }

        protected void onCancelled() {
            this.stop(this.getReasonCancelled(), TimeValue.ZERO);
        }

        public boolean shouldCancelChildrenOnCancellation() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(String reason, TimeValue timeout) {
            DatafeedTask datafeedTask = this;
            synchronized (datafeedTask) {
                this.stoppedOrIsolated = StoppedOrIsolated.STOPPED;
                if (this.datafeedRunner == null) {
                    return;
                }
            }
            this.datafeedRunner.stopDatafeed(this, reason, timeout);
        }

        public synchronized StoppedOrIsolated getStoppedOrIsolated() {
            return this.stoppedOrIsolated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void isolate() {
            DatafeedTask datafeedTask = this;
            synchronized (datafeedTask) {
                if (this.stoppedOrIsolated == StoppedOrIsolated.NEITHER) {
                    this.stoppedOrIsolated = StoppedOrIsolated.ISOLATED;
                }
                if (this.datafeedRunner == null) {
                    return;
                }
            }
            this.datafeedRunner.isolateDatafeed(this);
        }

        void completeOrFailIfRequired(Exception error) {
            if (this.isCompleted()) {
                return;
            }
            if (error != null) {
                this.markAsFailed(error);
            } else {
                this.markAsCompleted();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GetDatafeedRunningStateAction.Response.RunningState getRunningState() {
            DatafeedTask datafeedTask = this;
            synchronized (datafeedTask) {
                if (this.datafeedRunner == null) {
                    return new GetDatafeedRunningStateAction.Response.RunningState(this.endTime == null, false, null);
                }
            }
            return new GetDatafeedRunningStateAction.Response.RunningState(this.endTime == null, this.datafeedRunner.finishedLookBack(this), this.datafeedRunner.getSearchInterval(this));
        }

        public static enum StoppedOrIsolated {
            NEITHER,
            ISOLATED,
            STOPPED;

        }
    }

    public static class StartDatafeedPersistentTasksExecutor
    extends PersistentTasksExecutor<StartDatafeedAction.DatafeedParams> {
        private final DatafeedRunner datafeedRunner;
        private final IndexNameExpressionResolver resolver;

        public StartDatafeedPersistentTasksExecutor(DatafeedRunner datafeedRunner, IndexNameExpressionResolver resolver, ThreadPool threadPool) {
            super("xpack/ml/datafeed", (Executor)threadPool.executor("ml_utility"));
            this.datafeedRunner = datafeedRunner;
            this.resolver = resolver;
        }

        public PersistentTasksCustomMetadata.Assignment getAssignment(StartDatafeedAction.DatafeedParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
            return new DatafeedNodeSelector(clusterState, this.resolver, params.getDatafeedId(), params.getJobId(), params.getDatafeedIndices(), params.getIndicesOptions()).selectNode(candidateNodes);
        }

        public void validate(StartDatafeedAction.DatafeedParams params, ClusterState clusterState) {
            new DatafeedNodeSelector(clusterState, this.resolver, params.getDatafeedId(), params.getJobId(), params.getDatafeedIndices(), params.getIndicesOptions()).checkDatafeedTaskCanBeCreated();
        }

        protected void nodeOperation(AllocatedPersistentTask allocatedPersistentTask, StartDatafeedAction.DatafeedParams params, PersistentTaskState state) {
            DatafeedTask datafeedTask = (DatafeedTask)allocatedPersistentTask;
            DatafeedState datafeedState = (DatafeedState)state;
            if (DatafeedState.STOPPING.equals((Object)datafeedState)) {
                logger.info("[{}] datafeed got reassigned while stopping. Marking as completed", (Object)params.getDatafeedId());
                datafeedTask.completeOrFailIfRequired(null);
                return;
            }
            switch (datafeedTask.setDatafeedRunner(this.datafeedRunner)) {
                case NEITHER: {
                    this.datafeedRunner.run(datafeedTask, datafeedTask::completeOrFailIfRequired);
                    break;
                }
                case ISOLATED: {
                    logger.info("[{}] datafeed isolated immediately after reassignment.", (Object)params.getDatafeedId());
                    break;
                }
                case STOPPED: {
                    logger.info("[{}] datafeed stopped immediately after reassignment. Marking as completed", (Object)params.getDatafeedId());
                    datafeedTask.completeOrFailIfRequired(null);
                }
            }
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<StartDatafeedAction.DatafeedParams> persistentTask, Map<String, String> headers) {
            return new DatafeedTask(id, type, action, parentTaskId, (StartDatafeedAction.DatafeedParams)persistentTask.getParams(), headers);
        }
    }
}

