/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.backward_codecs.lucene70.Lucene70Codec;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Version;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene70.BWCLucene70Codec;

public abstract class BWCCodec
extends Codec {
    protected BWCCodec(String name) {
        super(name);
    }

    public NormsFormat normsFormat() {
        throw new UnsupportedOperationException();
    }

    public TermVectorsFormat termVectorsFormat() {
        throw new UnsupportedOperationException();
    }

    public KnnVectorsFormat knnVectorsFormat() {
        throw new UnsupportedOperationException();
    }

    protected static SegmentInfoFormat wrap(final SegmentInfoFormat wrapped) {
        return new SegmentInfoFormat(){

            public SegmentInfo read(Directory directory, String segmentName, byte[] segmentID, IOContext context) throws IOException {
                return BWCCodec.wrap(wrapped.read(directory, segmentName, segmentID, context));
            }

            public void write(Directory dir, SegmentInfo info, IOContext ioContext) throws IOException {
                wrapped.write(dir, info, ioContext);
            }
        };
    }

    protected static FieldInfosFormat wrap(final FieldInfosFormat wrapped) {
        return new FieldInfosFormat(){

            public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
                return BWCCodec.filterFields(wrapped.read(directory, segmentInfo, segmentSuffix, iocontext));
            }

            public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
                wrapped.write(directory, segmentInfo, segmentSuffix, infos, context);
            }
        };
    }

    private static FieldInfos filterFields(FieldInfos fieldInfos) {
        ArrayList<FieldInfo> fieldInfoCopy = new ArrayList<FieldInfo>(fieldInfos.size());
        for (FieldInfo fieldInfo : fieldInfos) {
            fieldInfoCopy.add(new FieldInfo(fieldInfo.name, fieldInfo.number, false, true, false, fieldInfo.getIndexOptions(), fieldInfo.getDocValuesType(), fieldInfo.getDocValuesGen(), fieldInfo.attributes(), fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), 0, fieldInfo.getVectorEncoding(), fieldInfo.getVectorSimilarityFunction(), fieldInfo.isSoftDeletesField(), fieldInfo.isParentField()));
        }
        FieldInfos newFieldInfos = new FieldInfos(fieldInfoCopy.toArray(new FieldInfo[0]));
        return newFieldInfos;
    }

    public static SegmentInfo wrap(SegmentInfo segmentInfo) {
        BWCLucene70Codec codec = segmentInfo.getCodec() instanceof Lucene70Codec ? new BWCLucene70Codec() : segmentInfo.getCodec();
        SegmentInfo segmentInfo1 = new SegmentInfo(segmentInfo.dir, Version.LATEST, Version.LATEST, segmentInfo.name, segmentInfo.maxDoc(), segmentInfo.getUseCompoundFile(), segmentInfo.getHasBlocks(), (Codec)codec, segmentInfo.getDiagnostics(), segmentInfo.getId(), segmentInfo.getAttributes(), segmentInfo.getIndexSort());
        segmentInfo1.setFiles((Collection)segmentInfo.files());
        return segmentInfo1;
    }

    public static class EmptyPostingsFormat
    extends PostingsFormat {
        public EmptyPostingsFormat() {
            super("EmptyPostingsFormat");
        }

        public FieldsConsumer fieldsConsumer(SegmentWriteState state) {
            return new FieldsConsumer(){

                public void write(Fields fields, NormsProducer norms) {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                }
            };
        }

        public FieldsProducer fieldsProducer(SegmentReadState state) {
            return new FieldsProducer(){

                public void close() {
                }

                public void checkIntegrity() {
                }

                public Iterator<String> iterator() {
                    return null;
                }

                public Terms terms(String field) {
                    return null;
                }

                public int size() {
                    return 0;
                }
            };
        }
    }
}

