/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.validation;

import org.elasticsearch.core.Strings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.services.validation.ChatCompletionModelValidator;
import org.elasticsearch.xpack.inference.services.validation.ModelValidator;
import org.elasticsearch.xpack.inference.services.validation.SimpleModelValidator;
import org.elasticsearch.xpack.inference.services.validation.SimpleServiceIntegrationValidator;
import org.elasticsearch.xpack.inference.services.validation.TextEmbeddingModelValidator;

public class ModelValidatorBuilder {
    public static ModelValidator buildModelValidator(TaskType taskType) {
        if (taskType == null) {
            throw new IllegalArgumentException("Task type can't be null");
        }
        switch (taskType) {
            case TEXT_EMBEDDING: {
                return new TextEmbeddingModelValidator(new SimpleServiceIntegrationValidator());
            }
            case COMPLETION: {
                return new ChatCompletionModelValidator(new SimpleServiceIntegrationValidator());
            }
            case SPARSE_EMBEDDING: 
            case RERANK: 
            case ANY: {
                return new SimpleModelValidator(new SimpleServiceIntegrationValidator());
            }
        }
        throw new IllegalArgumentException(Strings.format((String)"Can't validate inference model of for task type %s ", (Object[])new Object[]{taskType}));
    }
}

