/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticRerankerServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalModel;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public class ElasticRerankerModel
extends ElasticsearchInternalModel {
    public ElasticRerankerModel(String inferenceEntityId, TaskType taskType, String service, ElasticRerankerServiceSettings serviceSettings, ChunkingSettings chunkingSettings) {
        super(inferenceEntityId, taskType, service, (ElasticsearchInternalServiceSettings)serviceSettings, chunkingSettings);
    }

    @Override
    public ElasticRerankerServiceSettings getServiceSettings() {
        return (ElasticRerankerServiceSettings)super.getServiceSettings();
    }

    @Override
    public ActionListener<CreateTrainedModelAssignmentAction.Response> getCreateTrainedModelAssignmentActionListener(Model model, final ActionListener<Boolean> listener) {
        return new ActionListener<CreateTrainedModelAssignmentAction.Response>(){

            public void onResponse(CreateTrainedModelAssignmentAction.Response response) {
                listener.onResponse((Object)Boolean.TRUE);
            }

            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onFailure((Exception)new ResourceNotFoundException("Could not start the Elastic Reranker Endpoint due to [{}]", (Throwable)e, new Object[]{e.getMessage()}));
                    return;
                }
                listener.onFailure(e);
            }
        };
    }
}

