/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationDisplayType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.azureaistudio.AzureAiStudioActionVisitor;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionRequestTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class AzureAiStudioChatCompletionModel
extends AzureAiStudioModel {
    public static AzureAiStudioChatCompletionModel of(AzureAiStudioModel model, Map<String, Object> taskSettings) {
        AzureAiStudioChatCompletionModel modelAsCompletionModel = (AzureAiStudioChatCompletionModel)model;
        if (taskSettings == null || taskSettings.isEmpty()) {
            return modelAsCompletionModel;
        }
        AzureAiStudioChatCompletionRequestTaskSettings requestTaskSettings = AzureAiStudioChatCompletionRequestTaskSettings.fromMap(taskSettings);
        AzureAiStudioChatCompletionTaskSettings taskSettingToUse = AzureAiStudioChatCompletionTaskSettings.of(modelAsCompletionModel.getTaskSettings(), requestTaskSettings);
        return new AzureAiStudioChatCompletionModel(modelAsCompletionModel, taskSettingToUse);
    }

    public AzureAiStudioChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, AzureAiStudioChatCompletionServiceSettings serviceSettings, AzureAiStudioChatCompletionTaskSettings taskSettings, DefaultSecretSettings secrets) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets));
    }

    public AzureAiStudioChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, AzureAiStudioChatCompletionServiceSettings.fromMap(serviceSettings, context), AzureAiStudioChatCompletionTaskSettings.fromMap(taskSettings), DefaultSecretSettings.fromMap(secrets));
    }

    public AzureAiStudioChatCompletionModel(AzureAiStudioChatCompletionModel model, AzureAiStudioChatCompletionTaskSettings taskSettings) {
        super(model, taskSettings, model.getServiceSettings().rateLimitSettings());
    }

    public AzureAiStudioChatCompletionServiceSettings getServiceSettings() {
        return (AzureAiStudioChatCompletionServiceSettings)super.getServiceSettings();
    }

    public AzureAiStudioChatCompletionTaskSettings getTaskSettings() {
        return (AzureAiStudioChatCompletionTaskSettings)super.getTaskSettings();
    }

    @Override
    public DefaultSecretSettings getSecretSettings() {
        return super.getSecretSettings();
    }

    @Override
    protected URI getEndpointUri() throws URISyntaxException {
        if (this.provider == AzureAiStudioProvider.OPENAI || this.endpointType == AzureAiStudioEndpointType.REALTIME) {
            return new URI(this.target);
        }
        return new URI(this.target + "/v1/chat/completions");
    }

    @Override
    public ExecutableAction accept(AzureAiStudioActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }

    public static class Configuration {
        private static final LazyInitializable<Map<String, SettingsConfiguration>, RuntimeException> configuration = new LazyInitializable(() -> {
            HashMap<String, SettingsConfiguration> configurationMap = new HashMap<String, SettingsConfiguration>();
            configurationMap.put("user", new SettingsConfiguration.Builder().setDisplay(SettingsConfigurationDisplayType.TEXTBOX).setLabel("User").setOrder(Integer.valueOf(1)).setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setTooltip("Specifies the user issuing the request.").setType(SettingsConfigurationFieldType.STRING).setValue((Object)"").build());
            return Collections.unmodifiableMap(configurationMap);
        });

        public static Map<String, SettingsConfiguration> get() {
            return (Map)configuration.getOrCompute();
        }
    }
}

