/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.alibabacloudsearch;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorMessage;

public class AlibabaCloudSearchErrorResponseEntity
implements ErrorMessage {
    private static final Logger logger = LogManager.getLogger(AlibabaCloudSearchErrorResponseEntity.class);
    private final String errorMessage;

    private AlibabaCloudSearchErrorResponseEntity(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AlibabaCloudSearchErrorResponseEntity fromResponse(HttpResult response) {
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());){
            String message;
            Map responseMap = jsonParser.map();
            if (logger.isDebugEnabled()) {
                logger.debug("Received error response: {}", (Object)responseMap);
            }
            if ((message = (String)responseMap.get("message")) == null) return null;
            AlibabaCloudSearchErrorResponseEntity alibabaCloudSearchErrorResponseEntity = new AlibabaCloudSearchErrorResponseEntity(message);
            return alibabaCloudSearchErrorResponseEntity;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

