/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.IbmWatsonxRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.ibmwatsonx.IbmWatsonxResponseHandler;
import org.elasticsearch.xpack.inference.external.request.ibmwatsonx.IbmWatsonxEmbeddingsRequest;
import org.elasticsearch.xpack.inference.external.response.ibmwatsonx.IbmWatsonxEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsModel;

public class IbmWatsonxEmbeddingsRequestManager
extends IbmWatsonxRequestManager {
    private static final Logger logger = LogManager.getLogger(IbmWatsonxEmbeddingsRequestManager.class);
    private static final ResponseHandler HANDLER = IbmWatsonxEmbeddingsRequestManager.createEmbeddingsHandler();
    private final IbmWatsonxEmbeddingsModel model;
    private final Truncator truncator;

    private static ResponseHandler createEmbeddingsHandler() {
        return new IbmWatsonxResponseHandler("ibm watsonx embeddings", IbmWatsonxEmbeddingsResponseEntity::fromResponse);
    }

    public IbmWatsonxEmbeddingsRequestManager(IbmWatsonxEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        super(threadPool, model);
        this.model = Objects.requireNonNull(model);
        this.truncator = Objects.requireNonNull(truncator);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        List<String> docsInput = DocumentsOnlyInput.of(inferenceInputs).getInputs();
        Truncator.TruncationResult truncatedInput = Truncator.truncate(docsInput, this.model.getServiceSettings().maxInputTokens());
        this.execute(new ExecutableInferenceRequest(requestSender, logger, this.getEmbeddingRequest(this.truncator, truncatedInput, this.model), HANDLER, hasRequestCompletedFunction, listener));
    }

    protected IbmWatsonxEmbeddingsRequest getEmbeddingRequest(Truncator truncator, Truncator.TruncationResult truncatedInput, IbmWatsonxEmbeddingsModel model) {
        return new IbmWatsonxEmbeddingsRequest(truncator, truncatedInput, model);
    }
}

