/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.AzureAiStudioRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.DocumentsOnlyInput;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.request.azureaistudio.AzureAiStudioChatCompletionRequest;
import org.elasticsearch.xpack.inference.external.response.AzureMistralOpenAiExternalResponseHandler;
import org.elasticsearch.xpack.inference.external.response.ErrorMessageResponseEntity;
import org.elasticsearch.xpack.inference.external.response.azureaistudio.AzureAiStudioChatCompletionResponseEntity;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionModel;

public class AzureAiStudioChatCompletionRequestManager
extends AzureAiStudioRequestManager {
    private static final Logger logger = LogManager.getLogger(AzureAiStudioChatCompletionRequestManager.class);
    private static final ResponseHandler HANDLER = AzureAiStudioChatCompletionRequestManager.createCompletionHandler();
    private final AzureAiStudioChatCompletionModel model;

    public AzureAiStudioChatCompletionRequestManager(AzureAiStudioChatCompletionModel model, ThreadPool threadPool) {
        super(threadPool, model);
        this.model = model;
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        DocumentsOnlyInput docsOnly = DocumentsOnlyInput.of(inferenceInputs);
        List<String> docsInput = docsOnly.getInputs();
        boolean stream = docsOnly.stream();
        AzureAiStudioChatCompletionRequest request = new AzureAiStudioChatCompletionRequest(this.model, docsInput, stream);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }

    private static ResponseHandler createCompletionHandler() {
        return new AzureMistralOpenAiExternalResponseHandler("azure ai studio completion", new AzureAiStudioChatCompletionResponseEntity(), ErrorMessageResponseEntity::fromResponse, true);
    }
}

