/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.openai;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.action.openai.OpenAiActionVisitor;
import org.elasticsearch.xpack.inference.external.http.sender.OpenAiCompletionRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.OpenAiEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionModel;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsModel;

public class OpenAiActionCreator
implements OpenAiActionVisitor {
    private static final String COMPLETION_ERROR_PREFIX = "OpenAI chat completions";
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public OpenAiActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(OpenAiEmbeddingsModel model, Map<String, Object> taskSettings) {
        OpenAiEmbeddingsModel overriddenModel = OpenAiEmbeddingsModel.of(model, taskSettings);
        OpenAiEmbeddingsRequestManager requestCreator = OpenAiEmbeddingsRequestManager.of(overriddenModel, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(overriddenModel.getServiceSettings().uri(), "OpenAI embeddings");
        return new SenderExecutableAction(this.sender, requestCreator, errorMessage);
    }

    @Override
    public ExecutableAction create(OpenAiChatCompletionModel model, Map<String, Object> taskSettings) {
        OpenAiChatCompletionModel overriddenModel = OpenAiChatCompletionModel.of(model, taskSettings);
        OpenAiCompletionRequestManager requestCreator = OpenAiCompletionRequestManager.of(overriddenModel, this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(overriddenModel.getServiceSettings().uri(), COMPLETION_ERROR_PREFIX);
        return new SingleInputSenderExecutableAction(this.sender, requestCreator, errorMessage, COMPLETION_ERROR_PREFIX);
    }
}

