RabbitMQ `3.10.18` is a maintenance release in the `3.10.x` [release series](https://www.rabbitmq.com/versions.html).

This series [**reaches its end of community support** on July 31st, 2023](https://rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.10.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.10.0)
if upgrading from a version prior to 3.10.0.

This release **requires Erlang 24.3** and supports Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

Erlang 23 and 24 versions older than 24.3 have reached [end of support](https://www.rabbitmq.com/which-erlang.html).

This release of RabbitMQ requires Erlang 24.3 or later versions. Nodes **will fail to start** on older Erlang releases.

Erlang 25 is recommended: it offers much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).

### Core Server

#### Bug Fixes

 * Reset and manually added nodes could start receiving stream replica data before its database was initialized,
   confusing all code paths that expected a blank node state.

   GitHub issue: [#7222](https://github.com/rabbitmq/rabbitmq-server/pull/7222)

 * Nodes could run into an exception with certain publishers that used QPid for client library.

   GitHub issue: [#7119](https://github.com/rabbitmq/rabbitmq-server/issues/7119)


### CLI Tools

#### Features

 * `rabbitmqctl set_permissions_globally` is a new command that sets up user permissions in all existing virtual hosts.

   GitHub issue: [#1000](https://github.com/rabbitmq/rabbitmq-server/issues/1000)

 * `rabbitmq-diagnostics cluster_status` now lists how many CPU cores are available to individual nodes, plus a total.

   GitHub issue: [#7135](https://github.com/rabbitmq/rabbitmq-server/pull/7135)


### MQTT Plugin

#### Bug Fixes

 * MQTT nodes did not correctly remove client IDs for clients connected to a node that was in the process of
   being removed from the cluster.

   GitHub issue: [#7162](https://github.com/rabbitmq/rabbitmq-server/pull/7162)


### LDAP Plugin

#### Bug Fixes

 * Due to a `$` sign escaping differences between Make and Bazel (the newly adopted build tool),
   default value of of `user_dn_pattern` setting was incorrect (had an extra `$`).

   GitHub issue: [#7161](https://github.com/rabbitmq/rabbitmq-server/issues/7161)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.10.18.tar.xz`
instead of the source tarball produced by GitHub.
