/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "अरबी";
        final String metaValue_hy = "आर्मेनियाई";
        final String metaValue_zbl = "ब्लिसिम्बॉल्स";
        final String metaValue_bug = "बगिनीस";
        final String metaValue_ccp = "चकमा";
        final String metaValue_chr = "चेरोकी";
        final String metaValue_cop = "कॉप्टिक";
        final String metaValue_el = "यूनानी";
        final String metaValue_gu = "गुजराती";
        final String metaValue_he = "हिब्रू";
        final String metaValue_ja = "जापानी";
        final String metaValue_km = "खमेर";
        final String metaValue_kn = "कन्नड़";
        final String metaValue_ko = "कोरियाई";
        final String metaValue_lo = "लाओ";
        final String metaValue_la = "लैटिन";
        final String metaValue_ml = "मलयालम";
        final String metaValue_mn = "मंगोलियाई";
        final String metaValue_or = "ओड़िया";
        final String metaValue_si = "सिंहली";
        final String metaValue_syr = "सिरिएक";
        final String metaValue_ta = "तमिल";
        final String metaValue_te = "तेलुगू";
        final String metaValue_th = "थाई";
        final String metaValue_bo = "तिब्बती";
        final String metaValue_vai = "वाई";
        final String metaValue_peo = "पुरानी फारसी";
        final Object[][] data = new Object[][] {
            { "001", "विश्व" },
            { "002", "अफ़्रीका" },
            { "003", "उत्तर अमेरिका" },
            { "005", "दक्षिण अमेरिका" },
            { "009", "ओशिआनिया" },
            { "011", "पश्चिमी अफ़्रीका" },
            { "013", "मध्य अमेरिका" },
            { "014", "पूर्वी अफ़्रीका" },
            { "015", "उत्तरी अफ़्रीका" },
            { "017", "मध्य अफ़्रीका" },
            { "018", "दक्षिणी अफ़्रीका" },
            { "019", "अमेरिकाज़" },
            { "021", "उत्तरी अमेरिका" },
            { "029", "कैरिबियन" },
            { "030", "पूर्वी एशिया" },
            { "034", "दक्षिणी एशिया" },
            { "035", "दक्षिण-पूर्व एशिया" },
            { "039", "दक्षिणी यूरोप" },
            { "053", "ऑस्ट्रेलेशिया" },
            { "054", "मेलानेशिया" },
            { "057", "माइक्रोनेशियाई क्षेत्र" },
            { "061", "पोलिनेशिया" },
            { "142", "एशिया" },
            { "143", "मध्य एशिया" },
            { "145", "पश्चिमी एशिया" },
            { "150", "यूरोप" },
            { "151", "पूर्वी यूरोप" },
            { "154", "उत्तरी यूरोप" },
            { "155", "पश्चिमी यूरोप" },
            { "202", "उप-सहारा अफ़्रीका" },
            { "419", "लैटिन अमेरिका" },
            { "AC", "असेंशन द्वीप" },
            { "AD", "एंडोरा" },
            { "AE", "संयुक्त अरब अमीरात" },
            { "AF", "अफ़गानिस्तान" },
            { "AG", "एंटिगुआ और बरबुडा" },
            { "AI", "एंग्विला" },
            { "AL", "अल्बानिया" },
            { "AM", "आर्मेनिया" },
            { "AO", "अंगोला" },
            { "AQ", "अंटार्कटिका" },
            { "AR", "अर्जेंटीना" },
            { "AS", "अमेरिकी समोआ" },
            { "AT", "ऑस्ट्रिया" },
            { "AU", "ऑस्ट्रेलिया" },
            { "AW", "अरूबा" },
            { "AX", "एलैंड द्वीपसमूह" },
            { "AZ", "अज़रबैजान" },
            { "BA", "बोस्निया और हर्ज़ेगोविना" },
            { "BB", "बारबाडोस" },
            { "BD", "बांग्लादेश" },
            { "BE", "बेल्जियम" },
            { "BF", "बुर्किना फ़ासो" },
            { "BG", "बुल्गारिया" },
            { "BH", "बहरीन" },
            { "BI", "बुरुंडी" },
            { "BJ", "बेनिन" },
            { "BL", "सेंट बार्थेलेमी" },
            { "BM", "बरमूडा" },
            { "BN", "ब्रूनेई" },
            { "BO", "बोलीविया" },
            { "BQ", "कैरिबियन नीदरलैंड" },
            { "BR", "ब्राज़ील" },
            { "BS", "बहामास" },
            { "BT", "भूटान" },
            { "BV", "बोवेत द्वीप" },
            { "BW", "बोत्स्वाना" },
            { "BY", "बेलारूस" },
            { "BZ", "बेलीज़" },
            { "CA", "कनाडा" },
            { "CC", "कोकोस (कीलिंग) द्वीपसमूह" },
            { "CD", "कांगो - किंशासा" },
            { "CF", "मध्य अफ़्रीकी गणराज्य" },
            { "CG", "कांगो – ब्राज़ाविल" },
            { "CH", "स्विट्ज़रलैंड" },
            { "CI", "कोत दिवुआर" },
            { "CK", "कुक द्वीपसमूह" },
            { "CL", "चिली" },
            { "CM", "कैमरून" },
            { "CN", "चीन" },
            { "CO", "कोलंबिया" },
            { "CP", "क्लिपर्टन द्वीप" },
            { "CQ", "सार्क" },
            { "CR", "कोस्टारिका" },
            { "CU", "क्यूबा" },
            { "CV", "केप वर्ड" },
            { "CW", "कुरासाओ" },
            { "CX", "क्रिसमस द्वीप" },
            { "CY", "साइप्रस" },
            { "CZ", "चेकिया" },
            { "DE", "जर्मनी" },
            { "DG", "डिएगो गार्सिया" },
            { "DJ", "जिबूती" },
            { "DK", "डेनमार्क" },
            { "DM", "डोमिनिका" },
            { "DO", "डोमिनिकन गणराज्य" },
            { "DZ", "अल्जीरिया" },
            { "EA", "सेउटा और मेलिला" },
            { "EC", "इक्वाडोर" },
            { "EE", "एस्टोनिया" },
            { "EG", "मिस्र" },
            { "EH", "पश्चिमी सहारा" },
            { "ER", "इरिट्रिया" },
            { "ES", "स्पेन" },
            { "ET", "इथियोपिया" },
            { "EU", "यूरोपीय संघ" },
            { "EZ", "यूरोज़ोन" },
            { "FI", "फ़िनलैंड" },
            { "FJ", "फ़िजी" },
            { "FK", "फ़ॉकलैंड द्वीपसमूह" },
            { "FM", "माइक्रोनेशिया" },
            { "FO", "फ़ेरो द्वीपसमूह" },
            { "FR", "फ़्रांस" },
            { "GA", "गैबॉन" },
            { "GB", "यूनाइटेड किंगडम" },
            { "GD", "ग्रेनाडा" },
            { "GE", "जॉर्जिया" },
            { "GF", "फ़्रेंच गुयाना" },
            { "GG", "गर्नसी" },
            { "GH", "घाना" },
            { "GI", "जिब्राल्टर" },
            { "GL", "ग्रीनलैंड" },
            { "GM", "गाम्बिया" },
            { "GN", "गिनी" },
            { "GP", "ग्वाडेलूप" },
            { "GQ", "इक्वेटोरियल गिनी" },
            { "GR", "यूनान" },
            { "GS", "दक्षिण जॉर्जिया और दक्षिण सैंडविच द्वीपसमूह" },
            { "GT", "ग्वाटेमाला" },
            { "GU", "गुआम" },
            { "GW", "गिनी-बिसाउ" },
            { "GY", "गुयाना" },
            { "HK", "हाँग काँग (चीन विशेष प्रशासनिक क्षेत्र)" },
            { "HM", "हर्ड द्वीप और मैकडोनॉल्ड द्वीपसमूह" },
            { "HN", "होंडूरास" },
            { "HR", "क्रोएशिया" },
            { "HT", "हैती" },
            { "HU", "हंगरी" },
            { "IC", "कैनेरी द्वीपसमूह" },
            { "ID", "इंडोनेशिया" },
            { "IE", "आयरलैंड" },
            { "IL", "इज़राइल" },
            { "IM", "आइल ऑफ़ मैन" },
            { "IN", "भारत" },
            { "IO", "ब्रिटिश हिंद महासागरीय क्षेत्र" },
            { "IQ", "इराक" },
            { "IR", "ईरान" },
            { "IS", "आइसलैंड" },
            { "IT", "इटली" },
            { "JE", "जर्सी" },
            { "JM", "जमैका" },
            { "JO", "जॉर्डन" },
            { "JP", "जापान" },
            { "KE", "केन्या" },
            { "KG", "किर्गिज़स्तान" },
            { "KH", "कंबोडिया" },
            { "KI", "किरिबाती" },
            { "KM", "कोमोरोस" },
            { "KN", "सेंट किट्स और नेविस" },
            { "KP", "उत्तर कोरिया" },
            { "KR", "दक्षिण कोरिया" },
            { "KW", "कुवैत" },
            { "KY", "कैमेन द्वीपसमूह" },
            { "KZ", "कज़ाखस्तान" },
            { "LA", "लाओस" },
            { "LB", "लेबनान" },
            { "LC", "सेंट लूसिया" },
            { "LI", "लिचेंस्टीन" },
            { "LK", "श्रीलंका" },
            { "LR", "लाइबेरिया" },
            { "LS", "लेसोथो" },
            { "LT", "लिथुआनिया" },
            { "LU", "लग्ज़मबर्ग" },
            { "LV", "लातविया" },
            { "LY", "लीबिया" },
            { "MA", "मोरक्को" },
            { "MC", "मोनाको" },
            { "MD", "मॉल्डोवा" },
            { "ME", "मोंटेनेग्रो" },
            { "MF", "सेंट मार्टिन" },
            { "MG", "मेडागास्कर" },
            { "MH", "मार्शल द्वीपसमूह" },
            { "MK", "उत्तरी मकदूनिया" },
            { "ML", "माली" },
            { "MM", "म्यांमार (बर्मा)" },
            { "MN", "मंगोलिया" },
            { "MO", "मकाऊ (विशेष प्रशासनिक क्षेत्र चीन)" },
            { "MP", "उत्तरी मारियाना द्वीपसमूह" },
            { "MQ", "मार्टीनिक" },
            { "MR", "मॉरिटानिया" },
            { "MS", "मोंटसेरात" },
            { "MT", "माल्टा" },
            { "MU", "मॉरीशस" },
            { "MV", "मालदीव" },
            { "MW", "मलावी" },
            { "MX", "मैक्सिको" },
            { "MY", "मलेशिया" },
            { "MZ", "मोज़ांबिक" },
            { "NA", "नामीबिया" },
            { "NC", "न्यू कैलेडोनिया" },
            { "NE", "नाइजर" },
            { "NF", "नॉरफ़ॉक द्वीप" },
            { "NG", "नाइजीरिया" },
            { "NI", "निकारागुआ" },
            { "NL", "नीदरलैंड" },
            { "NO", "नॉर्वे" },
            { "NP", "नेपाल" },
            { "NR", "नाउरु" },
            { "NU", "नीयू" },
            { "NZ", "न्यूज़ीलैंड" },
            { "OM", "ओमान" },
            { "PA", "पनामा" },
            { "PE", "पेरू" },
            { "PF", "फ़्रेंच पोलिनेशिया" },
            { "PG", "पापुआ न्यू गिनी" },
            { "PH", "फ़िलिपींस" },
            { "PK", "पाकिस्तान" },
            { "PL", "पोलैंड" },
            { "PM", "सेंट पिएरे और मिक्वेलान" },
            { "PN", "पिटकैर्न द्वीपसमूह" },
            { "PR", "पोर्टो रिको" },
            { "PS", "फ़िलिस्तीनी क्षेत्र" },
            { "PT", "पुर्तगाल" },
            { "PW", "पलाऊ" },
            { "PY", "पराग्वे" },
            { "QA", "क़तर" },
            { "QO", "आउटलाइंग ओशिनिया" },
            { "RE", "रियूनियन" },
            { "RO", "रोमानिया" },
            { "RS", "सर्बिया" },
            { "RU", "रूस" },
            { "RW", "रवांडा" },
            { "SA", "सऊदी अरब" },
            { "SB", "सोलोमन द्वीपसमूह" },
            { "SC", "सेशेल्स" },
            { "SD", "सूडान" },
            { "SE", "स्वीडन" },
            { "SG", "सिंगापुर" },
            { "SH", "सेंट हेलेना" },
            { "SI", "स्लोवेनिया" },
            { "SJ", "स्वालबार्ड और जान मायेन" },
            { "SK", "स्लोवाकिया" },
            { "SL", "सिएरा लियोन" },
            { "SM", "सैन मेरीनो" },
            { "SN", "सेनेगल" },
            { "SO", "सोमालिया" },
            { "SR", "सूरीनाम" },
            { "SS", "दक्षिण सूडान" },
            { "ST", "साओ टोम और प्रिंसिपे" },
            { "SV", "अल सल्वाडोर" },
            { "SX", "सिंट मार्टिन" },
            { "SY", "सीरिया" },
            { "SZ", "एस्वाटिनी" },
            { "TA", "ट्रिस्टन दा कुना" },
            { "TC", "तुर्क और कैकोज़ द्वीपसमूह" },
            { "TD", "चाड" },
            { "TF", "फ़्रांसीसी दक्षिणी क्षेत्र" },
            { "TG", "टोगो" },
            { "TH", "थाईलैंड" },
            { "TJ", "ताजिकिस्तान" },
            { "TK", "तोकेलाउ" },
            { "TL", "तिमोर-लेस्त" },
            { "TM", "तुर्कमेनिस्तान" },
            { "TN", "ट्यूनीशिया" },
            { "TO", "टोंगा" },
            { "TR", "तुर्किये" },
            { "TT", "त्रिनिदाद और टोबैगो" },
            { "TV", "तुवालू" },
            { "TW", "ताइवान" },
            { "TZ", "तंज़ानिया" },
            { "UA", "यूक्रेन" },
            { "UG", "युगांडा" },
            { "UM", "यू॰एस॰ आउटलाइंग द्वीपसमूह" },
            { "UN", "संयुक्त राष्ट्र" },
            { "US", "संयुक्त राज्य" },
            { "UY", "उरूग्वे" },
            { "UZ", "उज़्बेकिस्तान" },
            { "VA", "वेटिकन सिटी" },
            { "VC", "सेंट विंसेंट और ग्रेनाडाइंस" },
            { "VE", "वेनेज़ुएला" },
            { "VG", "ब्रिटिश वर्जिन द्वीपसमूह" },
            { "VI", "यू॰एस॰ वर्जिन द्वीपसमूह" },
            { "VN", "वियतनाम" },
            { "VU", "वनुआतू" },
            { "WF", "वालिस और फ़्यूचूना" },
            { "WS", "समोआ" },
            { "XA", "सूडो-एक्सेंट" },
            { "XB", "सूडो-बायडायरेक्शनल" },
            { "XK", "कोसोवो" },
            { "YE", "यमन" },
            { "YT", "मायोते" },
            { "ZA", "दक्षिण अफ़्रीका" },
            { "ZM", "ज़ाम्बिया" },
            { "ZW", "ज़िम्बाब्वे" },
            { "ZZ", "अज्ञात क्षेत्र" },
            { "aa", "अफ़ार" },
            { "ab", "अब्ख़ाज़ियन" },
            { "ae", "अवस्ताई" },
            { "af", "अफ़्रीकी" },
            { "ak", "अकन" },
            { "am", "अम्हेरी" },
            { "an", "अरागोनी" },
            { "ar", metaValue_ar },
            { "as", "असमिया" },
            { "av", "अवेरिक" },
            { "ay", "आयमारा" },
            { "az", "अज़रबैजानी" },
            { "ba", "बशख़िर" },
            { "be", "बेलारूसी" },
            { "bg", "बुल्गारियाई" },
            { "bi", "बिस्लामा" },
            { "bm", "बाम्बारा" },
            { "bn", "बंगाली" },
            { "bo", metaValue_bo },
            { "br", "ब्रेटन" },
            { "bs", "बोस्नियाई" },
            { "ca", "कातालान" },
            { "ce", "चेचन" },
            { "ch", "कमोरो" },
            { "co", "कोर्सीकन" },
            { "cr", "क्री" },
            { "cs", "चेक" },
            { "cu", "चर्च साल्विक" },
            { "cv", "चूवाश" },
            { "cy", "वेल्श" },
            { "da", "डेनिश" },
            { "de", "जर्मन" },
            { "dv", "दिवेही" },
            { "dz", "ज़ोन्गखा" },
            { "ee", "ईवे" },
            { "el", metaValue_el },
            { "en", "अंग्रेज़ी" },
            { "eo", "एस्पेरेंतो" },
            { "es", "स्पेनिश" },
            { "et", "एस्टोनियाई" },
            { "eu", "बास्क" },
            { "fa", "फ़ारसी" },
            { "ff", "फुलाह" },
            { "fi", "फ़िनिश" },
            { "fj", "फिजियन" },
            { "fo", "फ़ैरोइज़" },
            { "fr", "फ़्रेंच" },
            { "fy", "पश्चिमी फ़्रिसियाई" },
            { "ga", "आयरिश" },
            { "gd", "स्कॉटिश गाएलिक" },
            { "gl", "गैलिशियन" },
            { "gn", "गुआरानी" },
            { "gu", metaValue_gu },
            { "gv", "मैंक्स" },
            { "ha", "हौसा" },
            { "he", metaValue_he },
            { "hi", "हिन्दी" },
            { "ho", "हिरी मोटू" },
            { "hr", "क्रोएशियाई" },
            { "ht", "हैतियाई" },
            { "hu", "हंगेरियाई" },
            { "hy", metaValue_hy },
            { "hz", "हरैरो" },
            { "ia", "इंटरलिंगुआ" },
            { "id", "इंडोनेशियाई" },
            { "ie", "इंटरलिंग" },
            { "ig", "ईग्बो" },
            { "ii", "सिचुआन यी" },
            { "ik", "इनुपियाक्" },
            { "io", "इडौ" },
            { "is", "आइसलैंडिक" },
            { "it", "इतालवी" },
            { "iu", "इनुक्टिटुट" },
            { "ja", metaValue_ja },
            { "jv", "जावानीज़" },
            { "ka", "जॉर्जियाई" },
            { "kg", "कोंगो" },
            { "ki", "किकुयू" },
            { "kj", "क्वान्यामा" },
            { "kk", "कज़ाख़" },
            { "kl", "कलालीसुत" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "कनुरी" },
            { "ks", "कश्मीरी" },
            { "ku", "कुर्दिश" },
            { "kv", "कोमी" },
            { "kw", "कोर्निश" },
            { "ky", "किर्गीज़" },
            { "la", metaValue_la },
            { "lb", "लग्ज़मबर्गी" },
            { "lg", "गांडा" },
            { "li", "लिंबर्गिश" },
            { "ln", "लिंगाला" },
            { "lo", metaValue_lo },
            { "lt", "लिथुआनियाई" },
            { "lu", "ल्यूबा-कटांगा" },
            { "lv", "लातवियाई" },
            { "mg", "मालागासी" },
            { "mh", "मार्शलीज़" },
            { "mi", "माओरी" },
            { "mk", "मकदूनियाई" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "मराठी" },
            { "ms", "मलय" },
            { "mt", "माल्टीज़" },
            { "my", "बर्मीज़" },
            { "na", "नाउरू" },
            { "nb", "नॉर्वेजियाई बोकमाल" },
            { "nd", "उत्तरी देबेल" },
            { "ne", "नेपाली" },
            { "ng", "डोन्गा" },
            { "nl", "डच" },
            { "nn", "नॉर्वेजियाई नॉयनॉर्स्क" },
            { "no", "नॉर्वेजियाई" },
            { "nr", "दक्षिण देबेल" },
            { "nv", "नवाहो" },
            { "ny", "न्यानजा" },
            { "oc", "ओसीटान" },
            { "oj", "ओजिब्वा" },
            { "om", "ओरोमो" },
            { "or", metaValue_or },
            { "os", "ओस्सेटिक" },
            { "pa", "पंजाबी" },
            { "pi", "पाली" },
            { "pl", "पोलिश" },
            { "ps", "पश्तो" },
            { "pt", "पुर्तगाली" },
            { "qu", "क्वेचुआ" },
            { "rm", "रोमान्श" },
            { "rn", "रुन्दी" },
            { "ro", "रोमानियाई" },
            { "ru", "रूसी" },
            { "rw", "किन्यारवांडा" },
            { "sa", "संस्कृत" },
            { "sc", "सार्दिनियन" },
            { "sd", "सिंधी" },
            { "se", "नॉर्दन सामी" },
            { "sg", "सांगो" },
            { "sh", "सेर्बो-क्रोएशियाई" },
            { "si", metaValue_si },
            { "sk", "स्लोवाक" },
            { "sl", "स्लोवेनियाई" },
            { "sm", "सामोन" },
            { "sn", "शोणा" },
            { "so", "सोमाली" },
            { "sq", "अल्बानियाई" },
            { "sr", "सर्बियाई" },
            { "ss", "स्वाती" },
            { "st", "दक्षिणी सेसेथो" },
            { "su", "सुंडानी" },
            { "sv", "स्वीडिश" },
            { "sw", "स्वाहिली" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ताजिक" },
            { "th", metaValue_th },
            { "ti", "तिग्रीन्या" },
            { "tk", "तुर्कमेन" },
            { "tl", "टैगलॉग" },
            { "tn", "सेत्स्वाना" },
            { "to", "टोंगन" },
            { "tr", "तुर्की" },
            { "ts", "सोंगा" },
            { "tt", "तातार" },
            { "tw", "ट्वी" },
            { "ty", "ताहितियन" },
            { "ug", "उईग़ूर" },
            { "uk", "यूक्रेनियाई" },
            { "ur", "उर्दू" },
            { "uz", "उज़्बेक" },
            { "ve", "वेन्दा" },
            { "vi", "वियतनामी" },
            { "vo", "वोलापुक" },
            { "wa", "वाल्लून" },
            { "wo", "वोलोफ़" },
            { "xh", "ख़ोसा" },
            { "yi", "यहूदी" },
            { "yo", "योरूबा" },
            { "za", "ज़ुआंग" },
            { "zh", "चीनी" },
            { "zu", "ज़ुलू" },
            { "ace", "अचाइनीस" },
            { "ach", "अकोली" },
            { "ada", "अदान्गमे" },
            { "ady", "अदिघे" },
            { "afh", "अफ्रिहिली" },
            { "agq", "अग्हेम" },
            { "ain", "ऐनू" },
            { "akk", "अक्कादी" },
            { "ale", "अलेउत" },
            { "alt", "दक्षिणी अल्ताई" },
            { "ang", "पुरानी अंग्रेज़ी" },
            { "ann", "ओबोलो" },
            { "anp", "अंगिका" },
            { "arc", "ऐरेमेक" },
            { "arn", "मापूचे" },
            { "arp", "अरापाहो" },
            { "ars", "नज्दी अरबी" },
            { "arw", "अरावक" },
            { "asa", "असु" },
            { "ast", "अस्तुरियन" },
            { "atj", "अतिकामेक्व" },
            { "awa", "अवधी" },
            { "bal", "बलूची" },
            { "ban", "बालिनीस" },
            { "bas", "बसा" },
            { "bej", "बेजा" },
            { "bem", "बेम्बा" },
            { "bew", "बेतावी" },
            { "bez", "बेना" },
            { "bgc", "हरियाणवी" },
            { "bgn", "पश्चिमी बलोची" },
            { "bho", "भोजपुरी" },
            { "bik", "बिकोल" },
            { "bin", "बिनी" },
            { "bla", "सिक्सिका" },
            { "blo", "अनी" },
            { "bra", "ब्रज" },
            { "brx", "बोडो" },
            { "bss", "अकूसे" },
            { "bua", "बुरियात" },
            { "bug", metaValue_bug },
            { "byn", "ब्लिन" },
            { "cad", "कैड्डो" },
            { "car", "कैरिब" },
            { "cay", "कायुगा" },
            { "cch", "अत्सम" },
            { "ccp", metaValue_ccp },
            { "ceb", "सिबुआनो" },
            { "cgg", "शिगा" },
            { "chb", "चिब्चा" },
            { "chg", "छगाताई" },
            { "chk", "चूकीस" },
            { "chm", "मारी" },
            { "chn", "चिनूक जारगॉन" },
            { "cho", "चोक्तौ" },
            { "chp", "शिपेव्यान" },
            { "chr", metaValue_chr },
            { "chy", "शेयेन्न" },
            { "cic", "चिकसॉ" },
            { "ckb", "सोरानी कुर्दिश" },
            { "clc", "चिलकोटिन" },
            { "cop", metaValue_cop },
            { "crg", "मिचिफ़" },
            { "crh", "क्रीमीन तुर्की" },
            { "crj", "दक्षिण पूर्वी क्री" },
            { "crk", "प्लेन्स क्री" },
            { "crl", "नॉर्दन ईस्ट क्री" },
            { "crm", "मूस क्री" },
            { "crr", "कैरोलाइना एल्गोंक्वीयन" },
            { "crs", "सेसेल्वा क्रिओल फ्रेंच" },
            { "csb", "काशुबियन" },
            { "csw", "स्वॉम्पी क्री" },
            { "dak", "दाकोता" },
            { "dar", "दार्गवा" },
            { "dav", "तैता" },
            { "del", "डिलैवेयर" },
            { "den", "स्लेव" },
            { "dgr", "डोग्रिब" },
            { "din", "दिन्का" },
            { "dje", "झार्मा" },
            { "doi", "डोगरी" },
            { "dsb", "निचला सॉर्बियन" },
            { "dua", "दुआला" },
            { "dum", "मध्यकालीन पुर्तगाली" },
            { "dyo", "जोला-फोंई" },
            { "dyu", "ड्युला" },
            { "dzg", "दज़ागा" },
            { "ebu", "एम्बु" },
            { "efi", "एफिक" },
            { "egy", "प्राचीन मिस्री" },
            { "eka", "एकाजुक" },
            { "elx", "एलामाइट" },
            { "enm", "मध्यकालीन अंग्रेज़ी" },
            { "ewo", "इवोन्डो" },
            { "fan", "फैन्ग" },
            { "fat", "फन्टी" },
            { "fil", "फ़िलिपीनो" },
            { "fon", "फॉन" },
            { "frc", "केजन फ़्रेंच" },
            { "frm", "मध्यकालीन फ़्रांसीसी" },
            { "fro", "पुरातन फ़्रांसीसी" },
            { "frr", "उत्तरी फ़्रीसियाई" },
            { "frs", "पूर्वी फ़्रीसियाई" },
            { "fur", "फ्रीयुलीयान" },
            { "gaa", "गा" },
            { "gag", "गागौज़" },
            { "gay", "गायो" },
            { "gba", "ग्बाया" },
            { "gez", "गीज़" },
            { "gil", "गिल्बरतीस" },
            { "gmh", "मध्यकालीन हाइ जर्मन" },
            { "goh", "पुरातन हाइ जर्मन" },
            { "gon", "गाँडी" },
            { "gor", "गोरोन्तालो" },
            { "got", "गॉथिक" },
            { "grb", "ग्रेबो" },
            { "grc", "प्राचीन यूनानी" },
            { "gsw", "स्विस जर्मन" },
            { "guz", "गुसी" },
            { "gwi", "ग्विचइन" },
            { "hai", "हैडा" },
            { "haw", "हवाई" },
            { "hax", "दक्षिणी हाइदा" },
            { "hil", "हिलिगेनन" },
            { "hit", "हिताइत" },
            { "hmn", "ह्मॉंग" },
            { "hnj", "हमोंग नजुआ" },
            { "hsb", "ऊपरी सॉर्बियन" },
            { "hup", "हूपा" },
            { "hur", "हल्कोमेलम" },
            { "iba", "इबान" },
            { "ibb", "इबिबियो" },
            { "ikt", "पश्चिमी कनाडाई इनुक्टिटुट" },
            { "ilo", "इलोको" },
            { "inh", "इंगुश" },
            { "jbo", "लोज्बान" },
            { "jgo", "नगोंबा" },
            { "jmc", "मैकहैमे" },
            { "jpr", "जुदेओ-पर्शियन" },
            { "jrb", "जुदेओ-अरेबिक" },
            { "kaa", "कारा-कल्पक" },
            { "kab", "कबाइल" },
            { "kac", "काचिन" },
            { "kaj", "ज्जु" },
            { "kam", "कम्बा" },
            { "kaw", "कावी" },
            { "kbd", "कबार्डियन" },
            { "kcg", "त्याप" },
            { "kde", "मैकोंड" },
            { "kea", "काबुवेर्दियानु" },
            { "kfo", "कोरो" },
            { "kgp", "काइंगांग" },
            { "kha", "खासी" },
            { "kho", "खोतानीस" },
            { "khq", "कोयरा चीनी" },
            { "kkj", "काको" },
            { "kln", "कलेंजिन" },
            { "kmb", "किम्बन्दु" },
            { "koi", "कोमी-पर्मयाक" },
            { "kok", "कोंकणी" },
            { "kos", "कोसरैन" },
            { "kpe", "क्पेल" },
            { "krc", "कराचय-बल्कार" },
            { "krl", "करेलियन" },
            { "kru", "कुरूख" },
            { "ksb", "शम्बाला" },
            { "ksf", "बफिआ" },
            { "ksh", "कोलोनियाई" },
            { "kum", "कुमीक" },
            { "kut", "क्यूतनाई" },
            { "kwk", "क्वॉकवाला" },
            { "kxv", "कुवी" },
            { "lad", "लादीनो" },
            { "lag", "लांगि" },
            { "lah", "लाह्न्डा" },
            { "lam", "लाम्बा" },
            { "lez", "लेज़्घीयन" },
            { "lij", "लिगुरियन" },
            { "lil", "लिलोएट" },
            { "lkt", "लैकोटा" },
            { "lmo", "लोम्बार्ड" },
            { "lol", "मोंगो" },
            { "lou", "लुईज़ियाना क्रियोल" },
            { "loz", "लोज़ी" },
            { "lrc", "उत्तरी लूरी" },
            { "lsm", "सामिया" },
            { "lua", "ल्यूबा-लुलुआ" },
            { "lui", "लुइसेनो" },
            { "lun", "लुन्डा" },
            { "luo", "ल्युओ" },
            { "lus", "मिज़ो" },
            { "luy", "ल्युईआ" },
            { "mad", "मादुरीस" },
            { "mag", "मगही" },
            { "mai", "मैथिली" },
            { "mak", "मकासर" },
            { "man", "मन्डिन्गो" },
            { "mas", "मसाई" },
            { "mdf", "मोक्ष" },
            { "mdr", "मंदार" },
            { "men", "मेन्डे" },
            { "mer", "मेरु" },
            { "mfe", "मोरीस्येन" },
            { "mga", "मध्यकालीन आइरिश" },
            { "mgh", "मैखुवा-मीट्टो" },
            { "mgo", "मेटा" },
            { "mic", "मिकमैक" },
            { "min", "मिनांग्काबाउ" },
            { "mnc", "मन्चु" },
            { "mni", "मणिपुरी" },
            { "moe", "इन्नु-एईमन" },
            { "moh", "मोहौक" },
            { "mos", "मोस्सी" },
            { "mua", "मुंडैंग" },
            { "mul", "एकाधिक भाषाएँ" },
            { "mus", "क्रीक" },
            { "mwl", "मिरांडी" },
            { "mwr", "मारवाड़ी" },
            { "myv", "एर्ज़या" },
            { "mzn", "माज़न्देरानी" },
            { "nan", "मिन नान" },
            { "nap", "नीपोलिटन" },
            { "naq", "नामा" },
            { "nds", "निचला जर्मन" },
            { "new", "नेवाड़ी" },
            { "nia", "नियास" },
            { "niu", "नियुआन" },
            { "nmg", "क्वासिओ" },
            { "nnh", "गैम्बू" },
            { "nog", "नोगाई" },
            { "non", "पुराना नॉर्स" },
            { "nqo", "एन्को" },
            { "nso", "उत्तरी सोथो" },
            { "nus", "नुएर" },
            { "nwc", "पारम्परिक नेवारी" },
            { "nym", "न्यामवेज़ी" },
            { "nyn", "न्यानकोल" },
            { "nyo", "न्योरो" },
            { "nzi", "न्ज़ीमा" },
            { "ojb", "उत्तरपश्चिमी ओजिब्वे" },
            { "ojc", "सेंट्रल ओजीब्वे" },
            { "ojs", "ओजी-क्री" },
            { "ojw", "पश्चिमी ओजिब्वा" },
            { "oka", "ओकनागन" },
            { "osa", "ओसेज" },
            { "ota", "ओटोमान तुर्किश" },
            { "pag", "पंगासीनान" },
            { "pal", "पाह्लावी" },
            { "pam", "पाम्पान्गा" },
            { "pap", "पापियामेन्टो" },
            { "pau", "पलोउआन" },
            { "pcm", "नाइजीरियाई पिडगिन" },
            { "peo", metaValue_peo },
            { "phn", "फोएनिशियन" },
            { "pis", "पाईजिन" },
            { "pon", "पोह्नपिएन" },
            { "pqm", "मलेसीट-पासेमेक्वोडी" },
            { "prg", "प्रुशियाई" },
            { "pro", "पुरानी प्रोवेन्सल" },
            { "quc", "किश" },
            { "raj", "राजस्थानी" },
            { "rap", "रापानुई" },
            { "rar", "रारोतोंगन" },
            { "rhg", "रोहिंग्या" },
            { "rof", "रोम्बो" },
            { "rom", "रोमानी" },
            { "rup", "अरोमानियन" },
            { "rwk", "रवा" },
            { "sad", "सन्डावे" },
            { "sah", "याकूत" },
            { "sam", "सामैरिटन अरैमिक" },
            { "saq", "सैम्बुरु" },
            { "sas", "सासाक" },
            { "sat", "संथाली" },
            { "sba", "न्गाम्बे" },
            { "sbp", "सैंगु" },
            { "scn", "सिसिलियन" },
            { "sco", "स्कॉट्स" },
            { "sdh", "दक्षिणी कार्डिश" },
            { "seh", "सेना" },
            { "sel", "सेल्कप" },
            { "ses", "कोयराबोरो सेन्नी" },
            { "sga", "पुरानी आइरिश" },
            { "shi", "तैचेल्हित" },
            { "shn", "शैन" },
            { "sid", "सिदामो" },
            { "slh", "दक्षिणी लशूटसीड" },
            { "sma", "दक्षिणी सामी" },
            { "smj", "ल्युल सामी" },
            { "smn", "इनारी सामी" },
            { "sms", "स्कोल्ट सामी" },
            { "snk", "सोनिन्के" },
            { "sog", "सोग्डिएन" },
            { "srn", "स्रानान टॉन्गो" },
            { "srr", "सेरेर" },
            { "ssy", "साहो" },
            { "str", "स्ट्रेट्स सैलिश" },
            { "suk", "सुकुमा" },
            { "sus", "सुसु" },
            { "sux", "सुमेरियन" },
            { "swb", "कोमोरियन" },
            { "syc", "क्लासिकल सिरिएक" },
            { "syr", metaValue_syr },
            { "szl", "सायलिज़ियन" },
            { "tce", "दक्षिणी टशोनी" },
            { "tem", "टिम्ने" },
            { "teo", "टेसो" },
            { "ter", "तेरेनो" },
            { "tet", "तेतुम" },
            { "tgx", "टैगिश" },
            { "tht", "टैल्हटन" },
            { "tig", "टाइग्रे" },
            { "tiv", "तिव" },
            { "tkl", "तोकेलाऊ" },
            { "tlh", "क्लिंगन" },
            { "tli", "त्लिंगित" },
            { "tmh", "तामाशेक" },
            { "tog", "न्यासा टोन्गा" },
            { "tok", "टोकी पोना" },
            { "tpi", "टोक पिसिन" },
            { "trv", "तारोको" },
            { "tsi", "त्सिमीशियन" },
            { "ttm", "उत्तरी टुशोनी" },
            { "tum", "तम्बूका" },
            { "tvl", "तुवालु" },
            { "twq", "टासवाक" },
            { "tyv", "तुवीनियन" },
            { "tzm", "मध्य एटलस तमाज़ित" },
            { "udm", "उदमुर्त" },
            { "uga", "युगैरिटिक" },
            { "umb", "उम्बुन्डु" },
            { "und", "अज्ञात भाषा" },
            { "vai", metaValue_vai },
            { "vec", "वेनीशियन" },
            { "vmw", "मखुवा" },
            { "vot", "वॉटिक" },
            { "vun", "वुंजो" },
            { "wae", "वाल्सर" },
            { "wal", "वलामो" },
            { "war", "वारै" },
            { "was", "वाशो" },
            { "wbp", "वॉल्पेरी" },
            { "wuu", "वू चीनी" },
            { "xal", "काल्मिक" },
            { "xnr", "कांगड़ी" },
            { "xog", "सोगा" },
            { "yao", "याओ" },
            { "yap", "यापीस" },
            { "yav", "यांगबेन" },
            { "ybb", "येंबा" },
            { "yrl", "नेइंगातू" },
            { "yue", "कैंटोनीज़" },
            { "zap", "ज़ेपोटेक" },
            { "zbl", metaValue_zbl },
            { "zen", "ज़ेनान्गा" },
            { "zgh", "मानक मोरक्कन तामाज़ाइट" },
            { "zun", "ज़ूनी" },
            { "zxx", "कोई भाषा सामग्री नहीं" },
            { "zza", "ज़ाज़ा" },
            { "Adlm", "ऐडलम" },
            { "Arab", metaValue_ar },
            { "Aran", "नस्तालीक़" },
            { "Armi", "इम्पिरियल आर्मेनिक" },
            { "Armn", metaValue_hy },
            { "Avst", "अवेस्तन" },
            { "Bali", "बाली" },
            { "Batk", "बटकी" },
            { "Beng", "बांग्ला" },
            { "Blis", metaValue_zbl },
            { "Bopo", "बोपोमोफ़ो" },
            { "Brah", "ब्रह्मी" },
            { "Brai", "ब्रेल" },
            { "Bugi", metaValue_bug },
            { "Buhd", "बुहिद" },
            { "Cakm", metaValue_ccp },
            { "Cans", "यूनिफ़ाइड कैनेडियन एबोरिजनल सिलेबिक्स" },
            { "Cari", "करैन" },
            { "Cham", "चाम" },
            { "Cher", metaValue_chr },
            { "Cirt", "किर्थ" },
            { "Copt", metaValue_cop },
            { "Cprt", "काइप्रायट" },
            { "Cyrl", "सिरिलिक" },
            { "Cyrs", "ओल्ड चर्च स्लावोनिक सिरिलिक" },
            { "Deva", "देवनागरी" },
            { "Dsrt", "डेसरेट" },
            { "Egyd", "इजिप्शियन डेमोटिक" },
            { "Egyh", "इजिप्शियन हाइरेटिक" },
            { "Egyp", "इजिप्शियन हाइरोग्लिफ्स" },
            { "Ethi", "इथियोपियाई" },
            { "Geok", "जॉर्जियन खुतसुरी" },
            { "Geor", "जॉर्जियन" },
            { "Glag", "ग्लेगोलिटिक" },
            { "Goth", "गोथिक" },
            { "Gran", "ग्रन्थ" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "गुरमुखी" },
            { "Hanb", "हांब" },
            { "Hang", "हंगुल" },
            { "Hani", "हान" },
            { "Hano", "हनुनू" },
            { "Hans", "सरलीकृत" },
            { "Hant", "पारंपरिक" },
            { "Hebr", metaValue_he },
            { "Hira", "हिरागाना" },
            { "Hmng", "पाहो ह्मोन्ग" },
            { "Hrkt", "जापानी सिलेबरीज़" },
            { "Hung", "ऑल्ड हंगेरियन" },
            { "Inds", "सिन्धु" },
            { "Ital", "पुरानी इटली" },
            { "Jamo", "जामो" },
            { "Java", "जावानीस" },
            { "Jpan", metaValue_ja },
            { "Kali", "कायाह ली" },
            { "Kana", "काताकाना" },
            { "Khar", "खारोशथी" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "कैथी" },
            { "Lana", "लाना" },
            { "Laoo", metaValue_lo },
            { "Latf", "फ़्रैक्टुर लातिनी" },
            { "Latg", "गेली लातिनी" },
            { "Latn", metaValue_la },
            { "Lepc", "लेपचा" },
            { "Limb", "लिम्बू" },
            { "Lina", "लीनियर A" },
            { "Linb", "लीनियर बी" },
            { "Lyci", "लिशियन" },
            { "Lydi", "लिडियन" },
            { "Mand", "मनडेन" },
            { "Mani", "मनीशीन" },
            { "Maya", "मयान हाइरोग्लिफ्स" },
            { "Mero", "मेरोइटिक" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "मून" },
            { "Mtei", "मेइतेइ मायेक" },
            { "Mymr", "म्यांमार" },
            { "Nkoo", "एन्‘को" },
            { "Ogam", "ओगम" },
            { "Olck", "ओल चिकी" },
            { "Orkh", "ओरखोन" },
            { "Orya", metaValue_or },
            { "Osma", "ओस्मान्या" },
            { "Perm", "ओल्ड परमिक" },
            { "Phag", "फाग्स-पा" },
            { "Phli", "इंस्क्रिपश्नल पाहलवी" },
            { "Phlp", "सॉल्टर पाहलवी" },
            { "Phlv", "बुक पाहलवी" },
            { "Phnx", "फोनिशियन" },
            { "Plrd", "पॉलार्ड फोनेटिक" },
            { "Prti", "इंस्क्रिपश्नल पार्थियन" },
            { "Qaag", "ज़ौजी" },
            { "Rjng", "रीजांग" },
            { "Rohg", "हनिफ़ि" },
            { "Roro", "रोन्गोरोन्गो" },
            { "Runr", "रूनिक" },
            { "Samr", "समरिटन" },
            { "Sara", "सराती" },
            { "Saur", "सौराष्ट्र" },
            { "Sgnw", "सांकेतिक लेख" },
            { "Shaw", "शावियान" },
            { "Sinh", metaValue_si },
            { "Sund", "सूडानी" },
            { "Sylo", "सिलोती नागरी" },
            { "Syrc", metaValue_syr },
            { "Syre", "एस्त्रेन्जेलो सिरिएक" },
            { "Syrj", "पश्चिम सिरिएक" },
            { "Syrn", "पूर्व सिरिएक" },
            { "Tagb", "तगबन्वा" },
            { "Tale", "ताई ली" },
            { "Talu", "नया ताई लु" },
            { "Taml", metaValue_ta },
            { "Tavt", "ताई विएत" },
            { "Telu", metaValue_te },
            { "Teng", "तेन्गवार" },
            { "Tfng", "तिफ़िनाघ" },
            { "Tglg", "टैगालोग" },
            { "Thaa", "थाना" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "युगारिटिक" },
            { "Vaii", metaValue_vai },
            { "Visp", "विसिबल स्पीच" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "सुमेरो अक्कादियन सुनिफॉर्म" },
            { "Yiii", "यी" },
            { "Zinh", "विरासत" },
            { "Zmth", "गणितीय संकेतन" },
            { "Zsye", "ईमोजी" },
            { "Zsym", "चिह्न" },
            { "Zxxx", "अलिखित" },
            { "Zyyy", "सामान्य" },
            { "Zzzz", "अज्ञात लिपि" },
            { "de_AT", "ऑस्ट्रियाई जर्मन" },
            { "de_CH", "स्विस उच्च जर्मन" },
            { "en_AU", "ऑस्ट्रेलियाई अंग्रेज़ी" },
            { "en_CA", "कनाडाई अंग्रेज़ी" },
            { "en_GB", "ब्रिटिश अंग्रेज़ी" },
            { "en_US", "अमेरिकी अंग्रेज़ी" },
            { "es_ES", "यूरोपीय स्पेनिश" },
            { "es_MX", "मैक्सिकन स्पेनिश" },
            { "fa_AF", "दारी" },
            { "fr_CA", "कनाडाई फ़्रेंच" },
            { "fr_CH", "स्विस फ़्रेंच" },
            { "nl_BE", "फ़्लेमिश" },
            { "pt_BR", "ब्राज़ीली पुर्तगाली" },
            { "pt_PT", "यूरोपीय पुर्तगाली" },
            { "ro_MD", "मोलडावियन" },
            { "sw_CD", "कांगो स्वाहिली" },
            { "%%1901", "पारम्पारिक जर्मन वर्तनी" },
            { "%%1996", "जर्मेनी की 1996 वर्तनी" },
            { "ar_001", "आधुनिक मानक अरबी" },
            { "es_419", "लैटिन अमेरिकी स्पेनिश" },
            { "key.ca", "कैलेंडर" },
            { "key.cf", "मुद्रा प्रारूप" },
            { "key.co", "वर्गीकरण क्रम" },
            { "key.cu", "मुद्रा" },
            { "key.em", "इमोजी का प्रज़ेंटेशन" },
            { "key.hc", "घंटों का चक्र (12 बनाम 24)" },
            { "key.lb", "पंक्ति विच्छेद शैली" },
            { "key.lw", "शब्दों के बीच पंक्ति विच्छेद" },
            { "key.ms", "मापन प्रणाली" },
            { "key.nu", "संख्याएँ" },
            { "key.ss", "संक्षेपण के बाद वाक्य विच्छेद" },
            { "key.tz", "समय क्षेत्र" },
            { "key.va", "स्थानीय प्रकार" },
            { "nds_NL", "निचली सैक्सन" },
            { "%%NJIVA", "जीवा बोली" },
            { "%%POSIX", "कम्प्यूटर" },
            { "zh_Hans", "सरलीकृत चीनी" },
            { "zh_Hant", "पारंपरिक चीनी" },
            { "%%PINYIN", "पिनयिन रोमनाइज़ेशन" },
            { "%%AREVELA", "पूर्वी अर्मेनियाई" },
            { "%%MONOTON", "एकस्वरीय" },
            { "%%POLYTON", "बहुस्वरीय" },
            { "%%REVISED", "संशोधित वर्तनी" },
            { "%%SCOTLAND", "स्कॉटिश मानक अंग्रेज़ी" },
            { "%%WADEGILE", "वेड-जाइल्स रोमनाइज़ेशन" },
            { "type.ca.roc", "चीनी गणतंत्र पंचांग" },
            { "type.co.eor", "यूरोपीय क्रमण नियम" },
            { "type.hc.h11", "12 घंटों की प्रणाली (0–11)" },
            { "type.hc.h12", "12 घंटों की प्रणाली (1–12)" },
            { "type.hc.h23", "24 घंटों की प्रणाली (0–23)" },
            { "type.hc.h24", "24 घंटों की प्रणाली (1–24)" },
            { "type.m0.bgn", "BGN लिप्यंतरण" },
            { "type.nu.arab", "अरबी-भारतीय अंक" },
            { "type.nu.armn", "आर्मेनियाई संख्याएँ" },
            { "type.nu.beng", "बंगाली अंक" },
            { "type.nu.cakm", "चकमा अंक" },
            { "type.nu.deva", "देवनागरी अंक" },
            { "type.nu.ethi", "इथियोपियाई संख्याएँ" },
            { "type.nu.geor", "जॉर्जियन संख्याएँ" },
            { "type.nu.grek", "यूनानी संख्याएँ" },
            { "type.nu.gujr", "गुजराती अंक" },
            { "type.nu.guru", "गुरमुखी अंक" },
            { "type.nu.hans", "सरलीकृत चीनी संख्याएँ" },
            { "type.nu.hant", "पारंपरिक चीनी संख्याएँ" },
            { "type.nu.hebr", "हिब्रू संख्याएँ" },
            { "type.nu.java", "जावानीज़ अंक" },
            { "type.nu.jpan", "जापानी संख्याएँ" },
            { "type.nu.khmr", "खमेर अंक" },
            { "type.nu.knda", "कन्नड़ अंक" },
            { "type.nu.laoo", "लाओ अंक" },
            { "type.nu.latn", "पश्चिमी अंक" },
            { "type.nu.mlym", "मलयालम अंक" },
            { "type.nu.mong", "मंगोलियाई अंक" },
            { "type.nu.mtei", "मीतेई मयक अंक" },
            { "type.nu.mymr", "म्यांमार अंक" },
            { "type.nu.olck", "ओल चिकी अंक" },
            { "type.nu.orya", "ओड़िया अंक" },
            { "type.nu.taml", "पारंपरिक तमिल संख्याएँ" },
            { "type.nu.telu", "तेलुगू अंक" },
            { "type.nu.thai", "थाई अंक" },
            { "type.nu.tibt", "तिब्बती अंक" },
            { "type.nu.vaii", "वाई अंक" },
            { "type.ca.dangi", "दांगी कैलेंडर" },
            { "type.co.ducet", "डिफ़ॉल्ट यूनिकोड वर्गीकरण क्रम" },
            { "type.lb.loose", "ढीली पंक्ति विच्छेद शैली" },
            { "type.nu.roman", "रोमन संख्याएँ" },
            { "type.ca.coptic", "कॉप्टिक कैलेंडर" },
            { "type.ca.hebrew", "हिब्रू पंचांग" },
            { "type.ca.indian", "भारतीय राष्ट्रीय कैलेंडर" },
            { "type.co.compat", "संगतता के लिए पिछला वर्गीकरण क्रम" },
            { "type.co.pinyin", "पिनयिन वर्गीकरण क्रम" },
            { "type.co.search", "सामान्य-उद्देश्य खोज" },
            { "type.co.stroke", "स्ट्रोक वर्गीकरण क्रम" },
            { "type.co.unihan", "रेडिकल-स्ट्रोक वर्गीकरण क्रम" },
            { "type.co.zhuyin", "ज़ूइन वर्गीकरण क्रम" },
            { "type.d0.fwidth", "पूर्ण-चौड़ाई" },
            { "type.d0.hwidth", "आधी-चौड़ाई" },
            { "type.lb.normal", "सामान्य पंक्ति विच्छेद शैली" },
            { "type.lb.strict", "सख्त पंक्ति विच्छेद शैली" },
            { "type.m0.ungegn", "UNGEGN लिप्यंतरण" },
            { "type.ms.metric", "मेट्रिक प्रणाली" },
            { "type.nu.native", "स्थानीय अंक" },
            { "type.ca.chinese", "चीनी पंचांग" },
            { "type.ca.islamic", "हिजरी कैलेंडर" },
            { "type.ca.iso8601", "आईएसओ-8601 कैलेंडर" },
            { "type.ca.persian", "फ़ारसी कैलेंडर" },
            { "type.cf.account", "लेखांकन मुद्रा प्रारूप" },
            { "type.d0.npinyin", "सांख्यिक" },
            { "type.nu.arabext", "विस्तृत अरबी-भारतीय अंक" },
            { "type.nu.armnlow", "आर्मेनियाई लोअरकेस संख्याएँ" },
            { "type.nu.finance", "वित्तीय अंक" },
            { "type.nu.greklow", "यूनानी लोअरकेस संख्याएँ" },
            { "type.nu.hanidec", "चीनी दशमलव संख्याएँ" },
            { "type.nu.hansfin", "सरलीकृत चीनी वित्तीय संख्याएँ" },
            { "type.nu.hantfin", "पारंपरिक चीनी वित्तीय संख्याएँ" },
            { "type.nu.jpanfin", "जापानी वित्तीय संख्याएँ" },
            { "type.nu.tamldec", "तमिल अंक" },
            { "type.ca.buddhist", "बौद्ध पंचांग" },
            { "type.ca.ethiopic", "इथियोपिक कैलेंडर" },
            { "type.ca.japanese", "जापानी पंचांग" },
            { "type.cf.standard", "मानक मुद्रा प्रारूप" },
            { "type.co.phonetic", "ध्वन्यात्मक वर्गीकरण क्रम" },
            { "type.co.searchjl", "हांगुल आरंभिक व्‍यंजन द्वारा खोजें" },
            { "type.co.standard", "मानक वर्गीकरण क्रम" },
            { "type.ms.uksystem", "इम्पीरियल मापन प्रणाली" },
            { "type.ms.ussystem", "अमेरिकी मापन प्रणाली" },
            { "type.nu.fullwide", "पूर्ण चौड़ाई अंक" },
            { "type.nu.romanlow", "रोमन लोअरकेस संख्याएँ" },
            { "type.ca.gregorian", "ग्रेगोरियन कैलेंडर" },
            { "type.co.phonebook", "फ़ोनबुक वर्गीकरण क्रम" },
            { "type.co.dictionary", "शब्दकोश वर्गीकरण क्रम" },
            { "type.co.traditional", "पारंपरिक वर्गीकरण क्रम" },
            { "type.nu.traditional", "परंपरागत अंक" },
            { "type.ca.islamic-civil", "हिजरी नागरिक कैलेंडर" },
            { "type.ca.islamic-umalqura", "हिजरी कैलेंडर (उम्म अल-क़ुरा)" },
            { "type.ca.ethiopic-amete-alem", "इथियोपिक अमेते अलेम कैलेंडर" },
        };
        return data;
    }
}
