#!/usr/bin/env python3

import flask
import flask_restful
from flask_restful import reqparse
import uuid

fakepincode = 'WN268AH3'
accesstoken = 'c.fCJC0MzwLlj9mWVU8OsxYRw1OmHLyvUSarFx7wjYlDmx2B0p7Rlg8VcT8eiLtua0UwBWRhaOHCKkzgam0JwJv5AUTV2qinYWsSzLF9Qz8Py5KSwjyV4L2os2KlnkNebauMkXlmP1sfs8HdPc'
app = flask.Flask(__name__)
api = flask_restful.Api(app)


class GetFakePincode(flask_restful.Resource):
    def get(self):
        result = {'fakepincode': fakepincode}
        return result

    def put(self):
        parser = flask_restful.reqparse.RequestParser()
        parser.add_argument('fakepincode')
        args = parser.parse_args()
        result = {'fakepincode': args['fakepincode']}
        fakepincode = args['fakepincode']
        return result, 201

class AccessToken(flask_restful.Resource):
    def post(self):
        parser = flask_restful.reqparse.RequestParser()
        parser.add_argument('code')
        parser.add_argument('client_id')
        parser.add_argument('client_secret')
        parser.add_argument('grant_type')
        args = parser.parse_args()
        instanceID = str(uuid.uuid1())
        if (args['code'] != fakepincode):
            result = { 'error': 'oauth2_error',
                       'error_description': 'authorization code not found',
                       'instance_id': instanceID }
            return result,201
        result = {'access_token': accesstoken, 'expires_in': 315360000}
        return result, 201

class ListCamera(flask_restful.Resource):
    def get(self):
        parser = flask_restful.reqparse.RequestParser()
        parser.add_argument('Authorization', type=str, location='headers')
        args = parser.parse_args()
        print(args);
        instanceID = str(uuid.uuid1())
        if (args['Authorization'] != 'Bearer '+accesstoken):
            result = { 'error': 'unauthorized',
                       'type': 'https://developer.nest.com/documentation/cloud/error-messages#auth-error',
                       'message': 'unauthorized',
                       'instance_id': instanceID }
            return result,201

        result = {
            'devices': {
                'cameras': {
                    '7lHyGwOIZ7bMmQPPVfYqs5PVlaoU3rx0wanU19-QRBSoK3DwZ1XaMw': {
                        'name': 'Office',
                        'software_version': '205-600055',
                        'where_id': 'BRfAR8DqNjP4wgeCHJMXB6T8h5sM_oWcFbw4BdgS4lXxRlwbCdX9wQ',
                        'device_id': '7lHyGwOIZ7bMmQPPVfYqs5PVlaoU3rx0wanU19-QRBSoK3DwZ1XaMw',
                        'structure_id': 'T9L9obNI8LxtBghzreo0rj8VHxLowV0WPFpxpqhKygR--PRqEyT1DA',
                        'is_online': 'true',
                        'is_streaming': 'false',
                        'is_audio_input_enabled': 'true',
                        'last_is_online_change': '2017-09-27T16:28:18.000Z',
                        'is_video_history_enabled': 'true',
                        'is_public_share_enabled': 'true',
                        'last_event': {
                            'has_sound': 'false',
                            'has_motion': 'true',
                            'has_person': 'false',
                            'start_time': '2017-09-27T16:27:43.410Z',
                            'end_time': '2017-09-27T16:27:45.320Z',
                            'urls_expire_time': '2017-10-07T16:27:43.410Z',
                            'web_url': 'https://home.nest.com/cameras/CjY3bEh5R3dPSVo3Yk1tUVBQVmZZcXM1UFZsYW9VM3J4MHdhblUxOS1RUkJTb0szRHdaMVhhTXcSFmpSZlBmTnRnYVFBbkRPdmIyVEpPM0EaNkVycmw0a3pqMVZ3am15bnpQZlBHLVVtV1hqNmFIWmppY2FUTWdLcl9nY05abEpLTWVRM0ZfQQ/cuepoints/kfM23u5xqKPjz4mgo6oYfQ?auth=815fOF6Lsj2jLh_-xNglQuf5zt3OAh2M0MaGd9didhborxrTRiDAlKNnPBwmaN0innrbFj_zVjuw4zfxbCOh8fhpoc5D6hkglpEhHQAjyCT0Sjchwp3MB2a7dLlfr58a63X5dD3dRMtin8uGXSos98HpbAb68RaArXcoaRDR7nBnN43IWWjoYxx0ub-dssyR_iXq19rZZD3xfo',
                            'app_url': 'nestmobile://cameras/CjY3bEh5R3dPSVo3Yk1tUVBQVmZZcXM1UFZsYW9VM3J4MHdhblUxOS1RUkJTb0szRHdaMVhhTXcSFmpSZlBmTnRnYVFBbkRPdmIyVEpPM0EaNkVycmw0a3pqMVZ3am15bnpQZlBHLVVtV1hqNmFIWmppY2FUTWdLcl9nY05abEpLTWVRM0ZfQQ/cuepoints/kfM23u5xqKPjz4mgo6oYfQ?auth=815fOF6Lsj2jLh_-xNglQuf5zt3OAh2M0MaGd9didhborxrTRiDAlKNnPBwmaN0innrbFj_zVjuw4zfxbCOh8fhpoc5D6hkglpEhHQAjyCT0Sjchwp3MB2a7dLlfr58a63X5dD3dRMtin8uGXSos98HpbAb68RaArXcoaRDR7nBnN43IWWjoYxx0ub-dssyR_iXq19rZZD3xfo',
                            'image_url': 'https://www.dropcam.com/api/wwn.get_image/CjY3bEh5R3dPSVo3Yk1tUVBQVmZZcXM1UFZsYW9VM3J4MHdhblUxOS1RUkJTb0szRHdaMVhhTXcSFmpSZlBmTnRnYVFBbkRPdmIyVEpPM0EaNkVycmw0a3pqMVZ3am15bnpQZlBHLVVtV1hqNmFIWmppY2FUTWdLcl9nY05abEpLTWVRM0ZfQQ/xTXo_qxXgXUzVAcxyPsYWvyE8GP18NtW?auth=815fOF6Lsj2jLh_-xNglQuf5zt3OAh2M0MaGd9didhborxrTRiDAlKNnPBwmaN0innrbFj_zVjuw4zfxbCOh8fhpoc5D6hkglpEhHQAjyCT0Sjchwp3MB2a7dLlfr58a63X5dD3dRMtin8uGXSos98HpbAb68RaArXcoaRDR7nBnN43IWWjoYxx0ub-dssyR_iXq19rZZD3xfo',
                            'animated_image_url': 'https://www.dropcam.com/api/wwn.get_animated_image/CjY3bEh5R3dPSVo3Yk1tUVBQVmZZcXM1UFZsYW9VM3J4MHdhblUxOS1RUkJTb0szRHdaMVhhTXcSFmpSZlBmTnRnYVFBbkRPdmIyVEpPM0EaNkVycmw0a3pqMVZ3am15bnpQZlBHLVVtV1hqNmFIWmppY2FUTWdLcl9nY05abEpLTWVRM0ZfQQ/xTXo_qxXgXUzVAcxyPsYWvyE8GP18NtW?auth=815fOF6Lsj2jLh_-xNglQuf5zt3OAh2M0MaGd9didhborxrTRiDAlKNnPBwmaN0innrbFj_zVjuw4zfxbCOh8fhpoc5D6hkglpEhHQAjyCT0Sjchwp3MB2a7dLlfr58a63X5dD3dRMtin8uGXSos98HpbAb68RaArXcoaRDR7nBnN43IWWjoYxx0ub-dssyR_iXq19rZZD3xfo'
                        },
                        'where_name': 'Office',
                        'name_long': 'Office Camera',
                        'web_url': 'https://home.nest.com/cameras/CjY3bEh5R3dPSVo3Yk1tUVBQVmZZcXM1UFZsYW9VM3J4MHdhblUxOS1RUkJTb0szRHdaMVhhTXcSFmpSZlBmTnRnYVFBbkRPdmIyVEpPM0EaNkVycmw0a3pqMVZ3am15bnpQZlBHLVVtV1hqNmFIWmppY2FUTWdLcl9nY05abEpLTWVRM0ZfQQ?auth=815fOF6Lsj2jLh_-xNglQuf5zt3OAh2M0MaGd9didhborxrTRiDAlKNnPBwmaN0innrbFj_zVjuw4zfxbCOh8fhpoc5D6hkglpEhHQAjyCT0Sjchwp3MB2a7dLlfr58a63X5dD3dRMtin8uGXSos98HpbAb68RaArXcoaRDR7nBnN43IWWjoYxx0ub-dssyR_iXq19rZZD3xfo',
                        'app_url': 'nestmobile://cameras/CjY3bEh5R3dPSVo3Yk1tUVBQVmZZcXM1UFZsYW9VM3J4MHdhblUxOS1RUkJTb0szRHdaMVhhTXcSFmpSZlBmTnRnYVFBbkRPdmIyVEpPM0EaNkVycmw0a3pqMVZ3am15bnpQZlBHLVVtV1hqNmFIWmppY2FUTWdLcl9nY05abEpLTWVRM0ZfQQ?auth=815fOF6Lsj2jLh_-xNglQuf5zt3OAh2M0MaGd9didhborxrTRiDAlKNnPBwmaN0innrbFj_zVjuw4zfxbCOh8fhpoc5D6hkglpEhHQAjyCT0Sjchwp3MB2a7dLlfr58a63X5dD3dRMtin8uGXSos98HpbAb68RaArXcoaRDR7nBnN43IWWjoYxx0ub-dssyR_iXq19rZZD3xfo',
                        'public_share_url': 'https://video.nest.com/live/w4o0ZjxQLX',
                        'snapshot_url': 'https://www.dropcam.com/api/wwn.get_snapshot/CjY3bEh5R3dPSVo3Yk1tUVBQVmZZcXM1UFZsYW9VM3J4MHdhblUxOS1RUkJTb0szRHdaMVhhTXcSFmpSZlBmTnRnYVFBbkRPdmIyVEpPM0EaNkVycmw0a3pqMVZ3am15bnpQZlBHLVVtV1hqNmFIWmppY2FUTWdLcl9nY05abEpLTWVRM0ZfQQ?auth=815fOF6Lsj2jLh_-xNglQuf5zt3OAh2M0MaGd9didhborxrTRiDAlKNnPBwmaN0innrbFj_zVjuw4zfxbCOh8fhpoc5D6hkglpEhHQAjyCT0Sjchwp3MB2a7dLlfr58a63X5dD3dRMtin8uGXSos98HpbAb68RaArXcoaRDR7nBnN43IWWjoYxx0ub-dssyR_iXq19rZZD3xfo'
                    }
                }
            },
            'structures': {
                'T9L9obNI8LxtBghzreo0rj8VHxLowV0WPFpxpqhKygR--PRqEyT1DA': {
                    'name': 'Office1',
                    'country_code': 'US',
                    'postal_code': '35004',
                    'time_zone': 'America/Chicago',
                    'away': 'home',
                    'structure_id': 'T9L9obNI8LxtBghzreo0rj8VHxLowV0WPFpxpqhKygR--PRqEyT1DA',
                    'rhr_enrollment': 'false',
                    'eta_begin': '1970-01-01T00:00:00.000Z',
                }
            },
            'metadata': {
                'access_token': accesstoken,
                'client_version': 2,
                'user_id': 'z.1.1.5F24Y1m5X0WN0q1jnKSV/2RAcleKMzh7ase8Cs6Vpp8='
            }
        }
        return result, 201

    
if __name__ == '__main__':
    api.add_resource(GetFakePincode, '/fakepincode')
    api.add_resource(AccessToken, '/oauth2/access_token')
    api.add_resource(ListCamera, '/')
    
    app.run(port=14253)
