/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:05:04 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import javax.swing.JLayeredPane;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.plot.CumulativeGCSkewAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class CumulativeGCSkewAlgorithm_ESTest extends CumulativeGCSkewAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("K.?zfgN~e");
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      Float float0 = cumulativeGCSkewAlgorithm0.getAverage();
      assertEquals(1.0F, (float)float0, 0.01F);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(float0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      float[] floatArray0 = new float[5];
      // Undeclared exception!
      try { 
        cumulativeGCSkewAlgorithm0.getValues(5, 169, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BioJavaSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      char[] charArray0 = new char[3];
      Short short0 = new Short((short)341);
      assertEquals((short)341, (short)short0);
      assertNotNull(short0);
      
      Integer integer0 = JLayeredPane.MODAL_LAYER;
      assertEquals(200, (int)integer0);
      assertNotNull(integer0);
      
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-604), (-2856), short0, integer0);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000'}, charArray0);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((-604), partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(200, (int)partialSequence0.getPhase());
      assertEquals(3, partialSequence0.getOtherCount());
      assertEquals((short)341, (short)partialSequence0.getStrand());
      assertNotNull(partialSequence0);
      
      Bases bases0 = new Bases(partialSequence0);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000'}, charArray0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((-604), partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(200, (int)partialSequence0.getPhase());
      assertEquals(3, partialSequence0.getOtherCount());
      assertEquals((short)341, (short)partialSequence0.getStrand());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000'}, charArray0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((-604), partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(200, (int)partialSequence0.getPhase());
      assertEquals(3, partialSequence0.getOtherCount());
      assertEquals((short)341, (short)partialSequence0.getStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertArrayEquals(new char[] {'\u0000', '\u0000', '\u0000'}, charArray0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, partialSequence0.getGCount());
      assertEquals(0, partialSequence0.getTCount());
      assertEquals(0, partialSequence0.getCCount());
      assertEquals((-604), partialSequence0.length());
      assertFalse(partialSequence0.isComplement());
      assertEquals(0, partialSequence0.getACount());
      assertEquals(200, (int)partialSequence0.getPhase());
      assertEquals(3, partialSequence0.getOtherCount());
      assertEquals((short)341, (short)partialSequence0.getStrand());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      float[] floatArray0 = new float[9];
      // Undeclared exception!
      try { 
        cumulativeGCSkewAlgorithm0.getValues(0, 341, floatArray0);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("K.?zfgN~e");
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      float[] floatArray0 = new float[5];
      // Undeclared exception!
      try { 
        cumulativeGCSkewAlgorithm0.getValues(4112, 2, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 0 > end: -4110
         //
         verifyException("uk.ac.sanger.artemis.plot.CumulativeGCSkewAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = null;
      try {
        cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("centromere");
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(8, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(10, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertNotNull(emblStreamSequence0);
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(8, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(10, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(8, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(8, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(10, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(8, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(8, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(10, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(8, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(8, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(10, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(8, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      Float float0 = cumulativeGCSkewAlgorithm0.getAverage();
      assertEquals((-1.0F), (float)float0, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(8, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(10, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(10, rawStreamSequence0.length());
      assertEquals(8, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertNotNull(float0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertNotNull(emblStreamSequence0);
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      Float float0 = cumulativeGCSkewAlgorithm0.getAverage();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("K.?zfgN~e");
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      Integer integer0 = cumulativeGCSkewAlgorithm0.getDefaultStepSize(4331);
      assertEquals(433, (int)integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(8, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(9, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, strand0.getDirection());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("3\"ld32Y");
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      Integer integer0 = cumulativeGCSkewAlgorithm0.getDefaultStepSize(5);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertNull(integer0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      Integer integer0 = cumulativeGCSkewAlgorithm0.getDefaultMinWindowSize();
      assertEquals(10, (int)integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      assertNotNull(bioJavaSequence0);
      
      Bases bases0 = new Bases(bioJavaSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      Integer integer0 = cumulativeGCSkewAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5000, (int)integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("3\"ld32Y");
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(cumulativeGCSkewAlgorithm0);
      
      Integer integer0 = cumulativeGCSkewAlgorithm0.getDefaultWindowSize();
      assertEquals(60, (int)integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(7, fastaStreamSequence0.getOtherCount());
      assertEquals(7, fastaStreamSequence0.length());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals("Cumulative GC Skew, (G-C)/(G+C)", cumulativeGCSkewAlgorithm0.getAlgorithmName());
      assertFalse(cumulativeGCSkewAlgorithm0.isRevCompDisplay());
      assertEquals("gc_skew", cumulativeGCSkewAlgorithm0.getAlgorithmShortName());
      assertFalse(cumulativeGCSkewAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, cumulativeGCSkewAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, cumulativeGCSkewAlgorithm0.getValueCount());
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, cumulativeGCSkewAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("3\"ld32Y");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      float[] floatArray0 = new float[7];
      cumulativeGCSkewAlgorithm0.getValues(0, 1637, floatArray0);
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("K.?zfgN~e");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      float[] floatArray0 = new float[5];
      // Undeclared exception!
      cumulativeGCSkewAlgorithm0.getValues(372, 95401, floatArray0);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("3\"ld32Y");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      float[] floatArray0 = new float[7];
      cumulativeGCSkewAlgorithm0.getValues(0, (-5), floatArray0);
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("centromere");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      Float float0 = cumulativeGCSkewAlgorithm0.getMaximumInternal();
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
      assertEquals(1.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("E1J*nMUi");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      int int0 = cumulativeGCSkewAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertTrue(cumulativeGCSkewAlgorithm0.scalingFlag());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("centromere");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      CumulativeGCSkewAlgorithm cumulativeGCSkewAlgorithm0 = new CumulativeGCSkewAlgorithm(strand0);
      cumulativeGCSkewAlgorithm0.getMinimumInternal();
  }
}
