# TFBS module for TFBS::PatternGen::AnnSpec::Motif
#
# Copyright Boris Lenhard and Wynand Alkema
# 
# You may distribute this module under the same terms as perl itself
#

# POD


# POD

=head1 NAME

TFBS::PatternGen::AnnSpec::Motif - class for unprocessed motifs and associated 
numerical scores created by the Gibbs program


=head1 SYNOPSIS

=head1 DESCRIPTION

TFBS::PatternGen::AnnSpec::Motif is used to store and manipulate unprocessed 
motifs and associated numerical scores created by the AnnSpec program. You do not 
normally want to create a TFBS::PatternGen::AnnSpec::Motif yourself. They are created
by running TFBS::PatternGen::AnnSpec 

=head1 FEEDBACK

Please send bug reports and other comments to the author.

=head1 AUTHOR - Boris Lenhard and Wynand Alkema

Boris Lenhard E<lt>Boris.Lenhard@cgb.ki.seE<gt>
Wynand Alkema E<lt>Wynand.Alkema@cgb.ki.seE<gt>

=head1 APPENDIX

The rest of the documentation details each of the object
methods. Internal methods are preceded with an underscore.

=cut



# the code begins here:

package TFBS::PatternGen::AnnSpec::Motif;
use vars qw(@ISA);
use strict;

use TFBS::Matrix::PFM;
use TFBS::PatternGen::Motif::Matrix;
@ISA = qw(TFBS::PatternGen::Motif::Matrix);







