# base 和 runtime 介绍

在玲珑应用打包体系中，base 提供基础运行环境，runtime 提供应用框架支持，两者采用层级依赖关系。正确选型可确保应用跨发行版的兼容性，建议遵循以下选型原则：

    ‌base 优先原则‌：先选择应用已适配的发行版对应的base
    ‌runtime 继承原则‌：runtime必须和base保持兼容

本文档将详细介绍 base 和 runtime ，以帮助开发者选择合适的 base 和 runtime。

_base 和 runtime 版本号遵循“主版本.次版本.修订版本.打包版本”的规范，使用时只需填写前三位版本即可_

## base 介绍

玲珑的 base 提供最基础的运行环境，包含操作系统核心组件（如 glibc、bash 等基础工具链）‌
作为容器化的"最小系统镜像"，确保应用能在不同发行版上保持一致的底层依赖。base 通常由玲珑官方维护，开发者可直接引用而无需担心应用运行在不同发行版上的兼容性问题。

推荐使用以下稳定版本，未在文档中列出的 base 一般是实验性质的版本，不建议选用。更详细的信息见 [base 列表](#base-列表)

<table>
    <thead>
        <td>base</td>
        <td>仓库</td>
        <td>状态</td>
    </thead>
    <tbody>
        <tr>
            <td>org.deepin.base/25.2.0</td>
            <td>deepin 25</td>
            <td>测试阶段</td>
        </tr>
        <tr>
            <td>org.deepin.base/23.1.0</td>
            <td>deepin 23</td>
            <td>维护阶段</td>
        </tr>
        <tr>
            <td>org.deepin.foundation/20.0.0</td>
            <td>uos 20</td>
            <td>停止支持</td>
        </tr>
    </tbody>   
</table>

## runtime 介绍

玲珑的 runtime 提供应用所需的特定运行环境（如 DTK/Wine/GNOME 等框架库），开发者可以根据应用需求选择合适的 runtime ，玲珑官方也提供了多种预编译好的 runtime 镜像供开发者选择。目前应用只能选择一个 runtime 使用，所以 runtime 可能会包含多个环境，例如 DTK 的 runtime 包含 QT 框架，Wine 的 runtime 包含 DTK 框架。_应用也可以不使用 runtime_

官方维护的稳定 runtime 如下，未在文档中列出的 runtime 一般是实验性质的版本，不建议选用。更详细的信息见 [runtime 列表](#runtime-列表)

<table>
    <thead>
        <td>runtime</td>
        <td>base</td>
        <td>介绍</td>
    </thead>
    <tbody>
        <tr>
            <td>org.deepin.runtime.dtk/25.2.0</td>
            <td>org.deepin.base/25.2.0</td>
            <td>包含QT6和DTK6</td>
        </tr>
        <tr>
            <td>org.deepin.runtime.webengine/25.2.0</td>
            <td>org.deepin.base/25.2.0</td>
            <td>包含QT6、QT6 webengine、DTK6</td>
        </tr>
        <tr>
            <td>org.deepin.Runtime/23.1.0</td>
            <td>org.deepin.base/23.1.0</td>
            <td>包含QT5和DTK5</td>
        </tr>
        <tr>
            <td>org.deepin.Runtime/20.0.0</td>
            <td>org.deepin.foundation/20.0.0</td>
            <td>包含QT5和DTK5</td>
        </tr>
    </tbody>   
</table>

## base 列表

#### org.deepin.foundation/20.0.0

使用 uos 1070 仓库制作的 base，支持 x86, arm64, loongarch64 三个架构。

_在容器中执行 `cat /var/lib/dpkg/status|grep "^Package: "|sort|awk '{print $2}'` 查看包列表_

```
adduser adwaita-icon-theme apt base-files base-passwd bash bsdutils ca-certificates coreutils dash dbus dbus-user-session dconf-gsettings-backend dconf-service debconf debianutils deepin-desktop-base deepin-elf-verify deepin-keyring diffutils distro-info-data dlnfs dmsetup dpkg e2fsprogs eject fdisk findutils fontconfig fontconfig-config fonts-dejavu-core fonts-noto fonts-noto-core fonts-symbola fuse3 gcc-8-base glib-networking glib-networking-common glib-networking-services gpgv grep gsettings-desktop-schemas gtk-update-icon-cache gzip hicolor-icon-theme hostname init-system-helpers libacl1 libapparmor1 libapt-pkg5.0 libargon2-1 libasound2 libasound2-data libatk1.0-0 libatk1.0-data libatk-bridge2.0-0 libatomic1 libatspi2.0-0 libattr1 libaudit1 libaudit-common libavahi-client3 libavahi-common3 libavahi-common-data libblkid1 libbsd0 libbz2-1.0 libc6 libc6-dev libcairo2 libcairo-gobject2 libcap2 libcap-ng0 libc-bin libc-dev-bin libcolord2 libcom-err2 libcroco3 libcryptsetup12 libcups2 libcupsimage2 libdatrie1 libdb5.3 libdbus-1-3 libdconf1 libdebconfclient0 libdevmapper1.02.1 libdrm2 libdrm-amdgpu1 libdrm-common libdrm-intel1 libdrm-nouveau2 libdrm-radeon1 libedit2 libegl1 libegl1-mesa libegl-mesa0 libelf1 libepoxy0 libexpat1 libext2fs2 libfdisk1 libffi6 libfontconfig1 libfreetype6 libfribidi0 libfuse3-3 libgbm1 libgcc1 libgcrypt20 libgdk-pixbuf2.0-0 libgdk-pixbuf2.0-common libgl1 libgl1-mesa-dri libglapi-mesa libglib2.0-0 libglu1-mesa libglvnd0 libglx0 libglx-mesa0 libgmp10 libgnutls30 libgomp1 libgpg-error0 libgraphite2-3 libgssapi-krb5-2 libgtk2.0-0 libgtk2.0-common libgtk-3-0 libgtk-3-common libharfbuzz0b libhogweed4 libice6 libicu63 libidn11 libidn2-0 libip4tc0 libjbig0 libjpeg62-turbo libjson-c3 libjson-glib-1.0-0 libjson-glib-1.0-common libk5crypto3 libkeyutils1 libkmod2 libkrb5-3 libkrb5support0 liblcms2-2 libllvm7 liblocale-gettext-perl liblz4-1 liblzma5 libmagic1 libmagic-mgc libmount1 libncursesw6 libnettle6 libnspr4 libnss3 libopengl0 libp11-kit0 libpam0g libpam-deepin-security libpam-modules libpam-modules-bin libpam-runtime libpam-systemd libpango-1.0-0 libpango1.0-0 libpangocairo-1.0-0 libpangoft2-1.0-0 libpangox-1.0-0 libpangoxft-1.0-0 libpciaccess0 libpcre16-3 libpcre3 libpcre32-3 libpcsclite1 libpixman-1-0 libpng16-16 libproxy1v5 libpsl5 librest-0.7-0 librsvg2-2 librsvg2-common libseccomp2 libselinux1 libsemanage1 libsemanage-common libsensors5 libsensors-config libsepol1 libsm6 libsmartcols1 libsoup2.4-1 libsoup-gnome2.4-1 libsqlite3-0 libss2 libssl1.1 libstdc++6 libsystemd0 libtasn1-6 libtext-charwidth-perl libtext-iconv-perl libtext-wrapi18n-perl libthai0 libthai-data libtiff5 libtinfo6 libudev1 libunistring2 libuuid1 libwayland-client0 libwayland-cursor0 libwayland-egl1 libwayland-egl1-mesa libwayland-server0 libwebp6 libx11-6 libx11-data libx11-xcb1 libxau6 libxcb1 libxcb-composite0 libxcb-damage0 libxcb-doc libxcb-dpms0 libxcb-dri2-0 libxcb-dri3-0 libxcb-glx0 libxcb-present0 libxcb-randr0 libxcb-record0 libxcb-render0 libxcb-res0 libxcb-screensaver0 libxcb-shape0 libxcb-shm0 libxcb-sync1 libxcb-xf86dri0 libxcb-xfixes0 libxcb-xinerama0 libxcb-xinput0 libxcb-xkb1 libxcb-xtest0 libxcb-xv0 libxcb-xvmc0 libxcomposite1 libxcursor1 libxdamage1 libxdmcp6 libxext6 libxfixes3 libxft2 libxi6 libxinerama1 libxkbcommon0 libxml2 libxrandr2 libxrender1 libxshmfence1 libxss1 libxtst6 libxxf86vm1 libzstd1 linux-libc-dev login lsb-base mawk mime-support mount ncurses-base ncurses-bin openssl passwd perl-base sed sensible-utils shared-mime-info sudo systemd systemd-sysv sysvinit-utils tar tzdata ucf util-linux uuid-runtime x11-common xkb-data zlib1g
```

#### org.deepin.foundation/23.0.0

使用 deepin 23 beta 仓库制作的 base，支持 x86 架构。

_在容器中执行 `cat /var/lib/dpkg/status|grep "^Package: "|sort|awk '{print $2}'` 查看包列表_

```txt
adduser adwaita-icon-theme apt at-spi2-common base-files base-passwd bash binutils-common bsdutils ca-certificates coreutils dash dbus dbus-bin dbus-daemon dbus-session-bus-common dbus-system-bus-common dbus-user-session dconf-gsettings-backend dconf-service debconf debianutils deepin-desktop-base deepin-keyring diffutils distro-info-data dmsetup dpkg e2fsprogs eject findutils fontconfig fontconfig-config fonts-noto fonts-noto-core fonts-symbola gcc-13-base glib-networking glib-networking-common glib-networking-services gpgv grep gsettings-desktop-schemas gtk-update-icon-cache gzip hicolor-icon-theme hostname init-system-helpers libacl1 libapparmor1 libapt-pkg6.0 libarchive13 libargon2-1 libasan8 libasm1 libasound2 libasound2-data libatk1.0-0 libatk-bridge2.0-0 libatomic1 libatspi2.0-0 libattr1 libaudit1 libaudit-common libavahi-client3 libavahi-common3 libavahi-common-data libbabeltrace1 libbinutils libblkid1 libboost-regex1.74.0 libbrotli1 libbsd0 libbz2-1.0 libc6 libc6-dev libcairo2 libcairo-gobject2 libcairo-script-interpreter2 libcap2 libcap-ng0 libc-bin libcc1-0 libc-dev-bin libcolord2 libcom-err2 libcrypt1 libcrypt-dev libcryptsetup12 libctf0 libctf-nobfd0 libcups2 libcupsimage2 libcurl3-gnutls libcurl4 libdatrie1 libdb5.3 libdbus-1-3 libdconf1 libdebconfclient0 libdebuginfod1 libdebuginfod-common libdeflate0 libdevmapper1.02.1 libdpkg-perl libdrm2 libdrm-amdgpu1 libdrm-common libdrm-intel1 libdrm-nouveau2 libdrm-radeon1 libdw1 libedit2 libegl1 libegl-mesa0 libelf1 libepoxy0 libevent-2.1-7 libexpat1 libext2fs2 libfdisk1 libffi8 libfontconfig1 libfreetype6 libfribidi0 libgbm1 libgcc-s1 libgcrypt20 libgdbm6 libgdbm-compat4 libgdk-pixbuf-2.0-0 libgdk-pixbuf2.0-0 libgdk-pixbuf2.0-common libgdk-pixbuf-xlib-2.0-0 libgirepository-1.0-1 libgl1 libgl1-mesa-dri libglapi-mesa libgles1 libgles2 libglib2.0-0 libglib2.0-data libglu1-mesa libglvnd0 libglx0 libglx-mesa0 libgmp10 libgmpxx4ldbl libgnutls30 libgnutls-dane0 libgnutls-openssl27 libgnutlsxx30 libgomp1 libgpg-error0 libgprofng0 libgraphite2-3 libgssapi-krb5-2 libgtk2.0-0 libgtk2.0-common libgtk-3-0 libgtk-3-common libharfbuzz0b libharfbuzz-cairo0 libharfbuzz-gobject0 libharfbuzz-icu0 libharfbuzz-subset0 libhogweed6 libhwasan0 libice6 libicu73 libidn2-0 libip4tc2 libipt2 libisl23 libitm1 libjansson4 libjbig0 libjpeg62-turbo libjson-c5 libjsoncpp24 libk5crypto3 libkeyutils1 libkmod2 libkrb5-3 libkrb5support0 liblcms2-2 libldap-2.5-0 liblerc4 libllvm16 liblocale-gettext-perl liblsan0 liblz4-1 liblzma5 liblzo2-2 libmagic1 libmagic-mgc libmd0 libmount1 libmpc3 libmpfr6 libncursesw6 libnettle8 libnghttp2-14 libnsl2 libnsl-dev libnspr4 libnss3 libopengl0 libp11-kit0 libpam0g libpam-modules libpam-modules-bin libpam-runtime libpam-systemd libpango-1.0-0 libpango1.0-0 libpangocairo-1.0-0 libpangoft2-1.0-0 libpangoxft-1.0-0 libpciaccess0 libpcre16-3 libpcre2-16-0 libpcre2-32-0 libpcre2-8-0 libpcre2-posix3 libpcre3 libpcre32-3 libpcrecpp0v5 libperl5.36 libpixman-1-0 libpkgconf3 libpng16-16 libproc2-0 libproxy1v5 libpsl5 libpython3.11 libpython3.11-minimal libpython3.11-stdlib libpython3-stdlib libquadmath0 libreadline8 librhash0 librsvg2-2 librsvg2-common librtmp1 libsasl2-2 libsasl2-modules-db libseccomp2 libselinux1 libsemanage2 libsemanage-common libsensors5 libsensors-config libsepol2 libsframe1 libsharpyuv0 libsm6 libsmartcols1 libsource-highlight4v5 libsource-highlight-common libsqlite3-0 libss2 libssh2-1 libssl3 libstdc++6 libsystemd0 libsystemd-shared libtasn1-6 libtext-charwidth-perl libtext-iconv-perl libtext-wrapi18n-perl libthai0 libthai-data libtiff6 libtiffxx6 libtinfo6 libtirpc3 libtirpc-common libtirpc-dev libtsan2 libubsan1 libudev1 libunbound8 libunistring2 libuuid1 libuv1 libvulkan1 libwayland-client0 libwayland-cursor0 libwayland-egl1 libwayland-server0 libwebp7 libwebpdecoder3 libwebpdemux2 libwebpmux3 libx11-6 libx11-data libx11-xcb1 libxau6 libxcb1 libxcb-composite0 libxcb-damage0 libxcb-doc libxcb-dpms0 libxcb-dri2-0 libxcb-dri3-0 libxcb-glx0 libxcb-present0 libxcb-randr0 libxcb-record0 libxcb-render0 libxcb-res0 libxcb-screensaver0 libxcb-shape0 libxcb-shm0 libxcb-sync1 libxcb-xf86dri0 libxcb-xfixes0 libxcb-xinerama0 libxcb-xinput0 libxcb-xkb1 libxcb-xtest0 libxcb-xv0 libxcb-xvmc0 libxcomposite1 libxcursor1 libxdamage1 libxdmcp6 libxext6 libxfixes3 libxft2 libxi6 libxinerama1 libxkbcommon0 libxml2 libxrandr2 libxrender1 libxshmfence1 libxss1 libxtst6 libxxf86vm1 libxxhash0 libz3-4 libzstd1 linux-libc-dev login logsave mailcap mawk media-types mime-support mount ncurses-base ncurses-bin openssl passwd perl perl-base perl-modules-5.36 readline-common rpcsvc-proto sed sensible-utils shared-mime-info systemd systemd-dev systemd-sysv sysvinit-utils tar tzdata ucf usr-is-merged util-linux uuid-runtime x11-common xkb-data zlib1g
```

#### org.deepin.base/23.1.0

基于 deepin v23 release 仓库制作的 base，支持 x86 架构。

_在容器中执行 `cat /var/lib/dpkg/status|grep "^Package: "|sort|awk '{print $2}'` 查看包列表_

```txt
acl adduser adwaita-icon-theme apt at-spi2-common base-files base-passwd bash bc binutils binutils-common binutils-x86-64-linux-gnu bluez bluez-obexd bsdextrautils bsdutils busybox bzip2 ca-certificates coreutils cpio cryptsetup cryptsetup-bin cryptsetup-initramfs cups cups-bsd cups-client cups-common cups-core-drivers cups-daemon cups-filters cups-filters-core-drivers cups-ipp-utils cups-ppdc cups-server-common curl dash dbus dbus-bin dbus-daemon dbus-session-bus-common dbus-system-bus-common dbus-x11 dconf-gsettings-backend dconf-service debconf debianutils deepin-keyring dictionaries-common diffutils dirmngr dmeventd dmsetup dpkg e2fsprogs eject emacsen-common fcitx5-frontend-gtk2 fcitx5-frontend-gtk3 fdisk file findutils fontconfig fontconfig-config fonts-dejavu-core fonts-urw-base35 gawk gcc-13-base gettext-base ghostscript gir1.2-atk-1.0 gir1.2-freedesktop gir1.2-gdkpixbuf-2.0 gir1.2-glib-2.0 gir1.2-harfbuzz-0.0 gir1.2-pango-1.0 glib-networking glib-networking-common glib-networking-services gnupg gnupg-l10n gnupg-utils gnutls-bin gpg gpg-agent gpgconf gpgsm gpgv gpg-wks-client grep gsettings-desktop-schemas gtk-update-icon-cache gzip hicolor-icon-theme hostname initramfs-tools initramfs-tools-core init-system-helpers iso-codes kbd klibc-utils kmod libacl1 libaio1 libaom3 libapparmor1 libapt-pkg6.0 libarchive13 libargon2-1 libasound2 libasound2-data libasound2-plugins libassuan0 libasyncns0 libatk1.0-0 libatk-bridge2.0-0 libatspi2.0-0 libattr1 libaudit1 libaudit-common libavahi-client3 libavahi-common3 libavahi-common-data libavcodec60 libavutil58 libbinutils libblkid1 libbluetooth3 libbrotli1 libbsd0 libbz2-1.0 libc6 libc6-dev libcairo2 libcairo-gobject2 libcap2 libcap2-bin libcap-ng0 libc-bin libcbor0.8 libc-dev-bin libc-l10n libcloudproviders0 libcodec2-0.9 libcolord2 libcom-err2 libconfig++9v5 libcrypt1 libcrypt-dev libcryptsetup12 libctf0 libctf-nobfd0 libcups2 libcupsfilters1 libcupsimage2 libcurl3-gnutls libcurl4 libdaemon0 libdatrie1 libdav1d6 libdb5.3 libdbus-1-3 libdconf1 libdebconfclient0 libdecor-0-0 libdeflate0 libdevmapper1.02.1 libdevmapper-event1.02.1 libdrm2 libdrm-amdgpu1 libdrm-common libdrm-intel1 libdrm-nouveau2 libdrm-radeon1 libdw1 libedit2 libegl1 libegl-mesa0 libelf1 libencode-locale-perl libepoxy0 libevent-2.1-7 libexif12 libexpat1 libext2fs2 libfcitx5gclient2 libfdisk1 libffado2 libffi8 libfftw3-single3 libfido2-1 libfile-listing-perl libflac8 libfontconfig1 libfontembed1 libfontenc1 libfreeaptx0 libfreetype6 libfribidi0 libgbm1 libgcc-s1 libgcrypt20 libgdbm6 libgdbm-compat4 libgdk-pixbuf-2.0-0 libgdk-pixbuf2.0-common libgdk-pixbuf-xlib-2.0-0 libgl1 libgl1-mesa-dri libglapi-mesa libgle3 libgles2 libglib2.0-0 libglib2.0-bin libglib2.0-data libglibmm-2.4-1v5 libglu1-mesa libglvnd0 libglx0 libglx-mesa0 libgmp10 libgnutls30 libgnutls-dane0 libgomp1 libgpg-error0 libgprofng0 libgraphite2-3 libgs9 libgs9-common libgsm1 libgssapi-krb5-2 libgstreamer1.0-0 libgstreamer-plugins-base1.0-0 libgtk2.0-0 libgtk2.0-common libgtk-3-0 libgtk-3-common libharfbuzz0b libharfbuzz-gobject0 libharfbuzz-icu0 libharfbuzz-subset0 libhogweed6 libhtml-parser-perl libhtml-tagset-perl libhtml-tree-perl libhttp-cookies-perl libhttp-date-perl libhttp-message-perl libhttp-negotiate-perl libhwy1 libical3 libice6 libicu74 libidn12 libidn2-0 libiec61883-0 libijs-0.35 libio-html-perl libio-socket-ssl-perl libjack-jackd2-0 libjansson4 libjbig0 libjbig2dec0 libjpeg62-turbo libjpeg-turbo-progs libjson-c5 libjxl0.7 libk5crypto3 libkeyutils1 libklibc libkmod2 libkrb5-3 libkrb5support0 libksba8 liblc3-1 liblcms2-2 libldacbt-abr2 libldacbt-enc2 libldap-2.5-0 liblerc4 liblilv-0-0 libllvm17 libltdl7 liblvm2cmd2.03 liblwp-mediatypes-perl liblwp-protocol-https-perl liblz4-1 liblzma5 libmagic1 libmagic-mgc libmd0 libminizip1 libmnl0 libmount1 libmp3lame0 libmpfr6 libmysofa1 libnatspec0 libncurses6 libncursesw6 libnet-http-perl libnetpbm10 libnet-ssleay-perl libnettle8 libnghttp2-14 libnpth0 libnsl2 libnsl-dev libnspr4 libnss3 libnss-myhostname libnuma1 libogg0 libopengl0 libopenjp2-7 libopus0 liborc-0.4-0 libp11-kit0 libpam0g libpam-modules libpam-modules-bin libpam-runtime libpango-1.0-0 libpangocairo-1.0-0 libpangoft2-1.0-0 libpangoxft-1.0-0 libpaper1 libpciaccess0 libpcre2-16-0 libpcre2-8-0 libperl5.36 libpipewire-0.3-0 libpipewire-0.3-modules libpixman-1-0 libpng16-16 libpoppler118 libpoppler-cpp0v5 libpopt0 libproc2-0 libproxy1v5 libpsl5 libpulse0 libpulsedsp libpulse-mainloop-glib0 libpython3.11-minimal libpython3.11-stdlib libpython3.12 libpython3.12-minimal libpython3.12-stdlib libpython3-stdlib libqpdf29 librav1e0 libraw1394-11 libreadline8 libroc0.3 librsvg2-2 librtmp1 libsamplerate0 libsasl2-2 libsasl2-modules-db libsbc1 libseccomp2 libselinux1 libsemanage2 libsemanage-common libsensors5 libsensors-config libsepol2 libserd-0-0 libsframe1 libsharpyuv0 libshine3 libsigc++-2.0-0v5 libsigsegv2 libsm6 libsmartcols1 libsnappy1v5 libsndfile1 libsord-0-0 libsoxr0 libspa-0.2-bluetooth libspa-0.2-modules libspeex1 libspeexdsp1 libsqlite3-0 libsratom-0-0 libss2 libssh2-1 libssl3 libstdc++6 libsvtav1enc1d1 libswresample4 libsystemd0 libsystemd-shared libtasn1-6 libtdb1 libtext-iconv-perl libthai0 libthai-data libtheora0 libtiff6 libtimedate-perl libtinfo6 libtirpc3 libtirpc-common libtirpc-dev libtry-tiny-perl libtss2-esys-3.0.2-0 libtss2-mu0 libtss2-sys1 libtss2-tcti-cmd0 libtss2-tcti-device0 libtss2-tctildr0 libtss2-tcti-libtpms0 libtss2-tcti-mssim0 libtss2-tcti-spi-helper0 libtss2-tcti-swtpm0 libturbojpeg0 libtwolame0 libudev1 libunbound8 libunistring2 libunwind8 liburi-perl libusb-1.0-0 libuuid1 libuv1 libv4l-0 libv4lconvert0 libva2 libva-drm2 libva-x11-2 libvdpau1 libvorbis0a libvorbisenc2 libvpl2 libvpx7 libvulkan1 libwayland-client0 libwayland-cursor0 libwayland-egl1 libwayland-server0 libwebp7 libwebpdemux2 libwebpmux3 libwebrtc-audio-processing1 libwrap0 libwww-perl libwww-robotrules-perl libx11-6 libx11-data libx11-xcb1 libx264-160 libx265-199 libxau6 libxaw7 libxcb1 libxcb-composite0 libxcb-cursor0 libxcb-damage0 libxcb-dri2-0 libxcb-dri3-0 libxcb-ewmh2 libxcb-glx0 libxcb-icccm4 libxcb-image0 libxcb-keysyms1 libxcb-present0 libxcb-randr0 libxcb-record0 libxcb-render0 libxcb-render-util0 libxcb-res0 libxcb-shape0 libxcb-shm0 libxcb-sync1 libxcb-util1 libxcb-xfixes0 libxcb-xinerama0 libxcb-xinput0 libxcb-xkb1 libxcb-xtest0 libxcomposite1 libxcursor1 libxdamage1 libxdmcp6 libxext6 libxfixes3 libxft2 libxi6 libxinerama1 libxkbcommon0 libxkbcommon-x11-0 libxkbfile1 libxml2 libxml++2.6-2v5 libxmu6 libxpm4 libxrandr2 libxrender1 libxshmfence1 libxt6 libxtst6 libxv1 libxvidcore4 libxxf86vm1 libxxhash0 libz3-4 libzstd1 libzvbi0 libzvbi-common linux-base linux-libc-dev locales login logsave lvm2 mawk media-types mesa-vdpau-drivers mesa-vulkan-drivers ncurses-base ncurses-bin netbase netpbm ocl-icd-libopencl1 openssl p11-kit p11-kit-modules passwd perl perl-base perl-modules-5.36 perl-openssl-defaults pinentry-curses pipewire pipewire-bin pipewire-pulse poppler-data poppler-utils procps pulseaudio pulseaudio-module-bluetooth pulseaudio-utils python3 python3.11 python3.11-minimal python3.12 python3.12-minimal python3-minimal readline-common rfkill rpcsvc-proto sed sensible-utils shared-mime-info sqlite3 ssl-cert systemd-dev systemd-standalone-sysusers sysvinit-utils tar tpm-udev tzdata tzdata-legacy ucf udev unzip usr-is-merged util-linux x11-common x11-xkb-utils xdg-user-dirs xfonts-encodings xfonts-utils xkb-data xscreensaver-data xscreensaver-data-extra xscreensaver-gl xscreensaver-gl-extra xz-utils zlib1g zstd
```

#### org.deepin.base/25.2.0

基于 deepin 25 beta 仓库制作的 base，支持 x86, arm64, loong64 架构。

_在容器中执行 `cat /var/lib/dpkg/status|grep "^Package: "|sort|awk '{print $2}'` 查看包列表_

```txt
acl adduser at-spi2-common base-files base-passwd bash bc binutils binutils-common binutils-x86-64-linux-gnu bluez bluez-obexd bsdextrautils bsdutils busybox bzip2 ca-certificates coreutils cpio cryptsetup cryptsetup-bin cryptsetup-initramfs cups cups-bsd cups-client cups-common cups-core-drivers cups-daemon cups-filters cups-filters-core-drivers cups-ipp-utils cups-ppdc cups-server-common curl dash dbus dbus-bin dbus-daemon dbus-session-bus-common dbus-system-bus-common dbus-user-session dbus-x11 dconf-gsettings-backend dconf-service debconf debianutils deepin-desktop-base deepin-keyring dictionaries-common diffutils dirmngr distro-info-data dmeventd dmsetup dpkg dracut-install e2fsprogs eject emacsen-common fdisk file findutils fontconfig fontconfig-config fonts-dejavu-core fonts-noto fonts-noto-core fonts-symbola fonts-urw-base35 gawk gcc-13-base gdbserver gettext-base ghostscript gir1.2-atk-1.0 gir1.2-freedesktop gir1.2-gdkpixbuf-2.0 gir1.2-glib-2.0 gir1.2-harfbuzz-0.0 gir1.2-pango-1.0 glib-networking glib-networking-common glib-networking-services gnupg gnupg-l10n gnutls-bin gpg gpg-agent gpgconf gpgsm gpgv grep gsettings-desktop-schemas gzip hicolor-icon-theme hostname initramfs-tools initramfs-tools-core init-system-helpers iso-codes klibc-utils kmod libabsl20220623 libacl1 libaio1 libaom3 libapparmor1 libarchive13 libasound2 libasound2-data libasound2-plugins libassuan0 libasyncns0 libatk1.0-0 libatk-bridge2.0-0 libatspi2.0-0 libattr1 libaudit1 libaudit-common libavahi-client3 libavahi-common3 libavahi-common-data libavcodec60 libavutil58 libbinutils libblkid1 libbluetooth3 libbrotli1 libbsd0 libbz2-1.0 libc6 libc6-dev libcairo2 libcairo-gobject2 libcap2 libcap2-bin libcap-ng0 libc-bin libcbor0.8 libc-dev-bin libc-l10n libcodec2-0.9 libcom-err2 libconfig++9v5 libcrypt1 libcrypt-dev libcryptsetup12 libctf0 libctf-nobfd0 libcups2 libcupsfilters1 libcupsimage2 libcurl3-gnutls libcurl4 libdaemon0 libdatrie1 libdav1d6 libdb5.3 libdbus-1-3 libdconf1 libdebconfclient0 libdecor-0-0 libdeflate0 libdevmapper1.02.1 libdevmapper-event1.02.1 libdrm2 libdrm-amdgpu1 libdrm-common libdrm-intel1 libdrm-nouveau2 libdrm-radeon1 libdw1 libedit2 libegl1 libegl-mesa0 libelf1 libencode-locale-perl libepoxy0 libevent-2.1-7 libexif12 libexpat1 libext2fs2 libfdisk1 libffado2 libffi8 libfftw3-single3 libfido2-1 libfile-listing-perl libflac8 libfontconfig1 libfontembed1 libfontenc1 libfreeaptx0 libfreetype6 libfribidi0 libgbm1 libgcc-s1 libgcrypt20 libgdbm6 libgdbm-compat4 libgdk-pixbuf-2.0-0 libgdk-pixbuf2.0-common libgdk-pixbuf-xlib-2.0-0 libgl1 libgl1-mesa-dri libglapi-mesa libgle3 libgles2 libglib2.0-0 libglib2.0-bin libglib2.0-data libglibmm-2.4-1v5 libglu1-mesa libglvnd0 libglx0 libglx-mesa0 libgmp10 libgnutls30 libgnutls-dane0 libgomp1 libgpg-error0 libgprofng0 libgraphite2-3 libgs10 libgs10-common libgs-common libgsm1 libgssapi-krb5-2 libgstreamer1.0-0 libgstreamer-plugins-base1.0-0 libharfbuzz0b libharfbuzz-gobject0 libharfbuzz-icu0 libharfbuzz-subset0 libhogweed6 libhtml-parser-perl libhtml-tagset-perl libhtml-tree-perl libhttp-cookies-perl libhttp-date-perl libhttp-message-perl libhttp-negotiate-perl libhwy1 libical3 libice6 libicu74 libidn12 libidn2-0 libiec61883-0 libijs-0.35 libio-html-perl libio-socket-ssl-perl libjack-jackd2-0 libjansson4 libjbig0 libjbig2dec0 libjpeg62-turbo libjpeg-turbo-progs libjson-c5 libjxl0.7 libk5crypto3 libkeyutils1 libklibc libkmod2 libkrb5-3 libkrb5support0 libksba8 liblc3-1 liblcms2-2 libldacbt-abr2 libldacbt-enc2 libldap-2.5-0 liblerc4 liblilv-0-0 libllvm19 libltdl7 liblvm2cmd2.03 liblwp-mediatypes-perl liblwp-protocol-https-perl liblz4-1 liblzma5 libmagic1 libmagic-mgc libmd0 libminizip1 libmnl0 libmount1 libmp3lame0 libmpfr6 libmysofa1 libnatspec0 libncurses6 libncursesw6 libnet-http-perl libnetpbm11 libnet-ssleay-perl libnettle8 libnghttp2-14 libnghttp3-9 libngtcp2-16 libngtcp2-crypto-gnutls8 libnpth0 libnsl2 libnsl-dev libnspr4 libnss3 libnss-myhostname libnuma1 libogg0 libopengl0 libopenjp2-7 libopus0 liborc-0.4-0 libp11-kit0 libpam0g libpam-modules libpam-modules-bin libpam-runtime libpam-systemd libpango-1.0-0 libpangocairo-1.0-0 libpangoft2-1.0-0 libpangoxft-1.0-0 libpaper1 libpciaccess0 libpcre2-16-0 libpcre2-8-0 libperl5.36 libpipewire-0.3-0 libpipewire-0.3-modules libpixman-1-0 libpng16-16 libpoppler126 libpoppler-cpp0v5 libpopt0 libproc2-0 libproc2-1 libproxy1v5 libpsl5 libpulse0 libpulsedsp libpulse-mainloop-glib0 libpython3.12 libpython3.12-minimal libpython3.12-stdlib libpython3-stdlib libqpdf29 librav1e0 libraw1394-11 libreadline8 libroc0.3 librsvg2-2 librtmp1 libsamplerate0 libsasl2-2 libsasl2-modules-db libsbc1 libseccomp2 libselinux1 libsemanage2 libsemanage-common libsensors5 libsensors-config libsepol2 libserd-0-0 libsframe1 libsharpyuv0 libshine3 libsigc++-2.0-0v5 libsigsegv2 libsm6 libsmartcols1 libsnappy1v5 libsndfile1 libsord-0-0 libsoxr0 libspa-0.2-bluetooth libspa-0.2-modules libspeex1 libspeexdsp1 libsqlite3-0 libsratom-0-0 libss2 libssh2-1 libssl3 libstdc++6 libsvtav1enc1d1 libswresample4 libsystemd0 libsystemd-shared libtasn1-6 libtdb1 libtext-iconv-perl libthai0 libthai-data libtheora0 libtiff6 libtimedate-perl libtinfo6 libtirpc3 libtirpc-common libtirpc-dev libtry-tiny-perl libtss2-esys-3.0.2-0 libtss2-mu0 libtss2-sys1 libtss2-tcti-cmd0 libtss2-tcti-device0 libtss2-tctildr0 libtss2-tcti-libtpms0 libtss2-tcti-mssim0 libtss2-tcti-spi-helper0 libtss2-tcti-swtpm0 libturbojpeg0 libtwolame0 libudev1 libunbound8 libunistring2 libunwind8 liburi-perl libusb-1.0-0 libuuid1 libuv1 libv4l-0 libv4lconvert0 libva2 libva-drm2 libva-x11-2 libvdpau1 libvorbis0a libvorbisenc2 libvpl2 libvpx7 libvulkan1 libwayland-client0 libwayland-cursor0 libwayland-egl1 libwayland-server0 libwebp7 libwebpdemux2 libwebpmux3 libwebrtc-audio-processing1 libwebrtc-audio-processing-1-3 libwrap0 libwww-perl libwww-robotrules-perl libx11-6 libx11-data libx11-xcb1 libx264-160 libx265-199 libxau6 libxaw7 libxcb1 libxcb-composite0 libxcb-cursor0 libxcb-damage0 libxcb-dri2-0 libxcb-dri3-0 libxcb-ewmh2 libxcb-glx0 libxcb-icccm4 libxcb-image0 libxcb-keysyms1 libxcb-present0 libxcb-randr0 libxcb-record0 libxcb-render0 libxcb-render-util0 libxcb-res0 libxcb-shape0 libxcb-shm0 libxcb-sync1 libxcb-util1 libxcb-xfixes0 libxcb-xinerama0 libxcb-xinput0 libxcb-xkb1 libxcb-xtest0 libxcomposite1 libxcursor1 libxdamage1 libxdmcp6 libxext6 libxfixes3 libxft2 libxi6 libxinerama1 libxkbcommon0 libxkbcommon-x11-0 libxkbfile1 libxml2 libxml++2.6-2v5 libxmu6 libxpm4 libxrandr2 libxrender1 libxshmfence1 libxt6 libxtst6 libxv1 libxvidcore4 libxxf86vm1 libxxhash0 libz3-4 libzstd1 libzvbi0 libzvbi-common linux-base linux-libc-dev locales login login.defs logsave lvm2 mawk media-types mesa-libgallium mesa-vdpau-drivers mesa-vulkan-drivers mount ncurses-base ncurses-bin netbase netpbm ocl-icd-libopencl1 openssl p11-kit p11-kit-modules passwd perl perl-base perl-modules-5.36 perl-openssl-defaults pinentry-curses pipewire pipewire-bin pipewire-pulse poppler-data poppler-utils procps pulseaudio pulseaudio-module-bluetooth pulseaudio-utils python3 python3.12 python3.12-minimal python3-minimal readline-common rfkill rpcsvc-proto sed sensible-utils shared-mime-info sqlite3 ssl-cert systemd systemd-dev systemd-sysv systemd-timesyncd sysvinit-utils tar tpm-udev tzdata tzdata-legacy ucf udev unzip usr-is-merged util-linux x11-common x11-xkb-utils xdg-user-dirs xfonts-encodings xfonts-utils xkb-data xscreensaver-data xscreensaver-data-extra xscreensaver-gl xscreensaver-gl-extra xz-utils zlib1g zstd
```

## runtime 列表

#### org.deepin.Runtime/20.0.0

使用 uos 1070 仓库制作的 runtime，支持 x86, arm64, loongarch64 三个架构。

_在容器中执行 `cat /runtime/packages.list|awk '{print $2}'` 查看包列表_

```txt
libqt5core5a libqt5gui5 qt5-gtk-platformtheme qt5-flatpak-platformtheme libqt5network5 libqt5opengl5 libqt5sql5 libqt5sql5-mysql libqt5sql5-odbc libqt5sql5-psql libqt5sql5-sqlite libqt5sql5-tds libqt5sql5-ibase libqt5xml5 libqt5dbus5 libqt5test5 libqt5concurrent5 libqt5widgets5 libqt5printsupport5 qtbase5-dev qtbase5-private-dev libqt5opengl5-dev qtbase5-dev-tools qt5-qmake-bin qt5-qmake qtbase5-examples qt5-default qtbase5-doc qtbase5-doc-html libqt5svg5 libqt5svg5-dev qtsvg5-examples qtsvg5-doc qtsvg5-doc-html libqt5qml5 libqt5quick5 libqt5quickparticles5 libqt5quicktest5 libqt5quickwidgets5 qml-module-qtquick-layouts qt5-qmltooling-plugins qml-module-qt-labs-folderlistmodel qml-module-qtquick-localstorage qml-module-qt-labs-sharedimage qml-module-qtqml-models2 qml-module-qtqml-statemachine qml-module-qtquick-particles2 qml-module-qtquick2 qml-module-qtquick-shapes qml-module-qt-labs-handlers qml-module-qt-labs-settings qml-module-qttest qml-module-qtquick-window2 qml-module-qtquick-xmllistmodel qtdeclarative5-dev qtdeclarative5-private-dev qtdeclarative5-dev-tools qmlscene qml qtdeclarative5-examples qtdeclarative5-doc qtdeclarative5-doc-html qml-module-qtgraphicaleffects qtgraphicaleffects5-doc qtgraphicaleffects5-doc-html qml-module-qtquick-controls qml-module-qtquick-extras qml-module-qtquick-dialogs qml-module-qtquick-privatewidgets qtquickcontrols5-examples qtquickcontrols5-doc qtquickcontrols5-doc-html libqt5quickcontrols2-5 libqt5quicktemplates2-5 qml-module-qt-labs-calendar qml-module-qt-labs-platform qml-module-qtquick-controls2 qml-module-qtquick-templates2 qtquickcontrols2-5-dev qtquickcontrols2-5-doc qtquickcontrols2-5-doc-html qtquickcontrols2-5-examples libqt5script5 libqt5scripttools5 qtscript5-dev qtscript5-examples qtscript5-doc qtscript5-doc-html libqt5xmlpatterns5 libqt5xmlpatterns5-dev qtxmlpatterns5-dev-tools qtxmlpatterns5-examples qtxmlpatterns5-doc qtxmlpatterns5-doc-html qt5-image-formats-plugins libqt5location5 libqt5positioningquick5 libqt5positioning5 libqt5location5-plugins libqt5positioning5-plugins qml-module-qtlocation qml-module-qtpositioning qml-module-qt-labs-location qtlocation5-dev qtpositioning5-dev qtlocation5-examples qtlocation5-doc qtlocation5-doc-html libqt5multimedia5 libqt5multimedia5-plugins libqt5multimediaquick5 libqt5multimediawidgets5 qml-module-qtmultimedia qml-module-qtaudioengine libqt5multimediagsttools5 qtmultimedia5-examples qtmultimedia5-dev qtmultimedia5-doc qtmultimedia5-doc-html libqt53dcore5 libqt53dquick5 libqt53dquickrender5 libqt53dinput5 libqt53drender5 libqt53dlogic5 libqt53dquickinput5 libqt53dquickextras5 libqt53dextras5 libqt53dquickscene2d5 libqt53danimation5 libqt53dquickanimation5 qt3d5-dev-tools qt3d-gltfsceneio-plugin qt3d-assimpsceneimport-plugin qt3d-defaultgeometryloader-plugin qt3d-scene2d-plugin qml-module-qt3d qml-module-qtquick-scene3d qml-module-qtquick-scene2d qt3d5-dev qt3d5-examples qt3d5-doc qt3d5-doc-html libqt5charts5 libqt5charts5-dev qml-module-qtcharts qtcharts5-examples qtcharts5-doc qtcharts5-doc-html libqt5bluetooth5 libqt5bluetooth5-bin qml-module-qtbluetooth libqt5nfc5 qml-module-qtnfc qtconnectivity5-dev qtconnectivity5-examples qtconnectivity5-doc qtconnectivity5-doc-html libqt5gamepad5-dev libqt5gamepad5 qtgamepad5-examples libqt5sensors5 qml-module-qtsensors libqt5sensors5-dev qtsensors5-examples qtsensors5-doc qtsensors5-doc-html libqt5texttospeech5-dev libqt5texttospeech5 qtspeech5-flite-plugin qtspeech5-speechd-plugin qtspeech5-examples qtspeech5-doc qtspeech5-doc-html qml-module-qtquick-virtualkeyboard qtvirtualkeyboard-plugin qtvirtualkeyboard5-examples qtvirtualkeyboard5-doc qtvirtualkeyboard5-doc-html libqt5serialport5 libqt5serialport5-dev qt5serialport-examples qtserialport5-doc qtserialport5-doc-html qtnetworkauth5-doc qtnetworkauth5-doc-html libqt5networkauth5-dev qtnetworkauth5-examples libqt5networkauth5 libqt5designer5 libqt5designercomponents5 qdbus-qt5 qdoc-qt5 libqt5help5 qttools5-dev qttools5-private-dev qttools5-dev-tools qt5-assistant qttools5-examples qttools5-doc qttools5-doc-html libqt5x11extras5 libqt5x11extras5-dev qtx11extras5-doc qtx11extras5-doc-html qtwayland5-examples libqt5waylandclient5 libqt5waylandcompositor5 qml-module-qtwayland-compositor qml-module-qtwayland-client-texturesharing libqt5waylandcompositor5-dev libqt5waylandclient5-dev qtwayland5-private-dev qtwayland5-dev-tools qtwayland5 qtwayland5-doc qtwayland5-doc-html lxqt-build-tools libqt5xdg3 libqt5xdgiconloader3 libqt5xdg-dev libqt5xdgiconloader-dev qtxdg-dev-tools libdtkcommon libdtkcommon-dev libdtkcore5 libdtkcore5-bin libdtkcore-dev libdtkcore-doc libdtkgui5 libdtkgui5-bin libdtkgui-dev libdtkgui-doc libdtkwidget5 libdtkwidget5-bin libdtkwidget-dev dtkwidget5-examples dtkwidget-doc googletest googletest-tools libgtest-dev libgmock-dev google-mock dde-qt5integration dde-qt5xcb-plugin dde-qt5wayland-plugin
```

#### org.deepin.Runtime/23.0.1

使用 deepin 23 beta 仓库制作的 runtime，支持 x86 架构。

_在容器中执行 `cat /runtime/packages.list|awk '{print $2}'` 查看包列表_

```txt
libqt5core5a libqt5gui5 qt5-gtk-platformtheme qt5-flatpak-platformtheme qt5-xdgdesktopportal-platformtheme libqt5network5 libqt5opengl5 libqt5sql5 libqt5sql5-mysql libqt5sql5-odbc libqt5sql5-psql libqt5sql5-sqlite libqt5sql5-tds libqt5sql5-ibase libqt5xml5 libqt5dbus5 libqt5test5 libqt5concurrent5 libqt5widgets5 libqt5printsupport5 qtbase5-dev qtbase5-private-dev libqt5opengl5-dev qtbase5-dev-tools qt5-qmake-bin qt5-qmake qtbase5-examples qt5-default qtbase5-doc qtbase5-doc-html qtbase5-doc-dev libqt5svg5 libqt5svg5-dev qtsvg5-examples qtsvg5-doc qtsvg5-doc-html libqt5qml5 libqt5qmlmodels5 libqt5qmlworkerscript5 libqt5quick5 libqt5quickparticles5 libqt5quickshapes5 libqt5quicktest5 libqt5quickwidgets5 qml-module-qtquick-layouts qt5-qmltooling-plugins qml-module-qt-labs-animation qml-module-qt-labs-folderlistmodel qml-module-qtquick-localstorage qml-module-qt-labs-sharedimage qml-module-qt-labs-qmlmodels qml-module-qt-labs-wavefrontmesh qml-module-qtqml qml-module-qtqml-models2 qml-module-qtqml-statemachine qml-module-qtqml-workerscript2 qml-module-qtquick-particles2 qml-module-qtquick2 qml-module-qtquick-shapes qml-module-qt-labs-settings qml-module-qttest qml-module-qtquick-window2 qtdeclarative5-dev qtdeclarative5-private-dev qtdeclarative5-dev-tools qmlscene qml qtdeclarative5-examples qtdeclarative5-doc qtdeclarative5-doc-html qtdeclarative5-doc-dev qml-module-qtgraphicaleffects qtgraphicaleffects5-doc qtgraphicaleffects5-doc-html qml-module-qtquick-controls qml-module-qtquick-extras qml-module-qtquick-dialogs qml-module-qtquick-privatewidgets qtquickcontrols5-examples qtquickcontrols5-doc qtquickcontrols5-doc-html libqt5quickcontrols2-5 libqt5quicktemplates2-5 qml-module-qt-labs-calendar qml-module-qt-labs-platform qml-module-qtquick-controls2 qml-module-qtquick-templates2 qtquickcontrols2-5-dev qtquickcontrols2-5-private-dev qtquickcontrols2-5-doc qtquickcontrols2-5-doc-html qtquickcontrols2-5-examples libqt5script5 libqt5scripttools5 qtscript5-dev qtscript5-examples qtscript5-doc qtscript5-doc-html libqt5xmlpatterns5 libqt5xmlpatterns5-dev qtxmlpatterns5-dev-tools qml-module-qtquick-xmllistmodel qtxmlpatterns5-examples qtxmlpatterns5-doc qtxmlpatterns5-doc-html qt5-image-formats-plugins libqt5location5 libqt5positioningquick5 libqt5positioning5 libqt5location5-plugins libqt5location5-plugin-mapboxgl libqt5positioning5-plugins qml-module-qtlocation qml-module-qtpositioning qml-module-qt-labs-location qtlocation5-dev qtpositioning5-dev qtlocation5-examples qtlocation5-doc qtlocation5-doc-html qtlocation5-doc-dev libqt5multimedia5 libqt5multimedia5-plugins libqt5multimediaquick5 libqt5multimediawidgets5 qml-module-qtmultimedia qml-module-qtaudioengine libqt5multimediagsttools5 qtmultimedia5-examples qtmultimedia5-dev qtmultimedia5-doc qtmultimedia5-doc-html libqt53dcore5 libqt53dquick5 libqt53dquickrender5 libqt53dinput5 libqt53drender5 libqt53dlogic5 libqt53dquickinput5 libqt53dquickextras5 libqt53dextras5 libqt53dquickscene2d5 libqt53danimation5 libqt53dquickanimation5 qt3d5-dev-tools qt3d-gltfsceneio-plugin qt3d-assimpsceneimport-plugin qt3d-defaultgeometryloader-plugin qt3d-scene2d-plugin qml-module-qt3d qml-module-qtquick-scene3d qml-module-qtquick-scene2d qt3d5-dev qt3d5-examples qt3d5-doc qt3d5-doc-html libqt5charts5 libqt5charts5-dev qml-module-qtcharts qtcharts5-examples qtcharts5-doc qtcharts5-doc-html libqt5bluetooth5 libqt5bluetooth5-bin qml-module-qtbluetooth libqt5nfc5 qml-module-qtnfc qtconnectivity5-dev qtconnectivity5-examples qtconnectivity5-doc qtconnectivity5-doc-html libqt5gamepad5-dev libqt5gamepad5 qtgamepad5-examples qml-module-qtgamepad qtgamepad5-doc qtgamepad5-doc-html libqt5sensors5 qml-module-qtsensors libqt5sensors5-dev qtsensors5-examples qtsensors5-doc qtsensors5-doc-html libqt5texttospeech5-dev libqt5texttospeech5 qtspeech5-flite-plugin qtspeech5-speechd-plugin qtspeech5-examples qtspeech5-doc qtspeech5-doc-html libqt5hunspellinputmethod5 libqt5virtualkeyboard5 libqt5virtualkeyboard5-dev qml-module-qtquick-virtualkeyboard qtvirtualkeyboard-plugin qtvirtualkeyboard5-examples qtvirtualkeyboard5-doc qtvirtualkeyboard5-doc-html libqt5serialport5 libqt5serialport5-dev qt5serialport-examples qtserialport5-doc qtserialport5-doc-html qtnetworkauth5-doc qtnetworkauth5-doc-html libqt5networkauth5-dev qtnetworkauth5-examples libqt5networkauth5 libqt5designer5 libqt5designercomponents5 qdbus-qt5 qdbus qdoc-qt5 qhelpgenerator-qt5 qtattributionsscanner-qt5 libqt5help5 qttools5-dev qttools5-private-dev qttools5-dev-tools qt5-assistant qttools5-examples qttools5-doc qttools5-doc-html libqt5x11extras5 libqt5x11extras5-dev qtx11extras5-doc qtx11extras5-doc-html qtwayland5-examples libqt5waylandclient5 libqt5waylandcompositor5 qml-module-qtwayland-compositor qml-module-qtwayland-client-texturesharing libqt5waylandcompositor5-dev libqt5waylandclient5-dev qtwayland5-private-dev qtwayland5-dev-tools qtwayland5 qtwayland5-doc qtwayland5-doc-html qtwebchannel5-doc qtwebchannel5-doc-html libqt5webchannel5-dev qtwebchannel5-examples libqt5webchannel5 qml-module-qtwebchannel libqt5websockets5 libqt5websockets5-dev qml-module-qtwebsockets qml-module-qt-websockets qtwebsockets5-examples qtwebsockets5-doc qtwebsockets5-doc-html qttranslations5-l10n lxqt-build-tools libqt5xdg3 libqt5xdgiconloader3 libqt5xdg-dev libqt5xdgiconloader-dev qtxdg-dev-tools libdtkdata libdtkcommon-dev libdtkcore5 libdtkcore5-bin libdtkcore-dev libdtkcore-doc libdtkgui5 libdtkgui5-bin libdtkgui-dev libdtkgui-doc libdtkwidget5 libdtkwidget5-bin libdtkwidget-dev dtkwidget5-examples dtkwidget-doc qml-module-qtquick-controls2-styles-chameleon libdtkdeclarative5 libdtkdeclarative-dev libdtkdeclarative-doc dtk-exhibition googletest libgtest-dev libgmock-dev google-mock dde-qt5integration dde-qt5xcb-plugin dde-qt5wayland-plugin qtchooser
```

#### org.deepin.runtime.dtk/23.1.0

使用 deepin 23 release 仓库制作的 runtime，支持 x86 架构。

_在容器中执行 `cat /runtime/packages.list|awk '{print $2}'` 查看包列表_

```txt
libqt5core5a libqt5gui5 qt5-gtk-platformtheme qt5-flatpak-platformtheme qt5-xdgdesktopportal-platformtheme libqt5network5 libqt5opengl5 libqt5sql5 libqt5sql5-mysql libqt5sql5-odbc libqt5sql5-psql libqt5sql5-sqlite libqt5sql5-tds libqt5sql5-ibase libqt5xml5 libqt5dbus5 libqt5test5 libqt5concurrent5 libqt5widgets5 libqt5printsupport5 qtbase5-dev qtbase5-private-dev libqt5opengl5-dev qtbase5-dev-tools qt5-qmake-bin qt5-qmake qtbase5-examples qt5-default qtbase5-doc qtbase5-doc-html qtbase5-doc-dev libqt5core5a libqt5gui5 qt5-gtk-platformtheme qt5-flatpak-platformtheme qt5-xdgdesktopportal-platformtheme libqt5network5 libqt5opengl5 libqt5sql5 libqt5sql5-mysql libqt5sql5-odbc libqt5sql5-psql libqt5sql5-sqlite libqt5sql5-tds libqt5sql5-ibase libqt5xml5 libqt5dbus5 libqt5test5 libqt5concurrent5 libqt5widgets5 libqt5printsupport5 qtbase5-dev qtbase5-private-dev libqt5opengl5-dev qtbase5-dev-tools qt5-qmake-bin qt5-qmake qtbase5-examples qt5-default qtbase5-doc qtbase5-doc-html qtbase5-doc-dev libqt5svg5 libqt5svg5-dev qtsvg5-examples qtsvg5-doc qtsvg5-doc-html libqt5qml5 libqt5qmlmodels5 libqt5qmlworkerscript5 libqt5quick5 libqt5quickparticles5 libqt5quickshapes5 libqt5quicktest5 libqt5quickwidgets5 qml-module-qtquick-layouts qt5-qmltooling-plugins qml-module-qt-labs-animation qml-module-qt-labs-folderlistmodel qml-module-qtquick-localstorage qml-module-qt-labs-sharedimage qml-module-qt-labs-qmlmodels qml-module-qt-labs-wavefrontmesh qml-module-qtqml qml-module-qtqml-models2 qml-module-qtqml-statemachine qml-module-qtqml-workerscript2 qml-module-qtquick-particles2 qml-module-qtquick2 qml-module-qtquick-shapes qml-module-qt-labs-settings qml-module-qttest qml-module-qtquick-window2 qtdeclarative5-dev qtdeclarative5-private-dev qtdeclarative5-dev-tools qmlscene qml qtdeclarative5-examples qtdeclarative5-doc qtdeclarative5-doc-html qtdeclarative5-doc-dev qml-module-qtgraphicaleffects qtgraphicaleffects5-doc qtgraphicaleffects5-doc-html qml-module-qtquick-controls qml-module-qtquick-extras qml-module-qtquick-dialogs qml-module-qtquick-privatewidgets qtquickcontrols5-examples qtquickcontrols5-doc qtquickcontrols5-doc-html libqt5quickcontrols2-5 libqt5quicktemplates2-5 qml-module-qt-labs-calendar qml-module-qt-labs-platform qml-module-qtquick-controls2 qml-module-qtquick-templates2 qtquickcontrols2-5-dev qtquickcontrols2-5-private-dev qtquickcontrols2-5-doc qtquickcontrols2-5-doc-html qtquickcontrols2-5-examples qt5-image-formats-plugins libqt5multimedia5 libqt5multimedia5-plugins libqt5multimediaquick5 libqt5multimediawidgets5 qml-module-qtmultimedia qml-module-qtaudioengine libqt5multimediagsttools5 qtmultimedia5-examples qtmultimedia5-dev qtmultimedia5-doc qtmultimedia5-doc-html libqt5texttospeech5-dev libqt5texttospeech5 qtspeech5-flite-plugin qtspeech5-speechd-plugin qtspeech5-examples qtspeech5-doc qtspeech5-doc-html libqt5designer5 libqt5designercomponents5 qdbus-qt5 qdbus qdoc-qt5 qhelpgenerator-qt5 qtattributionsscanner-qt5 libqt5help5 qttools5-dev qttools5-private-dev qttools5-dev-tools qt5-assistant qttools5-examples qttools5-doc qttools5-doc-html libqt5x11extras5 libqt5x11extras5-dev qtx11extras5-doc qtx11extras5-doc-html qtwayland5-examples libqt5waylandclient5 libqt5waylandcompositor5 qml-module-qtwayland-compositor qml-module-qtwayland-client-texturesharing libqt5waylandcompositor5-dev libqt5waylandclient5-dev qtwayland5-private-dev qtwayland5-dev-tools qtwayland5 qtwayland5-doc qtwayland5-doc-html qttranslations5-l10n lxqt-build-tools libqt5xdg3 libqt5xdgiconloader3 libqt5xdg-dev libqt5xdgiconloader-dev qtxdg-dev-tools libdtkdata libdtkcommon-dev libdtkcore5 libdtkcore5-bin libdtkcore-dev libdtkcore-doc libdtkgui5 libdtkgui5-bin libdtkgui-dev libdtkgui-doc libdtkwidget5 libdtkwidget5-bin libdtkwidget-dev dtkwidget5-examples dtkwidget-doc qml-module-qtquick-controls2-styles-chameleon libdtkdeclarative5 libdtkdeclarative-dev libdtkdeclarative-doc dtk-exhibition googletest libgtest-dev libgmock-dev google-mock dde-qt5integration dde-qt5xcb-plugin dde-qt5wayland-plugin
```

#### org.deepin.runtime.dtk/25.2.0

使用 deepin 25 beta 仓库制作的 runtime，支持 x86, arm64, loong64 架构。

_在容器中执行 `cat /runtime/packages.list|awk '{print $2}'` 查看包列表_

```txt
libmtdev1 libqt6core6 libvulkan-dev libinput10 qt6-wayland-private-dev libqt6quick6 libnorm1 libqt6opengl6 qml6-module-qt-labs-qmlmodels libqt6spatialaudio6 libqt6waylandcompositor6 qml6-module-qtquick-dialogs mailcap libqt6sql6-sqlite linguist-qt6 libqt6sql6-psql libsodium23 mime-support libbrotli-dev librist4 libdtk6widget gtk-update-icon-cache libqt6sql6 libjpeg-dev uuid-dev qmake6-bin libqt6xml6 libswscale7 qml6-module-qtwayland-compositor qml6-module-qtqml-base librabbitmq4 libdtk6core libqt6help6 xorg-sgml-doctools libxau-dev qt6-l10n-tools libopenmpt0 qml6-module-qttest libdeflate-dev qml6-module-qtquick3d-spatialaudio firebird3.0-common libqt6quicktemplates2-6 qt6-declarative-dev-tools libqt6sql6-ibase libsrt1.4-gnutls qt6-declarative-private-dev adwaita-icon-theme qml6-module-qtquick-controls2-styles-chameleon qml6-module-qtquick-window libglx-dev libjpeg62-turbo-dev qt6-5compat-dev qt6-wayland-dev-tools xtrans-dev qt6-tools-private-dev qt6-svg-private-dev libqt6qml6 qt6-qmltooling-plugins libcupsimage2-dev libcapstone4 pkg-config libqt6multimedia6 libwebp-dev libqt6qmlmodels6 libpciaccess-dev firebird3.0-common-doc libts0 libevdev2 libqt6quick3druntimerender6 icu-devtools libqt6svg6 qt6-speech-dev libdtk6log-dev qml-qt6 libdtk6widget-bin fonts-texgyre libdpkg-perl qml6-module-qtquick-shapes qml6-module-qmltime libmd4c0 libcolord2 libfontconfig-dev qml6-module-qtqml-workerscript libgstreamer-gl1.0-0 qt6-multimedia-dev qml6-module-qtmultimedia libavformat60 qml6-module-qtquick-effects libicu73 libodbc1 libqt6qmlcompiler6 libx11-dev libqt6quick3dutils6 libqt6svgwidgets6 qt6-tools-dev-tools libdtkcommon-dev libmariadb3 libb2-1 qml6-module-qt-labs-wavefrontmesh libexpat1-dev libsharpyuv-dev libtommath1 libstartup-notification0 libcups2-dev libspdlog1.12 dpkg-dev libcloudproviders0 libqt6printsupport6 libmbedcrypto3 qml6-module-qtquick-tooling liblerc-dev qml6-module-qtquick patch libgirepository-2.0-0 qml6-module-qtquick-particles libqt6shadertools6 qml6-module-qtquick-layouts libbluray2 libxcb-util-dev qt6-declarative-dev libwacom-common libmng1 libgl-dev libfile-find-rule-perl fonts-liberation libselinux1-dev libllvm17 libgtk-3-0 libudfread0 libzstd-dev libdtkdata qt6-speech-flite-plugin libsysprof-capture-4-dev qt6-documentation-tools qt6-gtk-platformtheme libdtk6core-dev qml6-module-qtqml-models libqt6network6 libwayland-bin libqt6test6 libwacom2 libwebpdecoder3 libdtk6log qml6-module-qtquick-localstorage qml6-module-qt5compat-graphicaleffects qml6-module-qt-labs-folderlistmodel qt6-base-private-dev libqt6designer6 libgtk-3-common qml6-module-qtquick-nativestyle libpq5 libicu-dev qt6-speech-speechd-plugin libwacom-dev qt6-image-formats-plugins fcitx5-frontend-qt6 qml6-module-qt-labs-animation dbus-broker libffi-dev libmount-dev libqt6gui6 qml6-module-qtquick-controls libpgm-5.3-0 libdtk6declarative libqt6dbus6 mysql-common libxcb1-dev pkgconf libpkgconf3 libfcitx5-qt-data qml6-module-qtcore libfcitx5-qt6-dev libspeechd2 qml6-module-qt-labs-platform qt6-translations-l10n qmlscene-qt6 dtk6-exhibition libqt6sql6-odbc libqt6designercomponents6 libpcre2-posix3 libdtk6widget-dev dde-qt6xcb-plugin libinput-bin libzmq5 liblzma-dev libjbig-dev libpcre2-dev libdtk6gui-dev libqt6waylandclient6 qml6-module-qt-labs-sharedimage qt6-base-dev libdtk6core-bin python3-packaging libssh-gcrypt-4 libxkbcommon-dev libqt6quickvectorimagegenerator6 libbz2-dev mariadb-common qml6-module-qttexttospeech libdtk6gui-bin libflite1 libgme0 libinput-dev lshw x11proto-dev libqt6quicktest6 libgumbo2 libqt6multimediawidgets6 libpng-dev libqt6wlshellintegration6 liblitehtml0 libpcre2-32-0 libqt6quickwidgets6 libxcb-util0-dev libchromaprint1 qml6-module-qtquick-templates libnumber-compare-perl gir1.2-gudev-1.0 qt6-qmllint-plugins qt6-svg-dev libudev-dev libmpg123-0 libqt6quickcontrols2-6 libqt6openglwidgets6 libwayland-dev libqt6concurrent6 fonts-freefont-otf usrmerge libclang1-17 libopengl-dev libtext-glob-perl libevdev-dev qt6-tools-dev libsepol-dev qml6-module-qtqml qt6-qpa-plugins libfcitx5-qt6-1 qt6-wayland designer-qt6 libvorbisfile3 libgudev-1.0-dev libdtk6declarative-dev qdbus-qt6 libfreetype-dev dde-qt6integration qt6-base-dev-tools libgudev-1.0-0 libqt6widgets6 x11proto-core-dev libcjson1 qml6-module-qt-labs-settings qml6-module-qtwayland-client-texturesharing libqt6texttospeech6 libdtk6gui libblkid-dev fonts-freefont-ttf make libmtdev-dev libglib2.0-dev libtiffxx6 assistant-qt6 libfcitx5utils2 libtiff-dev libclang-cpp17 qml6-module-qtqml-xmllistmodel libfmt10 libqt6core5compat6 libfbclient2 fonts-croscore libqt6quick3d6 libqt6uitools6 libdouble-conversion3 zlib1g-dev libxdmcp-dev libqt6sql6-mysql pkgconf-bin qt6-xdgdesktopportal-platformtheme libglib2.0-dev-bin libpthread-stubs0-dev qt6-wayland-dev qmake6
```

#### org.deepin.runtime.webengine/25.2.0

使用 deepin 25 beta 仓库制作的 runtime，支持 x86, arm64, loong64 架构。

_在容器中执行 `cat /runtime/packages.list|awk '{print $2}'` 查看包列表_

```txt
libmtdev1 libqt6core6 libxslt1.1 libvulkan-dev libinput10 qt6-wayland-private-dev libqt6quick6 libnorm1 libqt6opengl6 qml6-module-qt-labs-qmlmodels libqt6spatialaudio6 libqt6waylandcompositor6 qml6-module-qtquick-dialogs mailcap libqt6sql6-sqlite linguist-qt6 libqt6sql6-psql libsodium23 mime-support libbrotli-dev librist4 libdtk6widget gtk-update-icon-cache libqt6sql6 libjpeg-dev uuid-dev qmake6-bin libqt6xml6 libswscale7 qml6-module-qtwayland-compositor qml6-module-qtqml-base librabbitmq4 libdtk6core libqt6help6 libqt6positioningquick6 xorg-sgml-doctools libxau-dev qt6-l10n-tools libopenmpt0 qml6-module-qtwebengine-controlsdelegates qml6-module-qttest libdeflate-dev qml6-module-qtquick3d-spatialaudio firebird3.0-common libqt6quicktemplates2-6 qt6-declarative-dev-tools libqt6sql6-ibase libsrt1.4-gnutls qt6-declarative-private-dev adwaita-icon-theme qml6-module-qtquick-controls2-styles-chameleon qml6-module-qtquick-window libglx-dev libjpeg62-turbo-dev qt6-5compat-dev qt6-wayland-dev-tools xtrans-dev qt6-tools-private-dev qt6-svg-private-dev libqt6pdf6 libqt6qml6 qt6-qmltooling-plugins libcupsimage2-dev libcapstone4 pkg-config libqt6multimedia6 libqt6webenginewidgets6 libwebp-dev libqt6qmlmodels6 libpciaccess-dev firebird3.0-common-doc libts0 libevdev2 libqt6quick3druntimerender6 icu-devtools libqt6svg6 qt6-speech-dev libdtk6log-dev qml-qt6 libdtk6widget-bin fonts-texgyre libdpkg-perl qml6-module-qtquick-shapes qml6-module-qmltime libmd4c0 libcolord2 libfontconfig-dev qml6-module-qtqml-workerscript libgstreamer-gl1.0-0 qt6-multimedia-dev qml6-module-qtmultimedia libavformat60 qml6-module-qtquick-effects libicu73 libodbc1 libqt6pdfquick6 libqt6qmlcompiler6 libx11-dev qt6-webengine-dev libqt6quick3dutils6 libqt6svgwidgets6 qt6-tools-dev-tools libdtkcommon-dev libmariadb3 libb2-1 qml6-module-qt-labs-wavefrontmesh libexpat1-dev libsharpyuv-dev libtommath1 sse3-support libstartup-notification0 libcups2-dev libspdlog1.12 dpkg-dev libcloudproviders0 libqt6printsupport6 libmbedcrypto3 qml6-module-qtquick-tooling liblerc-dev qml6-module-qtquick patch libgirepository-2.0-0 qml6-module-qtquick-particles libqt6shadertools6 qml6-module-qtquick-layouts qt6-webengine-private-dev libbluray2 qt6-webengine-dev-tools libxcb-util-dev qt6-declarative-dev libwacom-common libmng1 libgl-dev libfile-find-rule-perl fonts-liberation libselinux1-dev libllvm17 libgtk-3-0 libudfread0 libzstd-dev libdtkdata qt6-speech-flite-plugin libsysprof-capture-4-dev qt6-documentation-tools qt6-gtk-platformtheme libdtk6core-dev qml6-module-qtqml-models libqt6network6 libwayland-bin qt6-pdf-dev libqt6test6 libwacom2 libwebpdecoder3 libdtk6log qml6-module-qtquick-localstorage qml6-module-qt5compat-graphicaleffects qml6-module-qt-labs-folderlistmodel isa-support qt6-base-private-dev libqt6designer6 libgtk-3-common qml6-module-qtquick-nativestyle libpq5 libicu-dev qt6-image-formats-plugin-pdf qt6-speech-speechd-plugin libwacom-dev qt6-image-formats-plugins fcitx5-frontend-qt6 qml6-module-qt-labs-animation dbus-broker libffi-dev libmount-dev libqt6gui6 qml6-module-qtquick-controls libqt6positioning6-plugins libpgm-5.3-0 libdtk6declarative libqt6dbus6 mysql-common libxcb1-dev pkgconf libqt6webenginecore6 libpkgconf3 libfcitx5-qt-data qml6-module-qtcore libfcitx5-qt6-dev libspeechd2 qml6-module-qt-labs-platform qt6-translations-l10n qmlscene-qt6 dtk6-exhibition libqt6sql6-odbc libqt6designercomponents6 libpcre2-posix3 libdtk6widget-dev dde-qt6xcb-plugin libinput-bin libqt6webenginecore6-bin libzmq5 liblzma-dev libjbig-dev libpcre2-dev libdtk6gui-dev libqt6waylandclient6 qml6-module-qt-labs-sharedimage qt6-base-dev libdtk6core-bin python3-packaging libssh-gcrypt-4 libxkbcommon-dev libqt6quickvectorimagegenerator6 qml6-module-qtwebchannel qml6-module-qtwebengine libbz2-dev mariadb-common qml6-module-qttexttospeech libdtk6gui-bin libflite1 libgme0 libinput-dev libqt6webengine6-data lshw x11proto-dev libqt6quicktest6 libgumbo2 libqt6multimediawidgets6 libqt6webenginequick6 libpng-dev libqt6wlshellintegration6 libqt6webchannel6 liblitehtml0 libpcre2-32-0 libqt6quickwidgets6 libxcb-util0-dev libchromaprint1 qt6-positioning-dev qml6-module-qtquick-templates libnumber-compare-perl gir1.2-gudev-1.0 qt6-qmllint-plugins qt6-svg-dev libudev-dev libmpg123-0 libqt6quickcontrols2-6 libqt6openglwidgets6 libwayland-dev libqt6serialport6 libqt6concurrent6 fonts-freefont-otf usrmerge qt6-webchannel-dev libclang1-17 libopengl-dev libtext-glob-perl libevdev-dev qt6-tools-dev libsepol-dev libqt6pdfwidgets6 qml6-module-qtqml qml6-module-qtquick-pdf qt6-qpa-plugins libfcitx5-qt6-1 qt6-wayland designer-qt6 libvorbisfile3 libqt6webchannelquick6 libgudev-1.0-dev libdtk6declarative-dev qdbus-qt6 libfreetype-dev dde-qt6integration qt6-base-dev-tools libgudev-1.0-0 libqt6widgets6 x11proto-core-dev libcjson1 qml6-module-qt-labs-settings qml6-module-qtwayland-client-texturesharing libqt6texttospeech6 libdtk6gui libblkid-dev fonts-freefont-ttf make libmtdev-dev libglib2.0-dev libtiffxx6 assistant-qt6 libfcitx5utils2 libtiff-dev libqt6positioning6 libclang-cpp17 qml6-module-qtqml-xmllistmodel libfmt10 libqt6core5compat6 libfbclient2 fonts-croscore libqt6quick3d6 libqt6uitools6 libdouble-conversion3 zlib1g-dev libxdmcp-dev libqt6sql6-mysql pkgconf-bin qt6-xdgdesktopportal-platformtheme libglib2.0-dev-bin libpthread-stubs0-dev qt6-wayland-dev qmake6
```
