# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.billing import BillingManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestBillingManagementInvoicesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(BillingManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_billing_profile(self, resource_group):
        response = self.client.invoices.list_by_billing_profile(
            billing_account_name="str",
            billing_profile_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_download_documents_by_billing_account(self, resource_group):
        response = self.client.invoices.begin_download_documents_by_billing_account(
            billing_account_name="str",
            parameters=[{"documentName": "str", "invoiceName": "str"}],
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_amend(self, resource_group):
        response = self.client.invoices.begin_amend(
            billing_account_name="str",
            invoice_name="str",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_download_by_billing_account(self, resource_group):
        response = self.client.invoices.begin_download_by_billing_account(
            billing_account_name="str",
            invoice_name="str",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_download_summary_by_billing_account(self, resource_group):
        response = self.client.invoices.begin_download_summary_by_billing_account(
            billing_account_name="str",
            invoice_name="str",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_by_billing_account(self, resource_group):
        response = self.client.invoices.get_by_billing_account(
            billing_account_name="str",
            invoice_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_billing_account(self, resource_group):
        response = self.client.invoices.list_by_billing_account(
            billing_account_name="str",
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_download_documents_by_billing_subscription(self, resource_group):
        response = self.client.invoices.begin_download_documents_by_billing_subscription(
            parameters=[{"documentName": "str", "invoiceName": "str"}],
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_download_by_billing_subscription(self, resource_group):
        response = self.client.invoices.begin_download_by_billing_subscription(
            invoice_name="str",
            api_version="2024-04-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get_by_billing_subscription(self, resource_group):
        response = self.client.invoices.get_by_billing_subscription(
            invoice_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_billing_subscription(self, resource_group):
        response = self.client.invoices.list_by_billing_subscription(
            api_version="2024-04-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.invoices.get(
            invoice_name="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...
