# Markdown Style Guide in Chromium

## Style Guide

Please write your Markdown file

*   In accordance with [Google Documentation
    Guide](https://github.com/google/styleguide/tree/gh-pages/docguide)
*   [Limit lines to **80 characters** where
    possible](https://groups.google.com/a/chromium.org/d/msg/chromium-dev/KECdEn562vY/sqRor1frEgAJ)

Unfortunately, `git cl format` will NOT do this for you.

## Documentation Guide

New documentation related to code structure should be put in Markdown. The best
practices recommendation is to put a `README.md` file in the code directory
closest to your component or code.

See [Chromium Documentation
Guidelines](https://chromium.googlesource.com/chromium/src/+/HEAD/docs/documentation_guidelines.md)
for details.

[Here are some
examples](https://cs.chromium.org/search/?q=file:readme.md+-file:/third_party/)
to learn from.

## Making Changes

See [Creating
Documentation](https://chromium.googlesource.com/chromium/src/+/HEAD/docs/README.md#creating-documentation).
