/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     liuzheng <liuzheng@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CLIPDATARECORD_H
#define CLIPDATARECORD_H

#include <vector>
#include <string>
#include <iostream>
#include <fstream>

//#define BUFFSIZE 14400 //(160x90)
using namespace std;
class ClipDataRecord
{
public:
    explicit ClipDataRecord();
    ~ClipDataRecord();

    string getPlainText();
    string getHtmlText();
    vector<string> getUrls();
    string getIntent();
    void setUri(const vector<string> &uris);
    void setImageSize(const int &w, const int &h);

    string getMimeType();
    void setMimeType(const string &str);

    string getDataType();
    void setDataType(const string &str);

    void setData(const char *data, const int &len);
    char *getData(int &len);

    void setDataPath(const string &path);
    string getDataPath();
    int getImgWidth();

    int getImgHeight();

    void save(ofstream &file);
    void load(ifstream &file);

    int getLength();

private:
    bool contains(const string &allstr, const string &inStr);

private:
    string m_datatype;          // 数据类型 字符串  text image大的类型用于剪切板根据类型展示
    int m_width;                // 图片大小
    int m_height;               // 图片大小
    char *m_smalldata;          // 用于缩略图，缩略文本，文件路径等显示
    int  m_smalllen;            // 动态大小
    string m_mimetype;          // 当前数据的类型
    vector<string> m_urls;      // 当前真实数据的url地址(存储文件拷贝地址)
    string m_datapath;          // 数据落盘路径
};

#endif // DWMJACK_H
