/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SCREENSHOT_CONFIG_H
#define SCREENSHOT_CONFIG_H

#include <QObject>

#include <string>
#include <vector>
#include <unordered_map>

typedef std::unordered_map<std::string, std::vector<std::string>> MapWindowPropertyName2StandardValues;

class ScreenShotConfig : public QObject
{

    

    Q_OBJECT
public:
    explicit ScreenShotConfig(QObject *parent = nullptr);

    ~ScreenShotConfig();

    static ScreenShotConfig *instance();

    void initConfig();

signals:

public:
    bool prohibited();
    void setProhibited(bool bProhibited);

    QStringList accessOnPathList();
    QStringList accessOffPathList();
    QStringList accessOnClientClassList();
    QStringList accessOffClientClassList();
    QStringList screenshotToolBlackList();

    void dispatchAttributes();

private:
    static ScreenShotConfig *m_pConfig;

    bool m_prohibited = true;

    QStringList m_accessOnPath;
    QStringList m_accessOffPath;
    QStringList m_accessOnClientClass;
    QStringList m_accessOffClientClass;
    QStringList m_screenshotToolBlackList;

    QList<QMap<QString,QVariant>> m_screenShotAccessList;

};

#endif // SCREENSHOT_CONFIG_H