Progvis
=======

Progvis is a program visualization tool primarily aimed at concurrent programs. Since a key aspect
of understanding the behavior of concurrent programs is to understand what data is shared, Progvis
provides a detailed visualization of memory, including pointers and references. As such, Progvis is
also useful to visualize for example pointer arithmetics in sequential programs as well.

Even though Progvis is able to detect and report concurrency issues that have happened in the
visualization, it is difficult to make sure that a program is *free from* concurrency issue. Doing
so would require trying all possible interleavings of the threads spawned by the program, which
quickly gets tedious. To aid further, Progvis provides a *model checker* that is able to
automatically find any concurrency errors in small programs. If it finds one, it illustrates the
issue by providing an example interleaving.

While Progvis is designed to visualize programs written in the C language, it is mostly language
agnostic thanks to Storm. Progvis delegates parsing and compilation to Storm, and instruments the
resulting intermediate representation. This way, Progvis supports all languages supported by Storm
out of the box. However, the quality of visualizations differ greatly as Progvis does not
necessarily know of language-specific constructs that benefit from a customized visualization.


Starting Progvis
----------------

To run Progvis, first [download Storm](md:/Downloads), extract the archive, and finally click the
`Progvis` file (either `Progvis.bat` or `Progvis.sh` depending on your system). The main window of
Progvis will appear shortly thereafter. You can also start Progvis from the interactive Storm prompt
by typin `progvis:main`, or from the command line by typing `storm -f progvis.main`.

If you are running Ubuntu or Debian, you can install storm through your package manager (`sudo apt install progvis`).
This will create a launcher in your system menu, and provide the command `progvis`.


Learn concurrent programming
----------------------------

The book [Introduction to Concurrent Programming in C](md:Concurrency_book) provides an in-depth
introduction to concurrent programming in C and relies heavily on Progvis for its explanations,
examples, and exercises. Furthermore, the first chapters of the book gives an introduction both to
Progvis itself and the synchronization primitives provided by Progvis.


Supported languages
-------------------

As mentioned previously, Progvis technically supports all languages in Storm to some degree.
However, since Progvis might need appropriate medatata from the language (for introspection and
custom visualizations), support varies a bit in practice. The support is as follows:

* **C** is the main driving force behind Progvis, and as such a larger part of the language is
  supported (but not much of the standard library). Progvis contains its own implementation of C/C++
  in `progvis.lang.cpp`. A large part of the language is implemented and works as intended. The
  implementation is geared towards being used in Progvis, however, and as such pointer safety is
  prioritized above execution speed. As such, the implementation inserts array bounds checks among
  other things to avoid unnecessary crashes, and use after free errors. Type casting is also limited
  to some extent to avoid corrupting memory and crashing the system. The implementation provides a
  set of synchronization primitives that can be used from C that are available in the package
  `progvis.lang.cpp.runtime`. The directory `root/progvis_demo` contains a number of examples that
  show how they are used.

* `C++` is also supported to some extent. The C/C++ frontend implements enough of the language to
  show how central parts of the language behave. For example, pointers, references, classes with
  copy- and move semantics. Most notably, templates and the standard library are currently missing
  from the implementation.

* **Basic Storm** works well for mostly sequential programs. Progvis does yet not understand the
  standard synchronization primitives and will thus not visualize them properly. Furthermore, a
  suitable visualization is not yet available for all types in the standard library. Some of the
  types there will appear in either too much or too little detail.
