# Indian Vedic

## Introduction

Vedic sky culture with some commonly known constellations related to Nakṣatra-s.

## Description

### <notr>Rāśi (राशिः)</notr>

The sidereal zodiac is an imaginary belt of 360 degrees (like the tropical zodiac), divided into 12 equal parts. Each twelfth part (of 30 degrees) is called a sign or rashi. Their names are shown in (brackets).

In stellarium, we show Rāśi constellations attached to the corresponding asterisms, and not as divisions of the ecliptic offset away from their original locations to account for precession.

In traditional astronomy there are two systems of measuring time - Lunar Calendar & Solar calendar. In both cases one year is divided into 12 months or "māsā". Name of the solar months originated from these constellation' names.

### <notr>Nakṣatra (नक्षत्रम्)</notr>

In Hindu tradition the ecliptic is divided into 27 parts of approximately 13°20', which correspond with 27 asterisms known as the nakṣatra-s (full list, with western equivalents here: https://en.wikipedia.org/wiki/Nakshatra ). In the earliest extant layers of the tradition this number is 28. This division is critical for several purposes including timing rituals and determining the birth lunar mansions. Since these asterisms define an area in the sky, they are also technically constellations.

sUrya-siddhAnta and vedAnga-jyotiSha specify start coordinates for the 13°20' divisions using some stars (Please see penultimate paragraph in [this page](https://archive.org/stream/HistoryOfCalendarPanchangaCommittee/History-of-Calendar-Panchanga-Committee#page/n42/mode/1up))

The earliest complete nakṣatra lists are found in the Taittirīya-śruti and the Atharvaveda where they are recited as part of the nakṣatreṣṭi ritual which places the deities of pantheon in these celestial compartments. Some scholars opine that the tradition shows that by the early medieval period, the nakṣatra identification had changed to a small degree from the Vedic period.

There are multiple rich mythologies and symbolisms associated with the same constellations and stars (Example: [Raj Vedam on Rohini](https://www.youtube.com/watch?v=Jq__DXtfeXw)) - it wouldn't do to rely on one to the exclusion of others during translation or truncated description. Hence we stick to etymological translations; and rather than including long mythological accounts here, just suggest that interested readers delve into them separately. (See references below.)

Name of the lunar months originated from those 12 divisions' names in which full moon or "Purnimā" occurs. Unlike a solar day which defined by a sunrise to next sunrise, a lunar day or moon's position in a nakshatra doesn't depends on sun rising or moon rising. Thus a lunar day may start in any time of a solar day. Like other ancient human cultures, vedic people innovated a number of systems of which intercalary lunar months became most used, that is adding another month every 32.5 months on average or 4 months in every 11 years to correct the mismatch between lunar and solar year.

A few of the yogatārā-s or prominent asterisms in the nakṣatra-s (going by their mainstream identification) lie slightly outside their constellation boundaries - in which case, any resultant problem (with regards to ritual timing or astrology) should be solved by other means (some people propose alternate identifications for such yogatārā-s).

### Navagraha - Nine "planets"

They observed that some celestial body moves independently relative to background stars and named them "planets" or "graha". As such The sun and moon are also treated as graha. They also named the lunar nodes as graha-s as these points are very important to calculate the eclipses. Name of vedic days originated from these planet's names.

|Graha|Designation|Name of Solar days|
|-----|-----------|------------------|
|<notr>Sūrya </notr>(Sun)|Sun God|<notr>Ravivāsara </notr>(Sunday)|
|<notr>Chandra/Soma </notr>(Moon)|Moon god|<notr>Somavāsara </notr>(Monday)|
|<notr>Maṅgala </notr>(Mars)|God of war|<notr>Maṅgalavāsara </notr>(Tuesday)|
|<notr>Budha </notr>(Mercury)|Son of Moon|<notr>Budhavāsara </notr>(Wednesday)|
|<notr>Bṛihaspati/Guru </notr>(Jupiter)|Teacher of Gods|<notr>Guruvāsara </notr>(Thursday)|
|<notr>Śukra </notr>(Venus)|Mentor of Demons|<notr>Śukravāsara </notr>(Friday)|
|<notr>Śani </notr>(Saturn)|God of Misfortune|<notr>Śanivāsara </notr>(Saturday)|
|<notr>Rahu</notr>|lunar node|-|
|<notr>Ketú</notr>|lunar node|-|

## References

 - [#1]: [Nakshatra](https://sa.wikipedia.org/wiki/नक्षत्रम्) article at Sanskrit Wikipedia
 - [#2]: [Nakshatra](http://en.wikipedia.org/wiki/Nakshatra) article at English Wikipedia
 - [#3]: [History Of Calendar-Panchanga Committee Report](https://archive.org/stream/HistoryOfCalendarPanchangaCommittee/History-of-Calendar-Panchanga-Committee#page/n77/mode/2up)
 - [#4]: ["Possible period of the design of Nakshatras and Abhijit"](http://www.tifr.res.in/~archaeo/papers/Others/Possible%20period%20of%20the%20design%20of%20Nakshatras.pdf)

   <!--Much of the below is available online for free at archive.org.-->

 - [#5]: Secondary references such as: Purana Encyclopedia, Purana Index, Mahabharata Index, Vedic Indix
 - [#6]: Vedas, Agamas
 - [#7]: [Vedic Chronology And Vedanga Jyotisha by Bala Gangadhar Tilak](https://archive.org/details/vedicchronologya033083mbp/page/n5)
 - [#8]: [Orion The Antiquity Of The Vedas by Bala Gangadhar Tilak](https://archive.org/details/in.gov.ignca.5110)
 - [#9]: [The Arctic Home in the Vedas by Bal Gangadhar Tilak](https://archive.org/details/arctichm/page/n21/mode/2up)
 - [#10]: [Hamlet's Mill: An Essay on Myth & the Frame of Time by Giorgio de Santillana, Hertha von Dechend](https://archive.org/details/HamletsMill)

## Authors

 - Tanmoy Saha
 - Contributors from the [sanskrit-coders community](https://github.com/sanskrit-coders) (esp [Vishvas Vasuki](https://github.com/vvasuki/)).

## License

CC BY-SA 4.0
