#! /bin/sh

if [ "${AUTOPKGTEST_TMP}" = "" ]
then
    AUTOPKGTEST_TMP=$(mktemp -d /tmp/${pkg}-test.XXXXXX)
    # Double quote below to expand the temporary directory variable now
    # versus later is on purpose.
    # shellcheck disable=SC2064
    trap "rm -rf ${AUTOPKGTEST_TMP}" 0 INT QUIT ABRT PIPE TERM
fi
cd "$AUTOPKGTEST_TMP"

cat > test-rocm-core-version.cpp << END
// disable warning about relying on rocm core version
#define NO_ROCMCORE_VERSION_WARNING

#include <cstdint>
#include <cstdio>
#include <cinttypes>

#include <rocm-core/rocm_version.h>


int main()
{
    unsigned int major=0,minor=0,patch=0,ret=0;

    ret = getROCmVersion(&major,&minor,&patch);

    if(ret !=VerSuccess )
    {
        std::printf("ERROR: recieved return code from getROCMVersion: %d\n", ret);
        return 255;
    }

    else
    {
        std::printf("SUCCESS: ROCm Version from rocm-core detected as: %d.%d.%d\n", major, minor, patch);
        return 0;
    }

}
END

echo '$ cat test-rocm-core-version.cpp'
cat test-rocm-core-version.cpp
echo "$ g++ -o test-rocm-core-version test-rocm-core-version.cpp -lrocm-core"
g++ -o test-rocm-core-version test-rocm-core-version.cpp -lrocm-core

./test-rocm-core-version
exit $?
