% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringsim.R
\name{seq_sim}
\alias{seq_sim}
\title{Compute similarity scores between sequences of integers}
\usage{
seq_sim(
  a,
  b,
  method = c("osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw"),
  q = 1,
  ...
)
}
\arguments{
\item{a}{\code{list} of \code{integer} vectors (target)}

\item{b}{\code{list} of \code{integer} vectors (source). Optional for
\code{seq_distmatrix}.}

\item{method}{Method for distance calculation. The default is \code{"osa"}, 
see \code{\link{stringdist-metrics}}.}

\item{q}{Size of the \eqn{q}-gram; must be nonnegative. Only applies to
\code{method='qgram'}, \code{'jaccard'} or \code{'cosine'}.}

\item{...}{additional arguments are passed on to \code{\link{seq_dist}}.}
}
\value{
A \code{numeric} vector of length \code{max(length(a),length(b))}. If one of the
entries in \code{a} or \code{b} is \code{NA_integer_}, all comparisons with that
element result in \code{NA}. Missings occurring within the sequences are treated
as an ordinary number (the representation of \code{NA_integer_}).
}
\description{
Compute similarity scores between sequences of integers
}
\examples{
L1 <- list(1:3,2:4)
L2 <- list(1:3)
seq_sim(L1,L2,method="osa")

# note how missing values are handled (L2 is recycled over L1)
L1 <- list(c(1L,NA_integer_,3L),2:4,NA_integer_)
L2 <- list(1:3)
seq_sim(L1,L2)

}
\seealso{
\code{\link{seq_dist}}, \code{\link{seq_amatch}}
}
