% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liberation.R
\name{register_liberationserif}
\alias{register_liberationserif}
\title{Register font 'Liberation Serif'}
\usage{
register_liberationserif(name = "Liberation Serif")
}
\arguments{
\item{name}{the name to use for the font family when
registering with 'systemfonts'. Using a custom name
(e.g. \code{"sans"}, \code{"serif"}, \code{"mono"}) allows devices like
'ragg' to resolve generic family names to this font.}
}
\value{
TRUE if the operation went ok.
}
\description{
Register font 'Liberation Serif' so that it can be used
with devices using the 'systemfonts' package, i.e. the 'flextable'
package and graphic outputs generated with the 'ragg', 'svglite'
and 'ggiraph' packages.
}
\examples{
register_liberationserif()
register_liberationserif(name = "serif")
}
\seealso{
\code{\link[=font_set_liberation]{font_set_liberation()}}, \code{\link[=font_set]{font_set()}}

Other functions for font management: 
\code{\link{addGFontHtmlDependency}()},
\code{\link{fonts_cache_dir}()},
\code{\link{gfontHtmlDependency}()},
\code{\link{install_gfont_script}()},
\code{\link{installed_gfonts}()},
\code{\link{liberationmonoHtmlDependency}()},
\code{\link{liberationsansHtmlDependency}()},
\code{\link{liberationserifHtmlDependency}()},
\code{\link{register_gfont}()},
\code{\link{register_liberationmono}()},
\code{\link{register_liberationsans}()}
}
\concept{functions for font management}
