% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_set.R
\name{font_set}
\alias{font_set}
\title{Create a font set}
\usage{
font_set(sans = NULL, serif = NULL, mono = NULL, symbol = NULL)
}
\arguments{
\item{sans}{font for sans-serif text.}

\item{serif}{font for serif text.}

\item{mono}{font for monospace text.}

\item{symbol}{font for symbol text.}
}
\value{
An object of class \code{font_set} with elements:
\describe{
\item{sans}{character, the sans font family name (or NULL)}
\item{serif}{character, the serif font family name (or NULL)}
\item{mono}{character, the mono font family name (or NULL)}
\item{symbol}{character, the symbol font family name (or NULL)}
\item{dependencies}{list of \code{htmlDependency} objects}
\item{dsvg_fonts}{named list of family names for \code{dsvg()}}
\item{sources}{named list of source labels}
}
}
\description{
Bundle font registration, HTML dependencies, and
font family names into a single object. Each argument accepts
a \code{\link[=font_google]{font_google()}} specification, a \code{\link[=font_liberation]{font_liberation()}} specification,
or a plain character string naming a system font already available.

The returned object provides fields ready to use with
\code{\link[ggplot2:theme]{ggplot2::theme()}} (\verb{$sans}, \verb{$serif}, \verb{$mono}),
\code{girafe(fonts = ...)} or \code{dsvg(fonts = ...)} (\verb{$dsvg_fonts}),
and \code{girafe(dependencies = ...)} (\verb{$dependencies}).
}
\examples{
fonts <- font_set(sans = font_liberation("sans"))
fonts$sans
fonts$dsvg_fonts
fonts$dependencies
}
\seealso{
\code{\link[=font_set_liberation]{font_set_liberation()}}, \code{\link[=font_set_auto]{font_set_auto()}}

Other font set functions: 
\code{\link{font_google}()},
\code{\link{font_liberation}()},
\code{\link{font_set_auto}()},
\code{\link{font_set_liberation}()}
}
\concept{font set functions}
