# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessProfileType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name which contains the role of the kubeconfig."""

    CLUSTER_USER = "clusterUser"
    CLUSTER_CUSTOMER_USER = "clusterCustomerUser"


class ArtifactType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Appliance ArtifactType definition."""

    LOGS_ARTIFACT_TYPE = "LogsArtifactType"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class Distro(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents a supported Fabric/Infra. (AKSEdge etc...)."""

    AKS_EDGE = "AKSEdge"


class Provider(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Information about the connected appliance."""

    VM_WARE = "VMWare"
    HCI = "HCI"
    SCVMM = "SCVMM"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    NONE = "None"


class SSHKeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Appliance SSHKeyType definition."""

    SSH_CUSTOMER_USER = "SSHCustomerUser"
    MANAGEMENT_CA_KEY = "ManagementCAKey"
    LOGS_KEY = "LogsKey"
    SCOPED_ACCESS_KEY = "ScopedAccessKey"
    USER_MANAGEMENT_KEY = "UserManagementKey"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Appliance’s health and state of connection to on-prem. This list of values is not exhaustive."""

    WAITING_FOR_HEARTBEAT = "WaitingForHeartbeat"
    VALIDATING = "Validating"
    CONNECTING = "Connecting"
    CONNECTED = "Connected"
    RUNNING = "Running"
    PREPARING_FOR_UPGRADE = "PreparingForUpgrade"
    ETCD_SNAPSHOT_FAILED = "ETCDSnapshotFailed"
    UPGRADE_PREREQUISITES_COMPLETED = "UpgradePrerequisitesCompleted"
    VALIDATING_SFS_CONNECTIVITY = "ValidatingSFSConnectivity"
    VALIDATING_IMAGE_DOWNLOAD = "ValidatingImageDownload"
    VALIDATING_IMAGE_UPLOAD = "ValidatingImageUpload"
    VALIDATING_ETCD_HEALTH = "ValidatingETCDHealth"
    PRE_UPGRADE = "PreUpgrade"
    UPGRADING_KVAIO = "UpgradingKVAIO"
    WAITING_FOR_KVAIO = "WaitingForKVAIO"
    IMAGE_PENDING = "ImagePending"
    IMAGE_PROVISIONING = "ImageProvisioning"
    IMAGE_PROVISIONED = "ImageProvisioned"
    IMAGE_DOWNLOADING = "ImageDownloading"
    IMAGE_DOWNLOADED = "ImageDownloaded"
    IMAGE_DEPROVISIONING = "ImageDeprovisioning"
    IMAGE_UNKNOWN = "ImageUnknown"
    UPDATING_CLOUD_OPERATOR = "UpdatingCloudOperator"
    WAITING_FOR_CLOUD_OPERATOR = "WaitingForCloudOperator"
    UPDATING_CAPI = "UpdatingCAPI"
    UPDATING_CLUSTER = "UpdatingCluster"
    POST_UPGRADE = "PostUpgrade"
    UPGRADE_COMPLETE = "UpgradeComplete"
    UPGRADE_CLUSTER_EXTENSION_FAILED_TO_DELETE = "UpgradeClusterExtensionFailedToDelete"
    UPGRADE_FAILED = "UpgradeFailed"
    OFFLINE = "Offline"
    NONE = "None"
    NETWORK_PROXY_UPDATE_PREPARING = "NetworkProxyUpdatePreparing"
    NETWORK_PROXY_UPDATING = "NetworkProxyUpdating"
    NETWORK_PROXY_UPDATE_COMPLETE = "NetworkProxyUpdateComplete"
    NETWORK_PROXY_UPDATE_FAILED = "NetworkProxyUpdateFailed"
    NETWORK_DNS_UPDATE_PREPARING = "NetworkDNSUpdatePreparing"
    NETWORK_DNS_UPDATING = "NetworkDNSUpdating"
    NETWORK_DNS_UPDATE_COMPLETE = "NetworkDNSUpdateComplete"
    NETWORK_DNS_UPDATE_FAILED = "NetworkDNSUpdateFailed"
    ARC_GATEWAY_UPDATE_PREPARING = "ArcGatewayUpdatePreparing"
    ARC_GATEWAY_UPDATING = "ArcGatewayUpdating"
    ARC_GATEWAY_UPDATE_COMPLETE = "ArcGatewayUpdateComplete"
    ARC_GATEWAY_UPDATE_FAILED = "ArcGatewayUpdateFailed"
