# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.communication import CommunicationServiceManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestCommunicationServiceManagementSuppressionListAddressesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(CommunicationServiceManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_suppression_list_addresses_list(self, resource_group):
        response = self.client.suppression_list_addresses.list(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            suppression_list_name="str",
            api_version="2025-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_suppression_list_addresses_get(self, resource_group):
        response = self.client.suppression_list_addresses.get(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            suppression_list_name="str",
            address_id="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_suppression_list_addresses_create_or_update(self, resource_group):
        response = self.client.suppression_list_addresses.create_or_update(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            suppression_list_name="str",
            address_id="str",
            parameters={
                "dataLocation": "str",
                "email": "str",
                "firstName": "str",
                "id": "str",
                "lastModified": "2020-02-20 00:00:00",
                "lastName": "str",
                "name": "str",
                "notes": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_suppression_list_addresses_delete(self, resource_group):
        response = self.client.suppression_list_addresses.delete(
            resource_group_name=resource_group.name,
            email_service_name="str",
            domain_name="str",
            suppression_list_name="str",
            address_id="str",
            api_version="2025-09-01",
        )

        # please add some check logic here by yourself
        # ...
