# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.netapp import NetAppManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetAppManagementPoolsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetAppManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pools_get(self, resource_group):
        response = self.client.pools.get(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pools_begin_create_or_update(self, resource_group):
        response = self.client.pools.begin_create_or_update(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            body={
                "location": "str",
                "properties": {
                    "serviceLevel": "str",
                    "size": 0,
                    "coolAccess": bool,
                    "customThroughputMibps": 0,
                    "encryptionType": "str",
                    "poolId": "str",
                    "provisioningState": "str",
                    "qosType": "str",
                    "totalThroughputMibps": 0.0,
                    "utilizedThroughputMibps": 0.0,
                },
                "etag": "str",
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pools_begin_update(self, resource_group):
        response = self.client.pools.begin_update(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
            body={
                "id": "str",
                "location": "str",
                "name": "str",
                "properties": {"coolAccess": bool, "customThroughputMibps": 0, "qosType": "str", "size": 0},
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pools_begin_delete(self, resource_group):
        response = self.client.pools.begin_delete(
            resource_group_name=resource_group.name,
            account_name="str",
            pool_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_pools_list(self, resource_group):
        response = self.client.pools.list(
            resource_group_name=resource_group.name,
            account_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
