/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import javax.servlet.ServletConfig;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.rundata.JetspeedRunDataService;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.UsageSession;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericPortalService;
import org.chefproject.util.StringUtil;

public class ChefJetspeedPortalService
extends TurbineBaseService
implements GenericPortalService {
    protected JetspeedRunDataService m_runDataService = null;

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()");
        this.m_runDataService = (JetspeedRunDataService)TurbineServices.getInstance().getService("RunDataService");
        if (this.m_runDataService == null) {
            throw new InitializationException("ChefJetspeedPortalService is missing service: RunDataService");
        }
    }

    public void shutdown() {
        this.m_runDataService = null;
        Log.info("chef", this + ".shutdown()");
        super.shutdown();
    }

    public String getCurrentSiteId() {
        JetspeedRunData data = this.m_runDataService.getCurrentRunData();
        Profile profile = data.getProfile();
        if (profile == null) {
            Log.warn("chef", this + "getCurrentSiteId(): no profile");
            return SiteService.getSpecialSiteId("");
        }
        String rv = null;
        if (profile.getUserName() != null) {
            rv = SiteService.getUserSiteId(profile.getUserName());
        } else if (profile.getGroupName() != null) {
            rv = profile.getGroupName();
        } else if (profile.getRoleName() != null) {
            if (profile.getRoleName().equals("user")) {
                try {
                    rv = SiteService.getUserSiteId(UsageSessionService.getSessionUser().getId());
                }
                catch (Exception ignore) {}
            }
        } else {
            Log.warn("chef", this + "getCurrentSiteId(): no channel configuration: " + profile.toString());
            rv = SiteService.getSpecialSiteId("");
        }
        return rv;
    }

    public String getCurrentSitePageId() {
        String paneInRequest;
        JetspeedRunData data = this.m_runDataService.getCurrentRunData();
        String pane = null;
        String rootId = data.getProfile().getDocument().getPortlets().getId();
        SessionState panestate = data.getPortletSessionState(rootId);
        if (panestate != null) {
            pane = (String)panestate.getAttribute("js_pane");
        }
        if ((paneInRequest = StringUtil.trimToNull(data.getParameters().getString("js_pane"))) != null) {
            pane = paneInRequest;
        }
        if (pane == null) {
            pane = data.getProfile().getDocument().getPortlets().getPortlets(0).getId();
        }
        return pane;
    }

    public String getCurrentToolId() {
        JetspeedRunData data = this.m_runDataService.getCurrentRunData();
        String toolId = data.getJs_peid();
        return toolId;
    }

    public SessionState getCurrentToolState() {
        JetspeedRunData data = this.m_runDataService.getCurrentRunData();
        String toolId = data.getJs_peid();
        SessionState state = data.getPortletSessionState(toolId);
        return state;
    }

    public String getCurrentLocationId() {
        JetspeedRunData data = this.m_runDataService.getCurrentRunData();
        String peid = data.getJs_peid();
        return this.getCurrentLocationId(peid);
    }

    public String getCurrentLocationId(String id) {
        String location = SiteService.siteReference(this.getCurrentSiteId());
        if (id != null) {
            location = location + "/" + id;
        }
        return location;
    }

    public String getCurrentClientWindowId() {
        UsageSession session = UsageSessionService.getSession();
        String sessionId = "";
        if (session != null) {
            sessionId = session.getId();
        }
        String location = this.getCurrentLocationId();
        String rv = sessionId + location;
        return rv;
    }

    public String getCurrentClientWindowId(String id) {
        UsageSession session = UsageSessionService.getSession();
        String sessionId = "";
        if (session != null) {
            sessionId = session.getId();
        }
        String location = this.getCurrentLocationId(id);
        String rv = sessionId + location;
        return rv;
    }
}

