/*
 * Copyright University of Reims Champagne-Ardenne
 * Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN,
 *                           Emmanuel PLUOT, Gaetan RUBEZ, Hassan KHARTABIL,
 *                           Jean-Charles BOISSON and Eric HENON
 * (24/07/2017)
 * jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr
 *
 * This software is a computer program whose purpose is to
 * detect and quantify interactions from electron density
 * obtained either internally from promolecular density or
 * calculated from an input wave function input file. It also
 * prepares for the visualization of isosurfaces representing
 * several descriptors (dg) coming from the IGM methodology.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 *
 * */

/**
 * @file vmdKeywords.h
 * @brief Definition of VMD Keywords */

#ifndef _VMDKEYWORDS_H_
#define _VMDKEYWORDS_H_

//! The VMD script's intern keywords indexes
typedef enum KEYWORD_INDEXES
  {
    DGINTER,						/**< Path to Delta G inter cube file	*/
    DGINTRA,						/**< Path to Delta G intra cube file	*/
    DENS,							/**< Path to rho cube file 	*/
    RDG,                                                    /**< Path to RDG cube file          */
    PERCENT,						/**< Path to percent data file	 	*/
    COMPLEX,						/**< Path to the complex file created	*/
    CUTPLOT1,						/**< cutplot[0] value			*/
    CUTPLOT2,						/**< cutplot[1] value			*/
    CUTPLOTIGM1,                                            /**< cutplotIGM[0] value            */
    CUTPLOTIGM2,                                            /**< cutplotIGM[1] value            */
    CUTPLOTIGM3,                                            /**< TO DOCUMENT                    */
    CUTPLOTIGM4,                                            /**< TO DOCUMENT                    */
    VMDCOLRANGIGM1,                                         /**< vmdcolrangIGM[0] value         */
    VMDCOLRANGIGM2,                                         /**< vmdcolrangIGM[1] value         */
    CUTOFFS1,						/**< cutoffs[0] value			*/
    CUTOFFS2,						/**< cutoffs[1] value			*/
    FRAG1Def,                                           /**< fragment 1 definition              */
    FRAG2Def,                                           /**< fragment 2 definition              */
  //  FIRST_PROT_INDEX,				/**< Index of first atom of molecule B      	*/
  //  LAST_COMPLEX_INDEX,				/**< Index of last atom of all complex  */
  //  LAST_LIG_INDEX,					/**< Index of last atom in molecule A	*/
    MAX_PERCENT,					/**< Maximum percentage found 		*/
    ATOMDOIDAT,                                         /**< Path to AtomDOI.dat file           */
    XYZ,                                                /**< Path to .xyz file                  */
    DGATWEAKMAX,             /**< maximum value of atomic contrib to wean non-covalent contacts */
    ELFcube,                                                /**< Path to ELF cube file          */
    ELF_IGMcolor,                                           /**< Path to ELF_IGMcolor cube file */
    ELF_isovalue,           /**< isovalue used to build ELF isosurfaces with VMD                */
    SELFcube,
    SELFATOMDAT,                        /**< name of the file providing atomic contrib. to SELF */
    SELFMAX,             /**< maximum value of the pauli repulsion detected by SELF methodology */
    SELFMIN,             /**< minimum value of the pauli repulsion detected by SELF methodology */ 
    DGSCALEDMAX,                                          /**< maximum value of the dg/rho cube */
    isSELFAtomic,                                      /**< to properly write the self.vmd file */
    SELFMAXCOLOR,                         // pauli value    used for coloring dg/rho isosurface */
    SIZE_KEYWORDS
  }keywords_t;

#endif
